/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.run;

import com.android.ddmlib.IDevice;
import com.intellij.debugger.engine.RemoteDebugProcessHandler;
import com.intellij.debugger.ui.DebuggerPanelsManager;
import com.intellij.debugger.ui.DebuggerSessionTab;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RemoteState;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.DefaultProgramRunner;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.ExecutionConsoleEx;
import com.intellij.execution.ui.ObservableConsoleView;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiClass;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.xdebugger.DefaultDebugProcessHandler;
import com.intellij.xdebugger.XDebuggerBundle;
import icons.AndroidIcons;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.android.dom.manifest.Instrumentation;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.logcat.AndroidLogcatView;
import org.jetbrains.android.logcat.AndroidToolWindowFactory;
import org.jetbrains.android.run.AndroidExecutionState;
import org.jetbrains.android.run.AndroidProcessText;
import org.jetbrains.android.run.AndroidRunConfigurationBase;
import org.jetbrains.android.run.AndroidRunningState;
import org.jetbrains.android.run.AndroidRunningStateListener;
import org.jetbrains.android.run.AndroidSessionInfo;
import org.jetbrains.android.run.DebugLauncher;
import org.jetbrains.android.run.testing.AndroidTestRunConfiguration;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidDebugRunner
extends DefaultProgramRunner {
    public static final Key<AndroidSessionInfo> ANDROID_SESSION_INFO = new Key("ANDROID_SESSION_INFO");
    private static final Object myDebugLock = new Object();
    @NonNls
    private static final String ANDROID_DEBUG_SELECTED_TAB_PROPERTY = "ANDROID_DEBUG_SELECTED_TAB_";
    public static final String ANDROID_LOGCAT_CONTENT_ID = "Android Logcat";

    private static void tryToCloseOldSessions(final Executor executor, Project project) {
        ProcessHandler[] processes;
        final ExecutionManager manager = ExecutionManager.getInstance((Project)project);
        for (ProcessHandler process : processes = manager.getRunningProcesses()) {
            final AndroidSessionInfo info = (AndroidSessionInfo)process.getUserData(ANDROID_SESSION_INFO);
            if (info == null) continue;
            process.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(ProcessEvent event) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            manager.getContentManager().removeRunContent(executor, info.getDescriptor());
                        }
                    });
                }
            });
            process.detachProcess();
        }
    }

    protected RunContentDescriptor doExecute(final @NotNull Project project, @NotNull RunProfileState state, RunContentDescriptor contentToReuse, final @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/run/AndroidDebugRunner", "doExecute"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/run/AndroidDebugRunner", "doExecute"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/android/run/AndroidDebugRunner", "doExecute"));
        }
        assert (state instanceof AndroidRunningState);
        AndroidRunningState runningState = (AndroidRunningState)state;
        final RunContentDescriptor[] descriptor = new RunContentDescriptor[]{null};
        runningState.addListener(new AndroidRunningStateListener(){

            @Override
            public void executionFailed() {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (descriptor[0] != null) {
                            AndroidDebugRunner.showNotification(project, environment.getExecutor(), descriptor[0], "error", false, NotificationType.ERROR);
                        }
                    }
                });
            }
        });
        descriptor[0] = this.doExec(project, runningState, contentToReuse, environment);
        return descriptor[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RunContentDescriptor doExec(Project project, AndroidRunningState state, RunContentDescriptor contentToReuse, ExecutionEnvironment environment) throws ExecutionException {
        RunContentDescriptor runDescriptor;
        if (DefaultRunExecutor.EXECUTOR_ID.equals(environment.getExecutor().getId())) {
            RunContentDescriptor descriptor = super.doExecute(project, (RunProfileState)state, contentToReuse, environment);
            if (descriptor != null) {
                AndroidDebugRunner.setActivateToolWindowWhenAddedProperty(project, environment.getExecutor(), descriptor, "running");
            }
            return descriptor;
        }
        RunProfile runProfile = environment.getRunProfile();
        if (runProfile instanceof AndroidTestRunConfiguration && !state.getFacet().isGradleProject()) {
            String targetPackage = AndroidDebugRunner.getTargetPackage((AndroidTestRunConfiguration)runProfile, state);
            if (targetPackage == null) {
                throw new ExecutionException(AndroidBundle.message("target.package.not.specified.error", new Object[0]));
            }
            state.setTargetPackageName(targetPackage);
        }
        state.setDebugMode(true);
        Object object = myDebugLock;
        synchronized (object) {
            MyDebugLauncher launcher = new MyDebugLauncher(project, state, environment);
            state.setDebugLauncher(launcher);
            RunContentDescriptor descriptor = AndroidDebugRunner.embedToExistingSession(project, environment.getExecutor(), state);
            runDescriptor = descriptor != null ? descriptor : super.doExecute(project, (RunProfileState)state, contentToReuse, environment);
            launcher.setRunDescriptor(runDescriptor);
            if (descriptor != null) {
                return null;
            }
        }
        if (runDescriptor == null) {
            return null;
        }
        AndroidDebugRunner.tryToCloseOldSessions(environment.getExecutor(), project);
        ProcessHandler handler = state.getProcessHandler();
        handler.putUserData(ANDROID_SESSION_INFO, (Object)new AndroidSessionInfo(runDescriptor, state, environment.getExecutor().getId()));
        state.setRestarter(runDescriptor.getRestarter());
        AndroidDebugRunner.setActivateToolWindowWhenAddedProperty(project, environment.getExecutor(), runDescriptor, "running");
        return runDescriptor;
    }

    private static void setActivateToolWindowWhenAddedProperty(Project project, Executor executor, RunContentDescriptor descriptor, String status) {
        boolean activateToolWindow = AndroidDebugRunner.shouldActivateExecWindow(project);
        descriptor.setActivateToolWindowWhenAdded(activateToolWindow);
        if (!activateToolWindow) {
            AndroidDebugRunner.showNotification(project, executor, descriptor, status, false, NotificationType.INFORMATION);
        }
    }

    private static boolean shouldActivateExecWindow(Project project) {
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(AndroidToolWindowFactory.TOOL_WINDOW_ID);
        return toolWindow == null || !toolWindow.isVisible();
    }

    @Nullable
    private static Pair<ProcessHandler, AndroidSessionInfo> findOldSession(Project project, Executor executor, AndroidRunConfigurationBase configuration) {
        for (ProcessHandler handler : ExecutionManager.getInstance((Project)project).getRunningProcesses()) {
            AndroidSessionInfo info = (AndroidSessionInfo)handler.getUserData(ANDROID_SESSION_INFO);
            if (info == null || !info.getState().getConfiguration().equals((Object)configuration) || !executor.getId().equals(info.getExecutorId())) continue;
            return Pair.create((Object)handler, (Object)info);
        }
        return null;
    }

    @Nullable
    private static RunContentDescriptor embedToExistingSession(final Project project, final Executor executor, final AndroidRunningState state) throws ExecutionException {
        ProcessHandler newProcessHandler;
        ProcessHandler oldProcessHandler;
        Pair<ProcessHandler, AndroidSessionInfo> pair = AndroidDebugRunner.findOldSession(project, executor, state.getConfiguration());
        AndroidSessionInfo oldSessionInfo = pair != null ? (AndroidSessionInfo)pair.getSecond() : null;
        ProcessHandler processHandler = oldProcessHandler = pair != null ? (ProcessHandler)pair.getFirst() : null;
        if (oldSessionInfo == null || oldProcessHandler == null) {
            return null;
        }
        AndroidExecutionState oldState = oldSessionInfo.getState();
        IDevice[] oldDevices = oldState.getDevices();
        ConsoleView oldConsole = oldState.getConsoleView();
        if (oldDevices == null || oldConsole == null || oldDevices.length == 0 || oldDevices.length > 1) {
            return null;
        }
        final Ref devicesRef = Ref.create();
        boolean result = ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                devicesRef.set(state.getAllCompatibleDevices());
            }
        }, "Scanning available devices", false, project);
        if (!result) {
            return null;
        }
        List devices = (List)devicesRef.get();
        if (devices.size() == 0 || devices.size() > 1 || devices.get(0) != oldDevices[0]) {
            return null;
        }
        oldProcessHandler.detachProcess();
        state.setTargetDevices(devices.toArray(new IDevice[devices.size()]));
        state.setConsole(oldConsole);
        final RunContentDescriptor oldDescriptor = oldSessionInfo.getDescriptor();
        if (oldDescriptor.getProcessHandler() instanceof RemoteDebugProcessHandler) {
            newProcessHandler = oldDescriptor.getProcessHandler();
            newProcessHandler.destroyProcess();
        } else {
            newProcessHandler = new DefaultDebugProcessHandler();
        }
        oldDescriptor.setProcessHandler(newProcessHandler);
        state.setProcessHandler(newProcessHandler);
        oldConsole.attachToProcess(newProcessHandler);
        AndroidProcessText.attach(newProcessHandler);
        newProcessHandler.notifyTextAvailable("The session was restarted\n", ProcessOutputTypes.STDOUT);
        AndroidDebugRunner.showNotification(project, executor, oldDescriptor, "running", false, NotificationType.INFORMATION);
        state.addListener(new AndroidRunningStateListener(){

            @Override
            public void executionFailed() {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AndroidDebugRunner.showNotification(project, executor, oldDescriptor, "error", false, NotificationType.ERROR);
                    }
                });
            }
        });
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                state.start(false);
            }
        });
        return oldDescriptor;
    }

    private static void showNotification(final Project project, final Executor executor, final RunContentDescriptor descriptor, final String status, final boolean notifySelectedContent, final NotificationType type) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                String notificationMessage;
                if (project.isDisposed()) {
                    return;
                }
                final String sessionName = descriptor.getDisplayName();
                final ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(executor.getToolWindowId());
                Content content = descriptor.getAttachedContent();
                if (content != null && content.isSelected() && toolWindow.isVisible()) {
                    if (!notifySelectedContent) {
                        return;
                    }
                    notificationMessage = "Session '" + sessionName + "': " + status;
                } else {
                    notificationMessage = "Session <a href=''>'" + sessionName + "'</a>: " + status;
                }
                NotificationGroup.toolWindowGroup((String)"Android Session Restarted", (String)executor.getToolWindowId(), (boolean)true).createNotification("", notificationMessage, type, new NotificationListener(){

                    public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                        if (notification == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/run/AndroidDebugRunner$6$1", "hyperlinkUpdate"));
                        }
                        if (event == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/run/AndroidDebugRunner$6$1", "hyperlinkUpdate"));
                        }
                        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                            RunContentManager contentManager = ExecutionManager.getInstance((Project)project).getContentManager();
                            for (RunContentDescriptor d : contentManager.getAllDescriptors()) {
                                if (!sessionName.equals(d.getDisplayName())) continue;
                                Content content = d.getAttachedContent();
                                content.getManager().setSelectedContent(content);
                                toolWindow.activate(null, true, true);
                                break;
                            }
                        }
                    }
                }).notify(project);
            }
        });
    }

    @Nullable
    private static String getTargetPackage(AndroidTestRunConfiguration configuration, AndroidRunningState state) {
        Manifest manifest = state.getFacet().getManifest();
        assert (manifest != null);
        for (Instrumentation instrumentation : manifest.getInstrumentations()) {
            String targetPackage;
            PsiClass c = (PsiClass)instrumentation.getInstrumentationClass().getValue();
            String runner = configuration.INSTRUMENTATION_RUNNER_CLASS;
            if (c == null || runner.length() != 0 && !runner.equals(c.getQualifiedName()) || (targetPackage = (String)instrumentation.getTargetPackage().getValue()) == null) continue;
            return targetPackage;
        }
        return null;
    }

    @NotNull
    public String getRunnerId() {
        if ("AndroidDebugRunner" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/run/AndroidDebugRunner", "getRunnerId"));
        }
        return "AndroidDebugRunner";
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/run/AndroidDebugRunner", "canRun"));
        }
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/run/AndroidDebugRunner", "canRun"));
        }
        return (DefaultDebugExecutor.EXECUTOR_ID.equals(executorId) || DefaultRunExecutor.EXECUTOR_ID.equals(executorId)) && profile instanceof AndroidRunConfigurationBase;
    }

    private class MyDebugLauncher
    implements DebugLauncher {
        private final Project myProject;
        private final Executor myExecutor;
        private final AndroidRunningState myRunningState;
        private final ExecutionEnvironment myEnvironment;
        private RunContentDescriptor myRunDescriptor;

        public MyDebugLauncher(Project project, AndroidRunningState state, ExecutionEnvironment environment) {
            this.myProject = project;
            this.myRunningState = state;
            this.myEnvironment = environment;
            this.myExecutor = environment.getExecutor();
        }

        public void setRunDescriptor(RunContentDescriptor runDescriptor) {
            this.myRunDescriptor = runDescriptor;
        }

        @Override
        public void launchDebug(final IDevice device, final String debugPort) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ProcessHandler newProcessHandler;
                    DebuggerPanelsManager manager = DebuggerPanelsManager.getInstance((Project)MyDebugLauncher.this.myProject);
                    AndroidDebugState st = new AndroidDebugState(MyDebugLauncher.this.myProject, new RemoteConnection(true, "localhost", debugPort, false), MyDebugLauncher.this.myRunningState, device);
                    RunContentDescriptor debugDescriptor = null;
                    ProcessHandler processHandler = MyDebugLauncher.this.myRunningState.getProcessHandler();
                    try {
                        Object object = myDebugLock;
                        synchronized (object) {
                            assert (MyDebugLauncher.this.myRunDescriptor != null);
                            debugDescriptor = manager.attachVirtualMachine(MyDebugLauncher.this.myExecutor, (ProgramRunner)AndroidDebugRunner.this, MyDebugLauncher.this.myEnvironment, (RunProfileState)st, MyDebugLauncher.this.myRunDescriptor, st.getRemoteConnection(), false);
                        }
                    }
                    catch (ExecutionException e) {
                        processHandler.notifyTextAvailable("ExecutionException: " + e.getMessage() + '.', ProcessOutputTypes.STDERR);
                    }
                    ProcessHandler processHandler2 = newProcessHandler = debugDescriptor != null ? debugDescriptor.getProcessHandler() : null;
                    if (debugDescriptor == null || newProcessHandler == null) {
                        processHandler.notifyTextAvailable("Can't start debugging.", ProcessOutputTypes.STDERR);
                        processHandler.destroyProcess();
                        return;
                    }
                    processHandler.detachProcess();
                    AndroidProcessText oldText = AndroidProcessText.get(processHandler);
                    if (oldText != null) {
                        oldText.printTo(newProcessHandler);
                    }
                    AndroidProcessText.attach(newProcessHandler);
                    MyDebugLauncher.this.myRunningState.getProcessHandler().putUserData(ANDROID_SESSION_INFO, (Object)new AndroidSessionInfo(debugDescriptor, st, MyDebugLauncher.this.myExecutor.getId()));
                    DebuggerSessionTab sessionTab = manager.getSessionTab();
                    assert (sessionTab != null);
                    sessionTab.setEnvironment(MyDebugLauncher.this.myEnvironment);
                    RunProfile profile = MyDebugLauncher.this.myEnvironment.getRunProfile();
                    assert (profile instanceof AndroidRunConfigurationBase);
                    RunContentManager runContentManager = ExecutionManager.getInstance((Project)MyDebugLauncher.this.myProject).getContentManager();
                    AndroidDebugRunner.setActivateToolWindowWhenAddedProperty(MyDebugLauncher.this.myProject, MyDebugLauncher.this.myExecutor, debugDescriptor, "debugger connected");
                    runContentManager.showRunContent(MyDebugLauncher.this.myExecutor, debugDescriptor);
                    newProcessHandler.startNotify();
                }
            });
        }
    }

    private static class MyLogcatExecutionConsole
    implements ExecutionConsoleEx,
    ObservableConsoleView {
        private final Project myProject;
        private final AndroidLogcatView myToolWindowView;
        private final ConsoleView myConsoleView;
        private final String myConfigurationId;

        private MyLogcatExecutionConsole(Project project, IDevice device, RemoteDebugProcessHandler process, ConsoleView consoleView, String configurationId) {
            this.myProject = project;
            this.myConsoleView = consoleView;
            this.myConfigurationId = configurationId;
            this.myToolWindowView = new AndroidLogcatView(project, device){

                @Override
                protected boolean isActive() {
                    DebuggerSessionTab sessionTab = DebuggerPanelsManager.getInstance((Project)MyLogcatExecutionConsole.this.myProject).getSessionTab();
                    if (sessionTab == null) {
                        return false;
                    }
                    Content content = sessionTab.getUi().findContent(AndroidDebugRunner.ANDROID_LOGCAT_CONTENT_ID);
                    return content != null && content.isSelected();
                }
            };
            Disposer.register((Disposable)this, (Disposable)this.myToolWindowView);
        }

        public void buildUi(RunnerLayoutUi layoutUi) {
            Content consoleContent = layoutUi.createContent("ConsoleContent", this.getComponent(), XDebuggerBundle.message((String)"debugger.session.tab.console.content.name", (Object[])new Object[0]), AllIcons.Debugger.Console, this.getPreferredFocusableComponent());
            consoleContent.setCloseable(false);
            layoutUi.addContent(consoleContent, 1, PlaceInGrid.bottom, false);
            Content logcatContent = layoutUi.createContent(AndroidDebugRunner.ANDROID_LOGCAT_CONTENT_ID, (JComponent)this.myToolWindowView.getContentPanel(), "Logcat", AndroidIcons.Android, this.getPreferredFocusableComponent());
            logcatContent.setCloseable(false);
            logcatContent.setSearchComponent((JComponent)this.myToolWindowView.createSearchComponent(this.myProject));
            layoutUi.addContent(logcatContent, 2, PlaceInGrid.bottom, false);
            final String selectedTabProperty = AndroidDebugRunner.ANDROID_DEBUG_SELECTED_TAB_PROPERTY + this.myConfigurationId;
            String tabName = PropertiesComponent.getInstance().getValue(selectedTabProperty);
            Content selectedContent = logcatContent;
            if (tabName != null) {
                for (Content content : layoutUi.getContents()) {
                    if (!tabName.equals(content.getDisplayName())) continue;
                    selectedContent = content;
                }
            }
            layoutUi.getContentManager().setSelectedContent(selectedContent);
            layoutUi.addListener((ContentManagerListener)new ContentManagerAdapter(){

                public void selectionChanged(ContentManagerEvent event) {
                    Content content = event.getContent();
                    if (content.isSelected()) {
                        PropertiesComponent.getInstance().setValue(selectedTabProperty, content.getDisplayName());
                    }
                    MyLogcatExecutionConsole.this.myToolWindowView.activate();
                }
            }, (Disposable)this.myToolWindowView);
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    MyLogcatExecutionConsole.this.myToolWindowView.activate();
                }
            });
        }

        @Nullable
        public String getExecutionConsoleId() {
            return "ANDROID_LOGCAT";
        }

        public JComponent getComponent() {
            return this.myConsoleView.getComponent();
        }

        public JComponent getPreferredFocusableComponent() {
            return this.myConsoleView.getPreferredFocusableComponent();
        }

        public void dispose() {
        }

        public void addChangeListener(@NotNull ObservableConsoleView.ChangeListener listener, @NotNull Disposable parent) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/run/AndroidDebugRunner$MyLogcatExecutionConsole", "addChangeListener"));
            }
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/run/AndroidDebugRunner$MyLogcatExecutionConsole", "addChangeListener"));
            }
            if (this.myConsoleView instanceof ObservableConsoleView) {
                ((ObservableConsoleView)this.myConsoleView).addChangeListener(listener, parent);
            }
        }
    }

    private static class AndroidDebugState
    implements RemoteState,
    AndroidExecutionState {
        private final Project myProject;
        private final RemoteConnection myConnection;
        private final AndroidRunningState myState;
        private final IDevice myDevice;
        private volatile ConsoleView myConsoleView;

        public AndroidDebugState(Project project, RemoteConnection connection, AndroidRunningState state, IDevice device) {
            this.myProject = project;
            this.myConnection = connection;
            this.myState = state;
            this.myDevice = device;
        }

        public ExecutionResult execute(Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
            if (runner == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/run/AndroidDebugRunner$AndroidDebugState", "execute"));
            }
            RemoteDebugProcessHandler process = new RemoteDebugProcessHandler(this.myProject);
            this.myState.setProcessHandler((ProcessHandler)process);
            this.myConsoleView = this.myState.getConfiguration().attachConsole(this.myState, executor);
            MyLogcatExecutionConsole console = new MyLogcatExecutionConsole(this.myProject, this.myDevice, process, this.myConsoleView, this.myState.getConfiguration().getType().getId());
            return new DefaultExecutionResult((ExecutionConsole)console, (ProcessHandler)process);
        }

        public RemoteConnection getRemoteConnection() {
            return this.myConnection;
        }

        @Override
        public IDevice[] getDevices() {
            return new IDevice[]{this.myDevice};
        }

        @Override
        @Nullable
        public ConsoleView getConsoleView() {
            return this.myConsoleView;
        }

        @Override
        @NotNull
        public AndroidRunConfigurationBase getConfiguration() {
            AndroidRunConfigurationBase androidRunConfigurationBase = this.myState.getConfiguration();
            if (androidRunConfigurationBase == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/run/AndroidDebugRunner$AndroidDebugState", "getConfiguration"));
            }
            return androidRunConfigurationBase;
        }
    }
}

