/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.resourceManagers;

import com.android.resources.ResourceType;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.HashMap;
import com.intellij.util.indexing.FileBasedIndex;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.AndroidValueResourcesIndex;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.attrs.AttributeDefinitionsImpl;
import org.jetbrains.android.dom.resources.Attr;
import org.jetbrains.android.dom.resources.DeclareStyleable;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.dom.resources.Resources;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.android.util.ResourceEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalResourceManager
extends ResourceManager {
    private AttributeDefinitions myAttrDefs;
    protected final AndroidFacet myFacet;

    public LocalResourceManager(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/resourceManagers/LocalResourceManager", "<init>"));
        }
        super(facet.getModule().getProject());
        this.myFacet = facet;
    }

    public AndroidFacet getFacet() {
        return this.myFacet;
    }

    @Override
    @NotNull
    public VirtualFile[] getAllResourceDirs() {
        com.intellij.util.containers.HashSet result = new com.intellij.util.containers.HashSet();
        LocalResourceManager.collectResourceDirs(this.getFacet(), (Set<VirtualFile>)result, (Set<Module>)new com.intellij.util.containers.HashSet());
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray((Collection)result);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/resourceManagers/LocalResourceManager", "getAllResourceDirs"));
        }
        return virtualFileArray;
    }

    @Override
    public boolean isResourceDir(@NotNull VirtualFile dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/resourceManagers/LocalResourceManager", "isResourceDir"));
        }
        for (VirtualFile resDir : this.getResourceDirs()) {
            if (!dir.equals(resDir)) continue;
            return true;
        }
        for (VirtualFile dir1 : this.getResourceOverlayDirs()) {
            if (!dir.equals(dir1)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public List<VirtualFile> getResourceDirs() {
        List<VirtualFile> list = this.myFacet.getAllResourceDirectories();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/resourceManagers/LocalResourceManager", "getResourceDirs"));
        }
        return list;
    }

    public List<Pair<Resources, VirtualFile>> getResourceElements() {
        return this.getResourceElements(null);
    }

    @Override
    @NotNull
    public VirtualFile[] getResourceOverlayDirs() {
        VirtualFile[] virtualFileArray = AndroidRootUtil.getResourceOverlayDirs(this.getFacet());
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/resourceManagers/LocalResourceManager", "getResourceOverlayDirs"));
        }
        return virtualFileArray;
    }

    @NotNull
    public List<ResourceElement> getValueResources(@NotNull String resourceType) {
        if (resourceType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/resourceManagers/LocalResourceManager", "getValueResources"));
        }
        List<ResourceElement> list = this.getValueResources(resourceType, null);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/resourceManagers/LocalResourceManager", "getValueResources"));
        }
        return list;
    }

    private static void collectResourceDirs(AndroidFacet facet, Set<VirtualFile> result, Set<Module> visited) {
        if (!visited.add(facet.getModule())) {
            return;
        }
        for (VirtualFile resDir : facet.getAllResourceDirectories()) {
            if (result.add(resDir)) continue;
            return;
        }
        HashSet dirs = Sets.newHashSet();
        ResourceFolderManager.addAarsFromModuleLibraries(facet, dirs);
        if (!dirs.isEmpty()) {
            for (File dir : dirs) {
                VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(dir);
                if (virtualFile == null) continue;
                result.add(virtualFile);
            }
        }
        for (AndroidFacet depFacet : AndroidUtils.getAllAndroidDependencies(facet.getModule(), false)) {
            LocalResourceManager.collectResourceDirs(depFacet, result, visited);
        }
    }

    @Nullable
    public static LocalResourceManager getInstance(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/resourceManagers/LocalResourceManager", "getInstance"));
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        return facet != null ? facet.getLocalResourceManager() : null;
    }

    @Nullable
    public static LocalResourceManager getInstance(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/resourceManagers/LocalResourceManager", "getInstance"));
        }
        AndroidFacet facet = AndroidFacet.getInstance(element);
        return facet != null ? facet.getLocalResourceManager() : null;
    }

    @NotNull
    public Set<String> getValueResourceTypes() {
        HashMap file2Types = new HashMap();
        FileBasedIndex index = FileBasedIndex.getInstance();
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)this.myProject);
        for (ResourceType resourceType : AndroidResourceUtil.ALL_VALUE_RESOURCE_TYPES) {
            ResourceEntry typeMarkerEntry = AndroidValueResourcesIndex.createTypeMarkerKey(resourceType.getName());
            index.processValues(AndroidValueResourcesIndex.INDEX_ID, (Object)typeMarkerEntry, null, (FileBasedIndex.ValueProcessor)new FileBasedIndex.ValueProcessor<Set<AndroidValueResourcesIndex.MyResourceInfo>>((Map)file2Types){
                final /* synthetic */ Map val$file2Types;
                {
                    this.val$file2Types = map;
                }

                public boolean process(VirtualFile file, Set<AndroidValueResourcesIndex.MyResourceInfo> infos) {
                    for (AndroidValueResourcesIndex.MyResourceInfo info : infos) {
                        Set resourcesInFile = (Set)this.val$file2Types.get(file);
                        if (resourcesInFile == null) {
                            resourcesInFile = new com.intellij.util.containers.HashSet();
                            this.val$file2Types.put(file, resourcesInFile);
                        }
                        resourcesInFile.add(info.getResourceEntry().getType());
                    }
                    return true;
                }
            }, scope);
        }
        com.intellij.util.containers.HashSet result = new com.intellij.util.containers.HashSet();
        for (VirtualFile file : this.getAllValueResourceFiles()) {
            Set types = (Set)file2Types.get(file);
            if (types == null) continue;
            result.addAll(types);
        }
        com.intellij.util.containers.HashSet hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/resourceManagers/LocalResourceManager", "getValueResourceTypes"));
        }
        return hashSet;
    }

    @Override
    @NotNull
    public AttributeDefinitions getAttributeDefinitions() {
        if (this.myAttrDefs == null) {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    ArrayList<XmlFile> xmlResFiles = new ArrayList<XmlFile>();
                    for (PsiFile file : LocalResourceManager.this.findResourceFiles("values")) {
                        if (!(file instanceof XmlFile)) continue;
                        xmlResFiles.add((XmlFile)file);
                    }
                    LocalResourceManager.this.myAttrDefs = new AttributeDefinitionsImpl(xmlResFiles.toArray(new XmlFile[xmlResFiles.size()]));
                }
            });
        }
        AttributeDefinitions attributeDefinitions = this.myAttrDefs;
        if (attributeDefinitions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/resourceManagers/LocalResourceManager", "getAttributeDefinitions"));
        }
        return attributeDefinitions;
    }

    public void invalidateAttributeDefinitions() {
        this.myAttrDefs = null;
    }

    @NotNull
    public List<Attr> findAttrs(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/resourceManagers/LocalResourceManager", "findAttrs"));
        }
        ArrayList<Attr> list = new ArrayList<Attr>();
        for (Pair<Resources, VirtualFile> pair : this.getResourceElements()) {
            Resources res = (Resources)pair.getFirst();
            for (Attr attr : res.getAttrs()) {
                if (!name.equals(attr.getName().getValue())) continue;
                list.add(attr);
            }
            for (DeclareStyleable styleable : res.getDeclareStyleables()) {
                for (Attr attr : styleable.getAttrs()) {
                    if (!name.equals(attr.getName().getValue())) continue;
                    list.add(attr);
                }
            }
        }
        ArrayList<Attr> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/resourceManagers/LocalResourceManager", "findAttrs"));
        }
        return arrayList;
    }

    public List<DeclareStyleable> findStyleables(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/resourceManagers/LocalResourceManager", "findStyleables"));
        }
        ArrayList<DeclareStyleable> list = new ArrayList<DeclareStyleable>();
        for (Pair<Resources, VirtualFile> pair : this.getResourceElements()) {
            Resources res = (Resources)pair.getFirst();
            for (DeclareStyleable styleable : res.getDeclareStyleables()) {
                if (!name.equals(styleable.getName().getValue())) continue;
                list.add(styleable);
            }
        }
        return list;
    }

    public List<Attr> findStyleableAttributesByFieldName(@NotNull String fieldName) {
        int prev;
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/resourceManagers/LocalResourceManager", "findStyleableAttributesByFieldName"));
        }
        int index = fieldName.lastIndexOf(95);
        while (index != -1 && (prev = fieldName.lastIndexOf(95, index - 1)) != -1 && !Character.isUpperCase(fieldName.charAt(prev + 1))) {
            index = prev;
        }
        if (index == -1) {
            return Collections.emptyList();
        }
        String styleableName = fieldName.substring(0, index);
        String attrName = fieldName.substring(index + 1);
        ArrayList<Attr> list = new ArrayList<Attr>();
        for (Pair<Resources, VirtualFile> pair : this.getResourceElements()) {
            Resources res = (Resources)pair.getFirst();
            for (DeclareStyleable styleable : res.getDeclareStyleables()) {
                if (!styleableName.equals(styleable.getName().getValue())) continue;
                for (Attr attr : styleable.getAttrs()) {
                    if (!attrName.equals(attr.getName().getValue())) continue;
                    list.add(attr);
                }
            }
        }
        return list;
    }

    @NotNull
    public List<PsiElement> findResourcesByField(@NotNull PsiField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/resourceManagers/LocalResourceManager", "findResourcesByField"));
        }
        String type = AndroidResourceUtil.getResourceClassName(field);
        if (type == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/resourceManagers/LocalResourceManager", "findResourcesByField"));
            }
            return list;
        }
        String fieldName = field.getName();
        if (fieldName == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/resourceManagers/LocalResourceManager", "findResourcesByField"));
            }
            return list;
        }
        List<PsiElement> list = this.findResourcesByFieldName(type, fieldName);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/resourceManagers/LocalResourceManager", "findResourcesByField"));
        }
        return list;
    }

    @NotNull
    public List<PsiElement> findResourcesByFieldName(@NotNull String resClassName, @NotNull String fieldName) {
        if (resClassName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/resourceManagers/LocalResourceManager", "findResourcesByFieldName"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/resourceManagers/LocalResourceManager", "findResourcesByFieldName"));
        }
        ArrayList<PsiElement> targets = new ArrayList<PsiElement>();
        if (resClassName.equals(ResourceType.ID.getName())) {
            targets.addAll(this.findIdDeclarations(fieldName));
        }
        for (PsiFile file : this.findResourceFiles(resClassName, fieldName, false, new String[0])) {
            targets.add((PsiElement)file);
        }
        for (ResourceElement element : this.findValueResources(resClassName, fieldName, false)) {
            targets.add((PsiElement)element.getName().getXmlAttributeValue());
        }
        if (resClassName.equals(ResourceType.ATTR.getName())) {
            for (Attr attr : this.findAttrs(fieldName)) {
                targets.add((PsiElement)attr.getName().getXmlAttributeValue());
            }
        } else if (resClassName.equals(ResourceType.STYLEABLE.getName())) {
            for (DeclareStyleable styleable : this.findStyleables(fieldName)) {
                targets.add((PsiElement)styleable.getName().getXmlAttributeValue());
            }
            for (Attr attr : this.findStyleableAttributesByFieldName(fieldName)) {
                targets.add((PsiElement)attr.getName().getXmlAttributeValue());
            }
        }
        ArrayList<PsiElement> arrayList = targets;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/resourceManagers/LocalResourceManager", "findResourcesByFieldName"));
        }
        return arrayList;
    }
}

