/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.intellij.refactoring.RefactoringBundle;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.dom.resources.Style;
import org.jetbrains.android.dom.resources.StyleItem;
import org.jetbrains.android.refactoring.AndroidAttributeInfo;
import org.jetbrains.android.refactoring.StyleRefData;
import org.jetbrains.android.util.ErrorReporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidRefactoringUtil {
    private AndroidRefactoringUtil() {
    }

    @Nullable
    static StyleRefData getParentStyle(@NotNull Style style) {
        if (style == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/refactoring/AndroidRefactoringUtil", "getParentStyle"));
        }
        ResourceValue parentStyleRefValue = (ResourceValue)style.getParentStyle().getValue();
        if (parentStyleRefValue != null) {
            String parentStyleName = parentStyleRefValue.getResourceName();
            if (parentStyleName != null) {
                return new StyleRefData(parentStyleName, parentStyleRefValue.getPackage());
            }
        } else {
            int idx;
            String styleName = style.getName().getStringValue();
            if (styleName != null && (idx = styleName.lastIndexOf(46)) > 0) {
                return new StyleRefData(styleName.substring(0, idx), null);
            }
        }
        return null;
    }

    @Nullable
    static Map<AndroidAttributeInfo, String> computeAttributeMap(@NotNull Style style, @NotNull ErrorReporter errorReporter, @NotNull String errorReportTitle) {
        if (style == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/refactoring/AndroidRefactoringUtil", "computeAttributeMap"));
        }
        if (errorReporter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/refactoring/AndroidRefactoringUtil", "computeAttributeMap"));
        }
        if (errorReportTitle == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/refactoring/AndroidRefactoringUtil", "computeAttributeMap"));
        }
        HashMap attributeValues = new HashMap();
        for (StyleItem item : style.getItems()) {
            String nsPrefix;
            String attributeName = item.getName().getStringValue();
            String attributeValue = item.getStringValue();
            if (attributeName == null || attributeName.length() <= 0 || attributeValue == null) continue;
            int idx = attributeName.indexOf(58);
            String localName = idx >= 0 ? attributeName.substring(idx + 1) : attributeName;
            String string = nsPrefix = idx >= 0 ? attributeName.substring(0, idx) : null;
            if (nsPrefix != null) {
                if (!"android".equals(nsPrefix)) {
                    errorReporter.report(RefactoringBundle.getCannotRefactorMessage((String)("Unknown XML attribute prefix '" + nsPrefix + ":'")), errorReportTitle);
                    return null;
                }
            } else {
                errorReporter.report(RefactoringBundle.getCannotRefactorMessage((String)"The style contains attribute without 'android' prefix."), errorReportTitle);
                return null;
            }
            attributeValues.put(new AndroidAttributeInfo(localName, nsPrefix), attributeValue);
        }
        return attributeValues;
    }
}

