/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.lang.Language;
import com.intellij.lang.refactoring.InlineActionHandler;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.xml.DomManager;
import org.jetbrains.android.dom.converters.AndroidResourceReferenceBase;
import org.jetbrains.android.dom.layout.LayoutDomFileDescription;
import org.jetbrains.android.dom.wrappers.ResourceElementWrapper;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.refactoring.AndroidInlineTestConfig;
import org.jetbrains.android.refactoring.AndroidInlineUtil;
import org.jetbrains.android.refactoring.LayoutUsageData;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.ErrorReporter;
import org.jetbrains.android.util.HintBasedErrorReporter;
import org.jetbrains.android.util.ProjectBasedErrorReporter;
import org.jetbrains.annotations.Nullable;

public class AndroidInlineLayoutHandler
extends InlineActionHandler {
    private static AndroidInlineTestConfig ourTestConfig;

    public static void setTestConfig(@Nullable AndroidInlineTestConfig testConfig) {
        ourTestConfig = testConfig;
    }

    public boolean isEnabledForLanguage(Language l) {
        return l == XMLLanguage.INSTANCE;
    }

    public boolean canInlineElement(PsiElement element) {
        return false;
    }

    public boolean canInlineElementInEditor(PsiElement element, Editor editor) {
        if (element instanceof ResourceElementWrapper) {
            element = ((ResourceElementWrapper)element).getWrappee();
        }
        if (element instanceof XmlFile) {
            if (AndroidFacet.getInstance(element) == null || ((XmlFile)element).getRootTag() == null) {
                return false;
            }
            return DomManager.getDomManager((Project)element.getProject()).getDomFileDescription((XmlFile)element) instanceof LayoutDomFileDescription;
        }
        return AndroidInlineLayoutHandler.getLayoutUsageDataFromContext(editor) != null;
    }

    @Nullable
    private static LayoutUsageData getLayoutUsageDataFromContext(Editor editor) {
        if (editor == null) {
            return null;
        }
        PsiElement element = PsiUtilBase.getElementAtCaret((Editor)editor);
        if (!(element instanceof XmlToken) || AndroidFacet.getInstance(element) == null) {
            return null;
        }
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
        return tag != null ? AndroidInlineUtil.getLayoutUsageData(tag) : null;
    }

    public void inlineElement(Project project, Editor editor, PsiElement element) {
        if (element instanceof ResourceElementWrapper) {
            element = ((ResourceElementWrapper)element).getWrappee();
        }
        if (element instanceof XmlFile) {
            PsiReference reference;
            PsiElement usageElement = null;
            if (editor != null && (reference = TargetElementUtilBase.findReference((Editor)editor)) != null) {
                usageElement = reference.getElement();
            }
            AndroidInlineUtil.doInlineLayoutFile(project, (XmlFile)element, usageElement, ourTestConfig);
            return;
        }
        LayoutUsageData usageData = AndroidInlineLayoutHandler.getLayoutUsageDataFromContext(editor);
        assert (usageData != null);
        AndroidResourceReferenceBase ref = usageData.getReference();
        PsiElement[] elements = ref.computeTargetElements();
        ErrorReporter errorReporter = editor != null ? new HintBasedErrorReporter(editor) : new ProjectBasedErrorReporter(project);
        String title = AndroidBundle.message("android.inline.layout.title", new Object[0]);
        if (elements.length == 0) {
            String resName = ref.getResourceValue().getResourceName();
            String message = resName != null ? "Cannot find layout '" + resName + "'" : "Error: cannot find the layout";
            errorReporter.report(message, title);
            return;
        }
        if (elements.length > 1) {
            errorReporter.report("Error: unambiguous reference", title);
            return;
        }
        PsiElement resolvedElement = elements[0];
        if (!(resolvedElement instanceof XmlFile)) {
            errorReporter.report("Cannot inline reference '" + ref.getValue() + "'", title);
            return;
        }
        AndroidInlineUtil.doInlineLayoutFile(project, (XmlFile)resolvedElement, ref.getElement(), ourTestConfig);
    }
}

