/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.inline.InlineOptionsDialog;
import org.jetbrains.android.refactoring.AndroidInlineLayoutProcessor;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidInlineLayoutDialog
extends InlineOptionsDialog {
    private final XmlFile myLayoutFile;
    private final XmlTag myLayoutRootTag;
    private final PsiElement myUsageElement;

    public AndroidInlineLayoutDialog(@NotNull Project project, @NotNull XmlFile layoutFile, @NotNull XmlTag layoutRootTag, @Nullable PsiElement usageElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/refactoring/AndroidInlineLayoutDialog", "<init>"));
        }
        if (layoutFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/refactoring/AndroidInlineLayoutDialog", "<init>"));
        }
        if (layoutRootTag == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/refactoring/AndroidInlineLayoutDialog", "<init>"));
        }
        super(project, true, (PsiElement)layoutFile);
        this.myLayoutFile = layoutFile;
        this.myLayoutRootTag = layoutRootTag;
        this.myUsageElement = usageElement;
        this.myInvokedOnReference = usageElement != null;
        this.setTitle(AndroidBundle.message("android.inline.layout.title", new Object[0]));
        this.init();
    }

    protected String getNameLabelText() {
        return "Layout file '" + this.myLayoutFile.getName() + "'";
    }

    protected String getBorderTitle() {
        return "Inline";
    }

    protected String getInlineAllText() {
        return AndroidBundle.message("android.inline.file.inline.all.text", new Object[0]);
    }

    protected String getInlineThisText() {
        return AndroidBundle.message("android.inline.file.inline.this.text", new Object[0]);
    }

    protected boolean isInlineThis() {
        return this.myUsageElement != null;
    }

    protected void doAction() {
        PsiElement usageElement = this.isInlineThisOnly() ? this.myUsageElement : null;
        this.invokeRefactoring(new AndroidInlineLayoutProcessor(this.myProject, this.myLayoutFile, this.myLayoutRootTag, usageElement, null));
    }
}

