/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.util.xml.DomManager;
import org.jetbrains.android.dom.converters.AndroidResourceReferenceBase;
import org.jetbrains.android.dom.layout.LayoutDomFileDescription;
import org.jetbrains.android.refactoring.AndroidBaseXmlRefactoringAction;
import org.jetbrains.android.refactoring.AndroidInlineTestConfig;
import org.jetbrains.android.refactoring.AndroidInlineUtil;
import org.jetbrains.android.refactoring.LayoutUsageData;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;

public class AndroidInlineIncludeAction
extends AndroidBaseXmlRefactoringAction {
    private final AndroidInlineTestConfig myTestConfig;
    public static final String ACTION_ID = "AndroidInlineIncludeAction";

    public AndroidInlineIncludeAction() {
        this.myTestConfig = null;
    }

    public AndroidInlineIncludeAction(AndroidInlineTestConfig testConfig) {
        this.myTestConfig = testConfig;
    }

    @Override
    protected void doRefactorForTags(@NotNull Project project, @NotNull XmlTag[] tags) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/refactoring/AndroidInlineIncludeAction", "doRefactorForTags"));
        }
        if (tags == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/refactoring/AndroidInlineIncludeAction", "doRefactorForTags"));
        }
        assert (tags.length == 1);
        XmlTag tag = tags[0];
        PsiFile file = tag.getContainingFile();
        if (file == null) {
            return;
        }
        LayoutUsageData usageData = AndroidInlineUtil.getLayoutUsageData(tag);
        if (usageData == null) {
            return;
        }
        AndroidResourceReferenceBase reference = usageData.getReference();
        String title = AndroidBundle.message("android.inline.layout.title", new Object[0]);
        PsiElement[] resolvedElements = reference.computeTargetElements();
        if (resolvedElements.length == 0) {
            AndroidUtils.reportError(project, "Cannot find layout by reference '" + reference.getValue() + "'", title);
            return;
        }
        if (resolvedElements.length > 1) {
            AndroidUtils.reportError(project, RefactoringBundle.getCannotRefactorMessage((String)"Unambiguous layout reference."), title);
            return;
        }
        PsiElement resolvedElement = resolvedElements[0];
        if (!(resolvedElement instanceof XmlFile)) {
            AndroidUtils.reportError(project, "Cannot find layout by reference '" + reference.getValue() + "'", title);
            return;
        }
        AndroidInlineUtil.doInlineLayoutFile(project, (XmlFile)resolvedElement, usageData.getReference().getElement(), this.myTestConfig);
    }

    @Override
    protected boolean isEnabledForTags(@NotNull XmlTag[] tags) {
        if (tags == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/refactoring/AndroidInlineIncludeAction", "isEnabledForTags"));
        }
        return tags.length == 1 && AndroidInlineUtil.getLayoutUsageData(tags[0]) != null;
    }

    @Override
    protected boolean isMyFile(PsiFile file) {
        return DomManager.getDomManager((Project)file.getProject()).getDomFileDescription((XmlFile)file) instanceof LayoutDomFileDescription;
    }
}

