/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AndroidAttributeInfo {
    private final String myName;
    private final String myPackage;

    public AndroidAttributeInfo(@NotNull String name, @Nullable String aPackage) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/refactoring/AndroidAttributeInfo", "<init>"));
        }
        this.myName = name;
        this.myPackage = aPackage;
    }

    public String getNamespace() {
        boolean system = "android".equals(this.myPackage);
        return system ? "http://schemas.android.com/apk/res/android" : null;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/refactoring/AndroidAttributeInfo", "getName"));
        }
        return string;
    }

    @Nullable
    public String getPackage() {
        return this.myPackage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndroidAttributeInfo info = (AndroidAttributeInfo)o;
        if (!this.myName.equals(info.myName)) {
            return false;
        }
        return !(this.myPackage != null ? !this.myPackage.equals(info.myPackage) : info.myPackage != null);
    }

    public int hashCode() {
        int result = this.myName.hashCode();
        result = 31 * result + (this.myPackage != null ? this.myPackage.hashCode() : 0);
        return result;
    }

    @NotNull
    public String getAttributeId() {
        String string = this.myPackage != null ? this.myPackage + ":" + this.myName : this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/refactoring/AndroidAttributeInfo", "getAttributeId"));
        }
        return string;
    }

    public String toString() {
        return this.getAttributeId();
    }
}

