/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.newProject;

import com.intellij.ide.util.importProject.ModuleDescriptor;
import com.intellij.ide.util.importProject.ProjectDescriptor;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.ProjectFromSourcesBuilder;
import com.intellij.ide.util.projectWizard.importSources.ProjectStructureDetector;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AndroidProjectStructureDetector
extends ProjectStructureDetector {
    @NotNull
    public ProjectStructureDetector.DirectoryProcessingResult detectRoots(@NotNull File dir, @NotNull File[] children, @NotNull File base, @NotNull List<DetectedProjectRoot> result) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/newProject/AndroidProjectStructureDetector", "detectRoots"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/newProject/AndroidProjectStructureDetector", "detectRoots"));
        }
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/newProject/AndroidProjectStructureDetector", "detectRoots"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/android/newProject/AndroidProjectStructureDetector", "detectRoots"));
        }
        for (File child : children) {
            if (!child.isFile() || !"AndroidManifest.xml".equals(child.getName())) continue;
            result.add(new AndroidProjectRoot(dir));
            ProjectStructureDetector.DirectoryProcessingResult directoryProcessingResult = ProjectStructureDetector.DirectoryProcessingResult.SKIP_CHILDREN;
            if (directoryProcessingResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/newProject/AndroidProjectStructureDetector", "detectRoots"));
            }
            return directoryProcessingResult;
        }
        ProjectStructureDetector.DirectoryProcessingResult directoryProcessingResult = ProjectStructureDetector.DirectoryProcessingResult.PROCESS_CHILDREN;
        if (directoryProcessingResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/newProject/AndroidProjectStructureDetector", "detectRoots"));
        }
        return directoryProcessingResult;
    }

    public void setupProjectStructure(@NotNull Collection<DetectedProjectRoot> roots, @NotNull ProjectDescriptor projectDescriptor, @NotNull ProjectFromSourcesBuilder builder) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/newProject/AndroidProjectStructureDetector", "setupProjectStructure"));
        }
        if (projectDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/newProject/AndroidProjectStructureDetector", "setupProjectStructure"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/newProject/AndroidProjectStructureDetector", "setupProjectStructure"));
        }
        ArrayList<File> existingRoots = new ArrayList<File>();
        for (ProjectStructureDetector detector : (ProjectStructureDetector[])ProjectStructureDetector.EP_NAME.getExtensions()) {
            if (detector == this) continue;
            for (DetectedProjectRoot root : builder.getProjectRoots(detector)) {
                existingRoots.add(root.getDirectory());
            }
        }
        ArrayList<ModuleDescriptor> modules = new ArrayList<ModuleDescriptor>();
        for (DetectedProjectRoot root : roots) {
            File dir = root.getDirectory();
            boolean javaSrcRootInside = false;
            for (File javaSourceRoot : existingRoots) {
                if (!FileUtil.isAncestor((File)dir, (File)javaSourceRoot, (boolean)false)) continue;
                javaSrcRootInside = true;
            }
            if (javaSrcRootInside) continue;
            modules.add(new ModuleDescriptor(root.getDirectory(), JavaModuleType.getModuleType(), Collections.emptyList()));
        }
        projectDescriptor.setModules(modules);
    }

    private static class AndroidProjectRoot
    extends DetectedProjectRoot {
        public AndroidProjectRoot(@NotNull File directory) {
            if (directory == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/newProject/AndroidProjectStructureDetector$AndroidProjectRoot", "<init>"));
            }
            super(directory);
        }

        @NotNull
        public String getRootTypeName() {
            if ("Android" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/newProject/AndroidProjectStructureDetector$AndroidProjectRoot", "getRootTypeName"));
            }
            return "Android";
        }
    }
}

