/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

class ConvertNamespaceQuickFix
implements AndroidLintQuickFix {
    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/ConvertNamespaceQuickFix", "apply"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/inspections/lint/ConvertNamespaceQuickFix", "apply"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/inspections/lint/ConvertNamespaceQuickFix", "apply"));
        }
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class);
        if (tag == null) {
            return;
        }
        for (XmlAttribute attribute : tag.getAttributes()) {
            String uri;
            if (!attribute.getName().startsWith("xmlns") || (uri = attribute.getValue()) == null || uri.isEmpty() || !uri.startsWith("http://schemas.android.com/apk/res/") || uri.equals("http://schemas.android.com/apk/res/android")) continue;
            attribute.setValue("http://schemas.android.com/apk/res-auto");
        }
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/ConvertNamespaceQuickFix", "isApplicable"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/inspections/lint/ConvertNamespaceQuickFix", "isApplicable"));
        }
        if (contextType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/inspections/lint/ConvertNamespaceQuickFix", "isApplicable"));
        }
        return PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class) != null;
    }

    @Override
    @NotNull
    public String getName() {
        String string = AndroidBundle.message("android.lint.fix.replace.namespace", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/ConvertNamespaceQuickFix", "getName"));
        }
        return string;
    }
}

