/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.actions.OverrideResourceAction;
import com.android.tools.idea.rendering.ResourceHelper;
import com.android.tools.idea.templates.RepositoryUrlManager;
import com.android.tools.lint.checks.AccessibilityDetector;
import com.android.tools.lint.checks.AddJavascriptInterfaceDetector;
import com.android.tools.lint.checks.AlwaysShowActionDetector;
import com.android.tools.lint.checks.AnnotationDetector;
import com.android.tools.lint.checks.ApiDetector;
import com.android.tools.lint.checks.AppCompatCallDetector;
import com.android.tools.lint.checks.AppCompatResourceDetector;
import com.android.tools.lint.checks.ArraySizeDetector;
import com.android.tools.lint.checks.AssertDetector;
import com.android.tools.lint.checks.ButtonDetector;
import com.android.tools.lint.checks.ByteOrderMarkDetector;
import com.android.tools.lint.checks.CallSuperDetector;
import com.android.tools.lint.checks.CheckPermissionDetector;
import com.android.tools.lint.checks.ChildCountDetector;
import com.android.tools.lint.checks.CipherGetInstanceDetector;
import com.android.tools.lint.checks.ColorUsageDetector;
import com.android.tools.lint.checks.CommentDetector;
import com.android.tools.lint.checks.CutPasteDetector;
import com.android.tools.lint.checks.DeprecationDetector;
import com.android.tools.lint.checks.DetectMissingPrefix;
import com.android.tools.lint.checks.DosLineEndingDetector;
import com.android.tools.lint.checks.DuplicateIdDetector;
import com.android.tools.lint.checks.DuplicateResourceDetector;
import com.android.tools.lint.checks.ExtraTextDetector;
import com.android.tools.lint.checks.FragmentDetector;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.checks.GridLayoutDetector;
import com.android.tools.lint.checks.HardcodedDebugModeDetector;
import com.android.tools.lint.checks.HardcodedValuesDetector;
import com.android.tools.lint.checks.IconDetector;
import com.android.tools.lint.checks.IncludeDetector;
import com.android.tools.lint.checks.InefficientWeightDetector;
import com.android.tools.lint.checks.JavaPerformanceDetector;
import com.android.tools.lint.checks.LabelForDetector;
import com.android.tools.lint.checks.LayoutConsistencyDetector;
import com.android.tools.lint.checks.LayoutInflationDetector;
import com.android.tools.lint.checks.LocaleFolderDetector;
import com.android.tools.lint.checks.ManifestDetector;
import com.android.tools.lint.checks.MergeRootFrameLayoutDetector;
import com.android.tools.lint.checks.MissingClassDetector;
import com.android.tools.lint.checks.MissingIdDetector;
import com.android.tools.lint.checks.NamespaceDetector;
import com.android.tools.lint.checks.NestedScrollingWidgetDetector;
import com.android.tools.lint.checks.NfcTechListDetector;
import com.android.tools.lint.checks.NonInternationalizedSmsDetector;
import com.android.tools.lint.checks.ObsoleteLayoutParamsDetector;
import com.android.tools.lint.checks.OverdrawDetector;
import com.android.tools.lint.checks.ParcelDetector;
import com.android.tools.lint.checks.PluralsDetector;
import com.android.tools.lint.checks.PreferenceActivityDetector;
import com.android.tools.lint.checks.PrivateKeyDetector;
import com.android.tools.lint.checks.PrivateResourceDetector;
import com.android.tools.lint.checks.ProguardDetector;
import com.android.tools.lint.checks.PropertyFileDetector;
import com.android.tools.lint.checks.PxUsageDetector;
import com.android.tools.lint.checks.RegistrationDetector;
import com.android.tools.lint.checks.RequiredAttributeDetector;
import com.android.tools.lint.checks.ResourceCycleDetector;
import com.android.tools.lint.checks.ResourcePrefixDetector;
import com.android.tools.lint.checks.RtlDetector;
import com.android.tools.lint.checks.ScrollViewChildDetector;
import com.android.tools.lint.checks.SdCardDetector;
import com.android.tools.lint.checks.SecurityDetector;
import com.android.tools.lint.checks.ServiceCastDetector;
import com.android.tools.lint.checks.SetJavaScriptEnabledDetector;
import com.android.tools.lint.checks.SharedPrefsDetector;
import com.android.tools.lint.checks.SignatureOrSystemDetector;
import com.android.tools.lint.checks.StateListDetector;
import com.android.tools.lint.checks.StringFormatDetector;
import com.android.tools.lint.checks.SystemPermissionsDetector;
import com.android.tools.lint.checks.TextFieldDetector;
import com.android.tools.lint.checks.TextViewDetector;
import com.android.tools.lint.checks.TitleDetector;
import com.android.tools.lint.checks.ToastDetector;
import com.android.tools.lint.checks.TooManyViewsDetector;
import com.android.tools.lint.checks.TranslationDetector;
import com.android.tools.lint.checks.TypoDetector;
import com.android.tools.lint.checks.TypographyDetector;
import com.android.tools.lint.checks.UnusedResourceDetector;
import com.android.tools.lint.checks.UseCompoundDrawableDetector;
import com.android.tools.lint.checks.UselessViewDetector;
import com.android.tools.lint.checks.Utf8Detector;
import com.android.tools.lint.checks.ViewConstructorDetector;
import com.android.tools.lint.checks.ViewHolderDetector;
import com.android.tools.lint.checks.ViewTypeDetector;
import com.android.tools.lint.checks.WebViewDetector;
import com.android.tools.lint.checks.WrongCallDetector;
import com.android.tools.lint.checks.WrongCaseDetector;
import com.android.tools.lint.checks.WrongIdDetector;
import com.android.tools.lint.checks.WrongImportDetector;
import com.android.tools.lint.checks.WrongLocationDetector;
import com.android.tools.lint.detector.api.Issue;
import com.google.common.collect.Lists;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.android.inspections.lint.AddMissingPrefixQuickFix;
import org.jetbrains.android.inspections.lint.AddTargetApiQuickFix;
import org.jetbrains.android.inspections.lint.AndroidAddStringResourceQuickFix;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.inspections.lint.ConvertNamespaceQuickFix;
import org.jetbrains.android.inspections.lint.ConvertToDpQuickFix;
import org.jetbrains.android.inspections.lint.DefaultLintQuickFix;
import org.jetbrains.android.inspections.lint.InefficientWeightQuickFix;
import org.jetbrains.android.inspections.lint.MoveToDebugManifestQuickFix;
import org.jetbrains.android.inspections.lint.RemoveAttributeQuickFix;
import org.jetbrains.android.inspections.lint.RemoveUselessViewQuickFix;
import org.jetbrains.android.inspections.lint.ReplaceStringQuickFix;
import org.jetbrains.android.inspections.lint.SetAttributeQuickFix;
import org.jetbrains.android.inspections.lint.SetScrollViewSizeQuickFix;
import org.jetbrains.android.inspections.lint.TypographyQuickFix;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public class AndroidLintInspectionToolProvider {
    private static AndroidLintQuickFix[] getApiDetectorFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, String message) {
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider", "getApiDetectorFixes"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider", "getApiDetectorFixes"));
        }
        Pattern pattern = Pattern.compile("\\s(\\d+)\\s");
        Matcher matcher = pattern.matcher(message);
        if (matcher.find()) {
            FolderConfiguration config;
            ResourceFolderType folderType;
            int api = Integer.parseInt(matcher.group(1));
            ArrayList list = Lists.newArrayList();
            PsiFile file = startElement.getContainingFile();
            if (file instanceof XmlFile && (folderType = ResourceHelper.getFolderType(file)) != null && (config = ResourceHelper.getFolderConfiguration(file)) != null) {
                config.setVersionQualifier(new VersionQualifier(api));
                String folder = config.getFolderName(folderType);
                list.add(OverrideResourceAction.createFix(folder));
            }
            list.add(new AddTargetApiQuickFix(api));
            return list.toArray(new AndroidLintQuickFix[list.size()]);
        }
        return AndroidLintQuickFix.EMPTY_ARRAY;
    }

    public static class AndroidLintWrongFolderInspection
    extends AndroidLintInspectionBase {
        public AndroidLintWrongFolderInspection() {
            super(AndroidBundle.message("android.lint.inspections.wrong.folder", new Object[0]), WrongLocationDetector.ISSUE);
        }
    }

    public static class AndroidLintWrongCaseInspection
    extends AndroidLintInspectionBase {
        public AndroidLintWrongCaseInspection() {
            super(AndroidBundle.message("android.lint.inspections.wrong.case", new Object[0]), WrongCaseDetector.WRONG_CASE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintWrongCaseInspection", "getQuickFixes"));
            }
            final String current = WrongCaseDetector.getOldValue((String)message);
            final String proposed = WrongCaseDetector.getNewValue((String)message);
            if (proposed != null && current != null) {
                AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new ReplaceStringQuickFix(null, current, proposed){

                    @Override
                    protected void editAfter(@NotNull Document document) {
                        if (document == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintWrongCaseInspection$1", "editAfter"));
                        }
                        String text = document.getText();
                        int index = text.indexOf("</" + current + ">");
                        if (index != -1) {
                            document.replaceString(index + 2, index + 2 + current.length(), (CharSequence)proposed);
                        }
                    }
                }};
                if (androidLintQuickFixArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintWrongCaseInspection", "getQuickFixes"));
                }
                return androidLintQuickFixArray;
            }
            if (AndroidLintQuickFix.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintWrongCaseInspection", "getQuickFixes"));
            }
            return AndroidLintQuickFix.EMPTY_ARRAY;
        }
    }

    public static class AndroidLintWrongCallInspection
    extends AndroidLintInspectionBase {
        public AndroidLintWrongCallInspection() {
            super(AndroidBundle.message("android.lint.inspections.wrong.call", new Object[0]), WrongCallDetector.ISSUE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintWrongCallInspection", "getQuickFixes"));
            }
            String current = WrongCallDetector.getOldValue((String)message);
            String proposed = WrongCallDetector.getNewValue((String)message);
            if (proposed != null && current != null) {
                AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new ReplaceStringQuickFix("Replace call with " + proposed + "()", current, proposed)};
                if (androidLintQuickFixArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintWrongCallInspection", "getQuickFixes"));
                }
                return androidLintQuickFixArray;
            }
            if (AndroidLintQuickFix.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintWrongCallInspection", "getQuickFixes"));
            }
            return AndroidLintQuickFix.EMPTY_ARRAY;
        }
    }

    public static class AndroidLintWorldReadableFilesInspection
    extends AndroidLintInspectionBase {
        public AndroidLintWorldReadableFilesInspection() {
            super(AndroidBundle.message("android.lint.inspections.world.readable.files", new Object[0]), SecurityDetector.WORLD_READABLE);
        }
    }

    public static class AndroidLintUnlocalizedSmsInspection
    extends AndroidLintInspectionBase {
        public AndroidLintUnlocalizedSmsInspection() {
            super(AndroidBundle.message("android.lint.inspections.unlocalized.sms", new Object[0]), NonInternationalizedSmsDetector.ISSUE);
        }
    }

    public static class AndroidLintUniquePermissionInspection
    extends AndroidLintInspectionBase {
        public AndroidLintUniquePermissionInspection() {
            super(AndroidBundle.message("android.lint.inspections.unique.permission", new Object[0]), ManifestDetector.UNIQUE_PERMISSION);
        }
    }

    public static class AndroidLintTyposInspection
    extends AndroidLintInspectionBase {
        public AndroidLintTyposInspection() {
            super(AndroidBundle.message("android.lint.inspections.typos", new Object[0]), TypoDetector.ISSUE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintTyposInspection", "getQuickFixes"));
            }
            List suggestions = TypoDetector.getSuggestions((String)message);
            if (suggestions != null && !suggestions.isEmpty()) {
                ArrayList fixes = Lists.newArrayListWithExpectedSize((int)suggestions.size());
                for (String suggestion : suggestions) {
                    fixes.add(new ReplaceStringQuickFix("Replace with \"" + suggestion + "\"", null, suggestion));
                }
                AndroidLintQuickFix[] androidLintQuickFixArray = fixes.toArray(new AndroidLintQuickFix[fixes.size()]);
                if (androidLintQuickFixArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintTyposInspection", "getQuickFixes"));
                }
                return androidLintQuickFixArray;
            }
            if (AndroidLintQuickFix.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintTyposInspection", "getQuickFixes"));
            }
            return AndroidLintQuickFix.EMPTY_ARRAY;
        }
    }

    public static class AndroidLintSuspicious0dpInspection
    extends AndroidLintInspectionBase {
        public AndroidLintSuspicious0dpInspection() {
            super(AndroidBundle.message("android.lint.inspections.suspicious0dp", new Object[0]), InefficientWeightDetector.WRONG_0DP);
        }
    }

    public static class AndroidLintStringShouldBeIntInspection
    extends AndroidLintInspectionBase {
        public AndroidLintStringShouldBeIntInspection() {
            super(AndroidBundle.message("android.lint.inspections.string.should.be.int", new Object[0]), GradleDetector.STRING_INTEGER);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintStringShouldBeIntInspection", "getQuickFixes"));
            }
            String current = GradleDetector.getOldValue((Issue)GradleDetector.STRING_INTEGER, (String)message);
            String proposed = GradleDetector.getNewValue((Issue)GradleDetector.STRING_INTEGER, (String)message);
            if (proposed != null && current != null) {
                AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new ReplaceStringQuickFix("Replace with integer", current, proposed)};
                if (androidLintQuickFixArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintStringShouldBeIntInspection", "getQuickFixes"));
                }
                return androidLintQuickFixArray;
            }
            if (AndroidLintQuickFix.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintStringShouldBeIntInspection", "getQuickFixes"));
            }
            return AndroidLintQuickFix.EMPTY_ARRAY;
        }
    }

    public static class AndroidLintStopShipInspection
    extends AndroidLintInspectionBase {
        public AndroidLintStopShipInspection() {
            super(AndroidBundle.message("android.lint.inspections.stop.ship", new Object[0]), CommentDetector.STOP_SHIP);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintStopShipInspection", "getQuickFixes"));
            }
            AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new ReplaceStringQuickFix("Remove STOPSHIP", "(\\s*STOPSHIP)", "")};
            if (androidLintQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintStopShipInspection", "getQuickFixes"));
            }
            return androidLintQuickFixArray;
        }
    }

    public static class AndroidLintSpUsageInspection
    extends AndroidLintInspectionBase {
        public AndroidLintSpUsageInspection() {
            super(AndroidBundle.message("android.lint.inspections.sp.usage", new Object[0]), PxUsageDetector.DP_ISSUE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintSpUsageInspection", "getQuickFixes"));
            }
            AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new ReplaceStringQuickFix(null, "\\d+(di?p)", "sp")};
            if (androidLintQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintSpUsageInspection", "getQuickFixes"));
            }
            return androidLintQuickFixArray;
        }
    }

    public static class AndroidLintSmallSpInspection
    extends AndroidLintInspectionBase {
        public AndroidLintSmallSpInspection() {
            super(AndroidBundle.message("android.lint.inspections.small.sp", new Object[0]), PxUsageDetector.SMALL_SP_ISSUE);
        }
    }

    public static class AndroidLintSignatureOrSystemPermissionsInspection
    extends AndroidLintInspectionBase {
        public AndroidLintSignatureOrSystemPermissionsInspection() {
            super(AndroidBundle.message("android.lint.inspections.signature.or.system.permissions", new Object[0]), SignatureOrSystemDetector.ISSUE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintSignatureOrSystemPermissionsInspection", "getQuickFixes"));
            }
            AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new ReplaceStringQuickFix(null, "signatureOrSystem", "signature")};
            if (androidLintQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintSignatureOrSystemPermissionsInspection", "getQuickFixes"));
            }
            return androidLintQuickFixArray;
        }
    }

    public static class AndroidLintShowToastInspection
    extends AndroidLintInspectionBase {
        public AndroidLintShowToastInspection() {
            super(AndroidBundle.message("android.lint.inspections.show.toast", new Object[0]), ToastDetector.ISSUE);
        }
    }

    public static class AndroidLintSetJavaScriptEnabledInspection
    extends AndroidLintInspectionBase {
        public AndroidLintSetJavaScriptEnabledInspection() {
            super(AndroidBundle.message("android.lint.inspections.set.java.script.enabled", new Object[0]), SetJavaScriptEnabledDetector.ISSUE);
        }
    }

    public static class AndroidLintServiceCastInspection
    extends AndroidLintInspectionBase {
        public AndroidLintServiceCastInspection() {
            super(AndroidBundle.message("android.lint.inspections.service.cast", new Object[0]), ServiceCastDetector.ISSUE);
        }
    }

    public static class AndroidLintSelectableTextInspection
    extends AndroidLintInspectionBase {
        public AndroidLintSelectableTextInspection() {
            super(AndroidBundle.message("android.lint.inspections.selectable.text", new Object[0]), TextViewDetector.SELECTABLE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintSelectableTextInspection", "getQuickFixes"));
            }
            AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new SetAttributeQuickFix("Set android:textIsSelectable=true", "textIsSelectable", "true")};
            if (androidLintQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintSelectableTextInspection", "getQuickFixes"));
            }
            return androidLintQuickFixArray;
        }
    }

    public static class AndroidLintResAutoInspection
    extends AndroidLintInspectionBase {
        public AndroidLintResAutoInspection() {
            super(AndroidBundle.message("android.lint.inspections.res.auto", new Object[0]), NamespaceDetector.RES_AUTO);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintResAutoInspection", "getQuickFixes"));
            }
            AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new ConvertNamespaceQuickFix()};
            if (androidLintQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintResAutoInspection", "getQuickFixes"));
            }
            return androidLintQuickFixArray;
        }
    }

    public static class AndroidLintRequiredSizeInspection
    extends AndroidLintInspectionBase {
        public AndroidLintRequiredSizeInspection() {
            super(AndroidBundle.message("android.lint.inspections.required.size", new Object[0]), RequiredAttributeDetector.ISSUE);
        }
    }

    public static class AndroidLintRegisteredInspection
    extends AndroidLintInspectionBase {
        public AndroidLintRegisteredInspection() {
            super(AndroidBundle.message("android.lint.inspections.registered", new Object[0]), RegistrationDetector.ISSUE);
        }
    }

    public static class AndroidLintReferenceTypeInspection
    extends AndroidLintInspectionBase {
        public AndroidLintReferenceTypeInspection() {
            super(AndroidBundle.message("android.lint.inspections.reference.type", new Object[0]), DuplicateResourceDetector.TYPE_MISMATCH);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintReferenceTypeInspection", "getQuickFixes"));
            }
            String expected = DuplicateResourceDetector.getExpectedType((String)message);
            if (expected != null) {
                AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new ReplaceStringQuickFix(null, "(@.*/)", "@" + expected + "/")};
                if (androidLintQuickFixArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintReferenceTypeInspection", "getQuickFixes"));
                }
                return androidLintQuickFixArray;
            }
            if (AndroidLintQuickFix.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintReferenceTypeInspection", "getQuickFixes"));
            }
            return AndroidLintQuickFix.EMPTY_ARRAY;
        }
    }

    public static class AndroidLintProtectedPermissionsInspection
    extends AndroidLintInspectionBase {
        public AndroidLintProtectedPermissionsInspection() {
            super(AndroidBundle.message("android.lint.inspections.protected.permissions", new Object[0]), SystemPermissionsDetector.ISSUE);
        }
    }

    public static class AndroidLintPropertyEscapeInspection
    extends AndroidLintInspectionBase {
        public AndroidLintPropertyEscapeInspection() {
            super(AndroidBundle.message("android.lint.inspections.property.escape", new Object[0]), PropertyFileDetector.ISSUE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintPropertyEscapeInspection", "getQuickFixes"));
            }
            String escaped = PropertyFileDetector.getSuggestedEscape((String)message);
            if (escaped != null) {
                AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new ReplaceStringQuickFix(null, null, escaped)};
                if (androidLintQuickFixArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintPropertyEscapeInspection", "getQuickFixes"));
                }
                return androidLintQuickFixArray;
            }
            if (AndroidLintQuickFix.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintPropertyEscapeInspection", "getQuickFixes"));
            }
            return AndroidLintQuickFix.EMPTY_ARRAY;
        }
    }

    public static class AndroidLintPackagedPrivateKeyInspection
    extends AndroidLintInspectionBase {
        public AndroidLintPackagedPrivateKeyInspection() {
            super(AndroidBundle.message("android.lint.inspections.packaged.private.key", new Object[0]), PrivateKeyDetector.ISSUE);
        }
    }

    public static class AndroidLintOrientationInspection
    extends AndroidLintInspectionBase {
        public AndroidLintOrientationInspection() {
            super(AndroidBundle.message("android.lint.inspections.orientation", new Object[0]), InefficientWeightDetector.ORIENTATION);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintOrientationInspection", "getQuickFixes"));
            }
            AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new SetAttributeQuickFix("Set orientation=\"horizontal\" (default)", "orientation", "horizontal"), new SetAttributeQuickFix("Set orientation=\"false\" (changes layout)", "orientation", "vertical")};
            if (androidLintQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintOrientationInspection", "getQuickFixes"));
            }
            return androidLintQuickFixArray;
        }
    }

    public static class AndroidLintOldTargetApiInspection
    extends AndroidLintInspectionBase {
        public AndroidLintOldTargetApiInspection() {
            super(AndroidBundle.message("android.lint.inspections.old.target.api", new Object[0]), ManifestDetector.TARGET_NEWER);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
            if (startElement == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintOldTargetApiInspection", "getQuickFixes"));
            }
            if (endElement == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintOldTargetApiInspection", "getQuickFixes"));
            }
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintOldTargetApiInspection", "getQuickFixes"));
            }
            String highest = Integer.toString(20);
            String label = "Update targetSdkVersion to " + highest;
            if (startElement.getContainingFile() instanceof XmlFile) {
                AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new ReplaceStringQuickFix(label, "targetSdkVersion\\s*=\\s*[\"'](.*)[\"']", highest)};
                if (androidLintQuickFixArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintOldTargetApiInspection", "getQuickFixes"));
                }
                return androidLintQuickFixArray;
            }
            if (startElement.getContainingFile() instanceof GroovyFile) {
                AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new ReplaceStringQuickFix(label, null, highest)};
                if (androidLintQuickFixArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintOldTargetApiInspection", "getQuickFixes"));
                }
                return androidLintQuickFixArray;
            }
            if (AndroidLintQuickFix.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintOldTargetApiInspection", "getQuickFixes"));
            }
            return AndroidLintQuickFix.EMPTY_ARRAY;
        }
    }

    public static class AndroidLintMissingVersionInspection
    extends AndroidLintInspectionBase {
        public AndroidLintMissingVersionInspection() {
            super(AndroidBundle.message("android.lint.inspections.missing.version", new Object[0]), ManifestDetector.SET_VERSION);
        }
    }

    public static class AndroidLintMissingIdInspection
    extends AndroidLintInspectionBase {
        public AndroidLintMissingIdInspection() {
            super(AndroidBundle.message("android.lint.inspections.missing.id", new Object[0]), MissingIdDetector.ISSUE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintMissingIdInspection", "getQuickFixes"));
            }
            AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new SetAttributeQuickFix("Set id", "id", null)};
            if (androidLintQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintMissingIdInspection", "getQuickFixes"));
            }
            return androidLintQuickFixArray;
        }
    }

    public static class AndroidLintMenuTitleInspection
    extends AndroidLintInspectionBase {
        public AndroidLintMenuTitleInspection() {
            super(AndroidBundle.message("android.lint.inspections.menu.title", new Object[0]), TitleDetector.ISSUE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintMenuTitleInspection", "getQuickFixes"));
            }
            AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new SetAttributeQuickFix("Set title", "title", null)};
            if (androidLintQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintMenuTitleInspection", "getQuickFixes"));
            }
            return androidLintQuickFixArray;
        }
    }

    public static class AndroidLintMangledCRLFInspection
    extends AndroidLintInspectionBase {
        public AndroidLintMangledCRLFInspection() {
            super(AndroidBundle.message("android.lint.inspections.mangled.crlf", new Object[0]), DosLineEndingDetector.ISSUE);
        }
    }

    public static class AndroidLintLocalSuppressInspection
    extends AndroidLintInspectionBase {
        public AndroidLintLocalSuppressInspection() {
            super(AndroidBundle.message("android.lint.inspections.local.suppress", new Object[0]), AnnotationDetector.ISSUE);
        }
    }

    public static class AndroidLintLocaleFolderInspection
    extends AndroidLintInspectionBase {
        public AndroidLintLocaleFolderInspection() {
            super(AndroidBundle.message("android.lint.inspections.locale.folder", new Object[0]), LocaleFolderDetector.ISSUE);
        }
    }

    public static class AndroidLintLabelForInspection
    extends AndroidLintInspectionBase {
        public AndroidLintLabelForInspection() {
            super(AndroidBundle.message("android.lint.inspections.label.for", new Object[0]), LabelForDetector.ISSUE);
        }
    }

    public static class AndroidLintInvalidIdInspection
    extends AndroidLintInspectionBase {
        public AndroidLintInvalidIdInspection() {
            super(AndroidBundle.message("android.lint.inspections.invalid.id", new Object[0]), WrongIdDetector.INVALID);
        }
    }

    public static class AndroidLintInnerclassSeparatorInspection
    extends AndroidLintInspectionBase {
        public AndroidLintInnerclassSeparatorInspection() {
            super(AndroidBundle.message("android.lint.inspections.innerclass.separator", new Object[0]), MissingClassDetector.INNERCLASS);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintInnerclassSeparatorInspection", "getQuickFixes"));
            }
            String current = MissingClassDetector.getOldValue((Issue)MissingClassDetector.INNERCLASS, (String)message);
            String proposed = MissingClassDetector.getNewValue((Issue)MissingClassDetector.INNERCLASS, (String)message);
            if (proposed != null && current != null) {
                AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new ReplaceStringQuickFix(null, current, proposed)};
                if (androidLintQuickFixArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintInnerclassSeparatorInspection", "getQuickFixes"));
                }
                return androidLintQuickFixArray;
            }
            if (AndroidLintQuickFix.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintInnerclassSeparatorInspection", "getQuickFixes"));
            }
            return AndroidLintQuickFix.EMPTY_ARRAY;
        }
    }

    public static class AndroidLintInOrMmUsageInspection
    extends AndroidLintInspectionBase {
        public AndroidLintInOrMmUsageInspection() {
            super(AndroidBundle.message("android.lint.inspections.in.or.mm.usage", new Object[0]), PxUsageDetector.IN_MM_ISSUE);
        }
    }

    public static class AndroidLintInflateParamsInspection
    extends AndroidLintInspectionBase {
        public AndroidLintInflateParamsInspection() {
            super(AndroidBundle.message("android.lint.inspections.inflate.params", new Object[0]), LayoutInflationDetector.ISSUE);
        }
    }

    public static class AndroidLintIncludeLayoutParamInspection
    extends AndroidLintInspectionBase {
        public AndroidLintIncludeLayoutParamInspection() {
            super(AndroidBundle.message("android.lint.inspections.include.layout.param", new Object[0]), IncludeDetector.ISSUE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintIncludeLayoutParamInspection", "getQuickFixes"));
            }
            ArrayList fixes = Lists.newArrayListWithExpectedSize((int)2);
            if (IncludeDetector.requestsWidth((String)message)) {
                fixes.add(new SetAttributeQuickFix("Set layout_width", "layout_width", null));
            }
            if (IncludeDetector.requestsHeight((String)message)) {
                fixes.add(new SetAttributeQuickFix("Set layout_height", "layout_height", null));
            }
            AndroidLintQuickFix[] androidLintQuickFixArray = fixes.toArray(new AndroidLintQuickFix[fixes.size()]);
            if (androidLintQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintIncludeLayoutParamInspection", "getQuickFixes"));
            }
            return androidLintQuickFixArray;
        }
    }

    public static class AndroidLintImpliedQuantityInspection
    extends AndroidLintInspectionBase {
        public AndroidLintImpliedQuantityInspection() {
            super(AndroidBundle.message("android.lint.inspections.implied.quantity", new Object[0]), PluralsDetector.IMPLIED_QUANTITY);
        }
    }

    public static class AndroidLintIllegalResourceRefInspection
    extends AndroidLintInspectionBase {
        public AndroidLintIllegalResourceRefInspection() {
            super(AndroidBundle.message("android.lint.inspections.illegal.resource.ref", new Object[0]), ManifestDetector.ILLEGAL_REFERENCE);
        }
    }

    public static class AndroidLintIconXmlAndPngInspection
    extends AndroidLintInspectionBase {
        public AndroidLintIconXmlAndPngInspection() {
            super(AndroidBundle.message("android.lint.inspections.icon.xml.and.png", new Object[0]), IconDetector.ICON_XML_AND_PNG);
        }
    }

    public static class AndroidLintIconLauncherShapeInspection
    extends AndroidLintInspectionBase {
        public AndroidLintIconLauncherShapeInspection() {
            super(AndroidBundle.message("android.lint.inspections.icon.launcher.shape", new Object[0]), IconDetector.ICON_LAUNCHER_SHAPE);
        }
    }

    public static class AndroidLintIconExtensionInspection
    extends AndroidLintInspectionBase {
        public AndroidLintIconExtensionInspection() {
            super(AndroidBundle.message("android.lint.inspections.icon.extension", new Object[0]), IconDetector.ICON_EXTENSION);
        }
    }

    public static class AndroidLintIconColorsInspection
    extends AndroidLintInspectionBase {
        public AndroidLintIconColorsInspection() {
            super(AndroidBundle.message("android.lint.inspections.icon.colors", new Object[0]), IconDetector.ICON_COLORS);
        }
    }

    public static class AndroidLintExportedReceiverInspection
    extends AndroidLintInspectionBase {
        public AndroidLintExportedReceiverInspection() {
            super(AndroidBundle.message("android.lint.inspections.exported.receiver", new Object[0]), SecurityDetector.EXPORTED_RECEIVER);
        }
    }

    public static class AndroidLintExportedPreferenceActivityInspection
    extends AndroidLintInspectionBase {
        public AndroidLintExportedPreferenceActivityInspection() {
            super(AndroidBundle.message("android.lint.inspections.exported.preference.activity", new Object[0]), PreferenceActivityDetector.ISSUE);
        }
    }

    public static class AndroidLintExportedContentProviderInspection
    extends AndroidLintInspectionBase {
        public AndroidLintExportedContentProviderInspection() {
            super(AndroidBundle.message("android.lint.inspections.exported.content.provider", new Object[0]), SecurityDetector.EXPORTED_PROVIDER);
        }
    }

    public static class AndroidLintEasterEggInspection
    extends AndroidLintInspectionBase {
        public AndroidLintEasterEggInspection() {
            super(AndroidBundle.message("android.lint.inspections.easter.egg", new Object[0]), CommentDetector.EASTER_EGG);
        }
    }

    public static class AndroidLintDuplicateDefinitionInspection
    extends AndroidLintInspectionBase {
        public AndroidLintDuplicateDefinitionInspection() {
            super(AndroidBundle.message("android.lint.inspections.duplicate.definition", new Object[0]), DuplicateResourceDetector.ISSUE);
        }
    }

    public static class AndroidLintDuplicateActivityInspection
    extends AndroidLintInspectionBase {
        public AndroidLintDuplicateActivityInspection() {
            super(AndroidBundle.message("android.lint.inspections.duplicate.activity", new Object[0]), ManifestDetector.DUPLICATE_ACTIVITY);
        }
    }

    public static class AndroidLintCutPasteIdInspection
    extends AndroidLintInspectionBase {
        public AndroidLintCutPasteIdInspection() {
            super(AndroidBundle.message("android.lint.inspections.cut.paste.id", new Object[0]), CutPasteDetector.ISSUE);
        }
    }

    public static class AndroidLintCommitPrefEditsInspection
    extends AndroidLintInspectionBase {
        public AndroidLintCommitPrefEditsInspection() {
            super(AndroidBundle.message("android.lint.inspections.commit.pref.edits", new Object[0]), SharedPrefsDetector.ISSUE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintCommitPrefEditsInspection", "getQuickFixes"));
            }
            if (message.contains("commit") && message.contains("apply")) {
                AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new ReplaceStringQuickFix("Replace commit() with apply()", "(commit)\\s*\\(", "apply")};
                if (androidLintQuickFixArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintCommitPrefEditsInspection", "getQuickFixes"));
                }
                return androidLintQuickFixArray;
            }
            if (AndroidLintQuickFix.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintCommitPrefEditsInspection", "getQuickFixes"));
            }
            return AndroidLintQuickFix.EMPTY_ARRAY;
        }
    }

    public static class AndroidLintByteOrderMarkInspection
    extends AndroidLintInspectionBase {
        public AndroidLintByteOrderMarkInspection() {
            super(AndroidBundle.message("android.lint.inspections.byte.order.mark", new Object[0]), ByteOrderMarkDetector.BOM);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
            if (startElement == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintByteOrderMarkInspection", "getQuickFixes"));
            }
            if (endElement == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintByteOrderMarkInspection", "getQuickFixes"));
            }
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintByteOrderMarkInspection", "getQuickFixes"));
            }
            AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new DefaultLintQuickFix("Remove byte order marks"){

                @Override
                public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
                    if (startElement == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintByteOrderMarkInspection$1", "apply"));
                    }
                    if (endElement == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintByteOrderMarkInspection$1", "apply"));
                    }
                    if (context == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintByteOrderMarkInspection$1", "apply"));
                    }
                    Document document = FileDocumentManager.getInstance().getDocument(startElement.getContainingFile().getVirtualFile());
                    if (document != null) {
                        String text = document.getText();
                        for (int i = text.length() - 1; i >= 0; --i) {
                            char c = text.charAt(i);
                            if (c != '\ufeff') continue;
                            document.deleteString(i, i + 1);
                        }
                    }
                }
            }};
            if (androidLintQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintByteOrderMarkInspection", "getQuickFixes"));
            }
            return androidLintQuickFixArray;
        }
    }

    public static class AndroidLintButtonStyleInspection
    extends AndroidLintInspectionBase {
        public AndroidLintButtonStyleInspection() {
            super(AndroidBundle.message("android.lint.inspections.button.style", new Object[0]), ButtonDetector.STYLE);
        }
    }

    public static class AndroidLintAllowBackupInspection
    extends AndroidLintInspectionBase {
        public AndroidLintAllowBackupInspection() {
            super(AndroidBundle.message("android.lint.inspections.allow.backup", new Object[0]), ManifestDetector.ALLOW_BACKUP);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
            if (startElement == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintAllowBackupInspection", "getQuickFixes"));
            }
            if (endElement == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintAllowBackupInspection", "getQuickFixes"));
            }
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintAllowBackupInspection", "getQuickFixes"));
            }
            AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new SetAttributeQuickFix("Set backup attribute", "allowBackup", null)};
            if (androidLintQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintAllowBackupInspection", "getQuickFixes"));
            }
            return androidLintQuickFixArray;
        }
    }

    public static class AndroidLintAddJavascriptInterfaceInspection
    extends AndroidLintInspectionBase {
        public AndroidLintAddJavascriptInterfaceInspection() {
            super(AndroidBundle.message("android.lint.inspections.add.javascript.interface", new Object[0]), AddJavascriptInterfaceDetector.ISSUE);
        }
    }

    public static class AndroidLintRtlSymmetryInspection
    extends AndroidLintInspectionBase {
        public AndroidLintRtlSymmetryInspection() {
            super(AndroidBundle.message("android.lint.inspections.rtl.symmetry", new Object[0]), RtlDetector.SYMMETRY);
        }
    }

    public static class AndroidLintRtlHardcodedInspection
    extends AndroidLintInspectionBase {
        public AndroidLintRtlHardcodedInspection() {
            super(AndroidBundle.message("android.lint.inspections.rtl.hardcoded", new Object[0]), RtlDetector.USE_START);
        }
    }

    public static class AndroidLintRtlEnabledInspection
    extends AndroidLintInspectionBase {
        public AndroidLintRtlEnabledInspection() {
            super(AndroidBundle.message("android.lint.inspections.rtl.enabled", new Object[0]), RtlDetector.ENABLED);
        }
    }

    public static class AndroidLintRtlCompatInspection
    extends AndroidLintInspectionBase {
        public AndroidLintRtlCompatInspection() {
            super(AndroidBundle.message("android.lint.inspections.rtl.compat", new Object[0]), RtlDetector.COMPAT);
        }
    }

    public static class AndroidLintResourceNameInspection
    extends AndroidLintInspectionBase {
        public AndroidLintResourceNameInspection() {
            super(AndroidBundle.message("android.lint.inspections.resource.name", new Object[0]), ResourcePrefixDetector.ISSUE);
        }
    }

    public static class AndroidLintResourceCycleInspection
    extends AndroidLintInspectionBase {
        public AndroidLintResourceCycleInspection() {
            super(AndroidBundle.message("android.lint.inspections.resource.cycle", new Object[0]), ResourceCycleDetector.CYCLE);
        }
    }

    public static class AndroidLintMissingApplicationIconInspection
    extends AndroidLintInspectionBase {
        public AndroidLintMissingApplicationIconInspection() {
            super(AndroidBundle.message("android.lint.inspections.missing.application.icon", new Object[0]), ManifestDetector.APPLICATION_ICON);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
            if (startElement == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintMissingApplicationIconInspection", "getQuickFixes"));
            }
            if (endElement == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintMissingApplicationIconInspection", "getQuickFixes"));
            }
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintMissingApplicationIconInspection", "getQuickFixes"));
            }
            AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new SetAttributeQuickFix("Set application icon", "icon", null)};
            if (androidLintQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintMissingApplicationIconInspection", "getQuickFixes"));
            }
            return androidLintQuickFixArray;
        }
    }

    public static class AndroidLintDuplicateUsesFeatureInspection
    extends AndroidLintInspectionBase {
        public AndroidLintDuplicateUsesFeatureInspection() {
            super(AndroidBundle.message("android.lint.inspections.duplicate.uses.feature", new Object[0]), ManifestDetector.DUPLICATE_USES_FEATURE);
        }
    }

    public static class AndroidLintOverrideInspection
    extends AndroidLintInspectionBase {
        public AndroidLintOverrideInspection() {
            super(AndroidBundle.message("android.lint.inspections.override", new Object[0]), ApiDetector.OVERRIDE);
        }
    }

    public static class AndroidLintInlinedApiInspection
    extends AndroidLintInspectionBase {
        public AndroidLintInlinedApiInspection() {
            super(AndroidBundle.message("android.lint.inspections.inlined.api", new Object[0]), ApiDetector.INLINED);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
            if (startElement == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintInlinedApiInspection", "getQuickFixes"));
            }
            if (endElement == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintInlinedApiInspection", "getQuickFixes"));
            }
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintInlinedApiInspection", "getQuickFixes"));
            }
            AndroidLintQuickFix[] androidLintQuickFixArray = AndroidLintInspectionToolProvider.getApiDetectorFixes(startElement, endElement, message);
            if (androidLintQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintInlinedApiInspection", "getQuickFixes"));
            }
            return androidLintQuickFixArray;
        }
    }

    public static class AndroidLintNewApiInspection
    extends AndroidLintInspectionBase {
        public AndroidLintNewApiInspection() {
            super(AndroidBundle.message("android.lint.inspections.new.api", new Object[0]), ApiDetector.UNSUPPORTED);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
            if (startElement == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintNewApiInspection", "getQuickFixes"));
            }
            if (endElement == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintNewApiInspection", "getQuickFixes"));
            }
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintNewApiInspection", "getQuickFixes"));
            }
            AndroidLintQuickFix[] androidLintQuickFixArray = AndroidLintInspectionToolProvider.getApiDetectorFixes(startElement, endElement, message);
            if (androidLintQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintNewApiInspection", "getQuickFixes"));
            }
            return androidLintQuickFixArray;
        }
    }

    private static abstract class AndroidLintTypographyInspectionBase
    extends AndroidLintInspectionBase {
        public AndroidLintTypographyInspectionBase(String displayName, Issue issue) {
            super(displayName, issue);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintTypographyInspectionBase", "getQuickFixes"));
            }
            AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new TypographyQuickFix(this.myIssue, message)};
            if (androidLintQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintTypographyInspectionBase", "getQuickFixes"));
            }
            return androidLintQuickFixArray;
        }
    }

    public static class AndroidLintUselessLeafInspection
    extends AndroidLintInspectionBase {
        public AndroidLintUselessLeafInspection() {
            super(AndroidBundle.message("android.lint.inspections.useless.leaf", new Object[0]), UselessViewDetector.USELESS_LEAF);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintUselessLeafInspection", "getQuickFixes"));
            }
            AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new RemoveUselessViewQuickFix(this.myIssue)};
            if (androidLintQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintUselessLeafInspection", "getQuickFixes"));
            }
            return androidLintQuickFixArray;
        }
    }

    public static class AndroidLintUselessParentInspection
    extends AndroidLintInspectionBase {
        public AndroidLintUselessParentInspection() {
            super(AndroidBundle.message("android.lint.inspections.useless.parent", new Object[0]), UselessViewDetector.USELESS_PARENT);
        }
    }

    public static class AndroidLintUseCompoundDrawablesInspection
    extends AndroidLintInspectionBase {
        public AndroidLintUseCompoundDrawablesInspection() {
            super(AndroidBundle.message("android.lint.inspections.use.compound.drawables", new Object[0]), UseCompoundDrawableDetector.ISSUE);
        }
    }

    public static class AndroidLintUseCheckPermissionInspection
    extends AndroidLintInspectionBase {
        public AndroidLintUseCheckPermissionInspection() {
            super(AndroidBundle.message("android.lint.inspections.use.check.permission", new Object[0]), CheckPermissionDetector.ISSUE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
            if (startElement == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintUseCheckPermissionInspection", "getQuickFixes"));
            }
            if (endElement == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintUseCheckPermissionInspection", "getQuickFixes"));
            }
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintUseCheckPermissionInspection", "getQuickFixes"));
            }
            AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new ReplaceStringQuickFix("Change check to enforce", "(check).*\\(", "enforce"){

                @Override
                public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
                    Document document;
                    if (startElement == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintUseCheckPermissionInspection$1", "apply"));
                    }
                    if (endElement == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintUseCheckPermissionInspection$1", "apply"));
                    }
                    if (context == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintUseCheckPermissionInspection$1", "apply"));
                    }
                    PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiMethodCallExpression.class);
                    if (call != null && (document = FileDocumentManager.getInstance().getDocument(startElement.getContainingFile().getVirtualFile())) != null) {
                        PsiExpressionList argumentList = call.getArgumentList();
                        int offset = argumentList.getTextOffset() + argumentList.getTextLength() - 1;
                        document.insertString(offset, (CharSequence)", \"TODO: message if thrown\"");
                    }
                    super.apply(startElement, endElement, context);
                }
            }};
            if (androidLintQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintUseCheckPermissionInspection", "getQuickFixes"));
            }
            return androidLintQuickFixArray;
        }
    }

    public static class AndroidLintTypographyOtherInspection
    extends AndroidLintTypographyInspectionBase {
        public AndroidLintTypographyOtherInspection() {
            super(AndroidBundle.message("android.lint.inspections.typography.other", new Object[0]), TypographyDetector.OTHER);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintTypographyOtherInspection", "getQuickFixes"));
            }
            AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new TypographyQuickFix(this.myIssue, message)};
            if (androidLintQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintTypographyOtherInspection", "getQuickFixes"));
            }
            return androidLintQuickFixArray;
        }
    }

    public static class AndroidLintTypographyEllipsisInspection
    extends AndroidLintTypographyInspectionBase {
        public AndroidLintTypographyEllipsisInspection() {
            super(AndroidBundle.message("android.lint.inspections.typography.ellipsis", new Object[0]), TypographyDetector.ELLIPSIS);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintTypographyEllipsisInspection", "getQuickFixes"));
            }
            AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new TypographyQuickFix(this.myIssue, message)};
            if (androidLintQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintTypographyEllipsisInspection", "getQuickFixes"));
            }
            return androidLintQuickFixArray;
        }
    }

    public static class AndroidLintTypographyFractionsInspection
    extends AndroidLintTypographyInspectionBase {
        public AndroidLintTypographyFractionsInspection() {
            super(AndroidBundle.message("android.lint.inspections.typography.fractions", new Object[0]), TypographyDetector.FRACTIONS);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintTypographyFractionsInspection", "getQuickFixes"));
            }
            AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new TypographyQuickFix(this.myIssue, message)};
            if (androidLintQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintTypographyFractionsInspection", "getQuickFixes"));
            }
            return androidLintQuickFixArray;
        }
    }

    public static class AndroidLintTypographyQuotesInspection
    extends AndroidLintTypographyInspectionBase {
        public AndroidLintTypographyQuotesInspection() {
            super(AndroidBundle.message("android.lint.inspections.typography.quotes", new Object[0]), TypographyDetector.QUOTES);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintTypographyQuotesInspection", "getQuickFixes"));
            }
            AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new TypographyQuickFix(this.myIssue, message)};
            if (androidLintQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintTypographyQuotesInspection", "getQuickFixes"));
            }
            return androidLintQuickFixArray;
        }
    }

    public static class AndroidLintTypographyDashesInspection
    extends AndroidLintTypographyInspectionBase {
        public AndroidLintTypographyDashesInspection() {
            super(AndroidBundle.message("android.lint.inspections.typography.dashes", new Object[0]), TypographyDetector.DASHES);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintTypographyDashesInspection", "getQuickFixes"));
            }
            AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new TypographyQuickFix(this.myIssue, message)};
            if (androidLintQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintTypographyDashesInspection", "getQuickFixes"));
            }
            return androidLintQuickFixArray;
        }
    }

    public static class AndroidLintTooDeepLayoutInspection
    extends AndroidLintInspectionBase {
        public AndroidLintTooDeepLayoutInspection() {
            super(AndroidBundle.message("android.lint.inspections.too.deep.layout", new Object[0]), TooManyViewsDetector.TOO_DEEP);
        }
    }

    public static class AndroidLintTooManyViewsInspection
    extends AndroidLintInspectionBase {
        public AndroidLintTooManyViewsInspection() {
            super(AndroidBundle.message("android.lint.inspections.too.many.views", new Object[0]), TooManyViewsDetector.TOO_MANY);
        }
    }

    public static class AndroidLintTextFieldsInspection
    extends AndroidLintInspectionBase {
        public AndroidLintTextFieldsInspection() {
            super(AndroidBundle.message("android.lint.inspections.text.fields", new Object[0]), TextFieldDetector.ISSUE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintTextFieldsInspection", "getQuickFixes"));
            }
            AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new SetAttributeQuickFix(AndroidBundle.message("android.lint.fix.add.input.type.attribute", new Object[0]), "inputType", null)};
            if (androidLintQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintTextFieldsInspection", "getQuickFixes"));
            }
            return androidLintQuickFixArray;
        }
    }

    public static class AndroidLintStateListReachableInspection
    extends AndroidLintInspectionBase {
        public AndroidLintStateListReachableInspection() {
            super(AndroidBundle.message("android.lint.inspections.state.list.reachable", new Object[0]), StateListDetector.ISSUE);
        }
    }

    public static class AndroidLintWorldWriteableFilesInspection
    extends AndroidLintInspectionBase {
        public AndroidLintWorldWriteableFilesInspection() {
            super(AndroidBundle.message("android.lint.inspections.world.writeable.files", new Object[0]), SecurityDetector.WORLD_WRITEABLE);
        }
    }

    public static class AndroidLintGrantAllUrisInspection
    extends AndroidLintInspectionBase {
        public AndroidLintGrantAllUrisInspection() {
            super(AndroidBundle.message("android.lint.inspections.grant.all.uris", new Object[0]), SecurityDetector.OPEN_PROVIDER);
        }
    }

    public static class AndroidLintGradleMisplacedStatementInspection
    extends AndroidLintInspectionBase {
        public AndroidLintGradleMisplacedStatementInspection() {
            super(AndroidBundle.message("android.lint.inspections.gradle.misplaced.statement", new Object[0]), GradleDetector.MISPLACED_STATEMENT);
        }
    }

    public static class AndroidLintGradleImproperProjectLevelStatementInspection
    extends AndroidLintInspectionBase {
        public AndroidLintGradleImproperProjectLevelStatementInspection() {
            super(AndroidBundle.message("android.lint.inspections.gradle.improper.project.level.statement", new Object[0]), GradleDetector.IMPROPER_PROJECT_LEVEL_STATEMENT);
        }
    }

    public static class AndroidLintGradlePathInspection
    extends AndroidLintInspectionBase {
        public AndroidLintGradlePathInspection() {
            super(AndroidBundle.message("android.lint.inspections.gradle.path", new Object[0]), GradleDetector.PATH);
        }
    }

    public static class AndroidLintGradleOverridesInspection
    extends AndroidLintInspectionBase {
        public AndroidLintGradleOverridesInspection() {
            super(AndroidBundle.message("android.lint.inspections.gradle.overrides", new Object[0]), ManifestDetector.GRADLE_OVERRIDES);
        }
    }

    public static class AndroidLintGradleIdeErrorInspection
    extends AndroidLintInspectionBase {
        public AndroidLintGradleIdeErrorInspection() {
            super(AndroidBundle.message("android.lint.inspections.gradle.ide.error", new Object[0]), GradleDetector.IDE_SUPPORT);
        }
    }

    public static class AndroidLintGradleGetterInspection
    extends AndroidLintInspectionBase {
        public AndroidLintGradleGetterInspection() {
            super(AndroidBundle.message("android.lint.inspections.gradle.getter", new Object[0]), GradleDetector.GRADLE_GETTER);
        }
    }

    public static class AndroidLintGradleDynamicVersionInspection
    extends AndroidLintInspectionBase {
        public AndroidLintGradleDynamicVersionInspection() {
            super(AndroidBundle.message("android.lint.inspections.gradle.dynamic.version", new Object[0]), GradleDetector.PLUS);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
            GradleCoordinate plus;
            if (startElement == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintGradleDynamicVersionInspection", "getQuickFixes"));
            }
            if (endElement == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintGradleDynamicVersionInspection", "getQuickFixes"));
            }
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintGradleDynamicVersionInspection", "getQuickFixes"));
            }
            String before = GradleDetector.getOldValue((Issue)GradleDetector.PLUS, (String)message);
            if (before != null && before.endsWith("+") && (plus = GradleCoordinate.parseCoordinateString((String)before)) != null && plus.getArtifactId() != null) {
                AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new ReplaceStringQuickFix("Replace with specific version", before, "specific version"){

                    @Override
                    @Nullable
                    protected String getNewValue() {
                        String filter = plus.getFullRevision();
                        assert (filter.endsWith("+")) : filter;
                        filter = filter.substring(0, filter.length() - 1);
                        String artifactId = plus.getArtifactId();
                        if (RepositoryUrlManager.supports(plus.getArtifactId())) {
                            GradleCoordinate available;
                            String libraryCoordinate = RepositoryUrlManager.get().getLibraryCoordinate(artifactId, filter, false);
                            if (libraryCoordinate != null && (available = GradleCoordinate.parseCoordinateString((String)libraryCoordinate)) != null) {
                                return available.toString();
                            }
                            libraryCoordinate = RepositoryUrlManager.get().getLibraryCoordinate(artifactId, filter, true);
                            if (libraryCoordinate != null && (available = GradleCoordinate.parseCoordinateString((String)libraryCoordinate)) != null) {
                                return available.toString();
                            }
                        }
                        ArrayList coordinates = Lists.newArrayList();
                        File gradleCache = new File(SystemProperties.getUserHome(), ".gradle" + File.separator + "caches");
                        if (gradleCache.exists()) {
                            String groupId = plus.getGroupId();
                            for (File moduleDir : FileUtil.notNullize((File[])gradleCache.listFiles())) {
                                if (!moduleDir.getName().startsWith("modules-") || !moduleDir.isDirectory()) continue;
                                for (File metadataDir : FileUtil.notNullize((File[])moduleDir.listFiles())) {
                                    File versionDir;
                                    if (!metadataDir.getName().startsWith("metadata-") || !metadataDir.isDirectory() || !(versionDir = new File(metadataDir, "descriptors" + File.separator + groupId + File.separator + artifactId)).isDirectory()) continue;
                                    for (File version : FileUtil.notNullize((File[])versionDir.listFiles())) {
                                        GradleCoordinate v;
                                        String name = version.getName();
                                        if (!name.startsWith(filter) || name.isEmpty() || !Character.isDigit(name.charAt(0)) || (v = GradleCoordinate.parseCoordinateString((String)(groupId + ":" + artifactId + ":" + name))) == null) continue;
                                        coordinates.add(v);
                                    }
                                }
                            }
                            if (!coordinates.isEmpty()) {
                                Collections.sort(coordinates, GradleCoordinate.COMPARE_PLUS_LOWER);
                                GradleCoordinate best = (GradleCoordinate)coordinates.get(coordinates.size() - 1);
                                return best.toString();
                            }
                        }
                        return null;
                    }
                }};
                if (androidLintQuickFixArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintGradleDynamicVersionInspection", "getQuickFixes"));
                }
                return androidLintQuickFixArray;
            }
            if (AndroidLintQuickFix.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintGradleDynamicVersionInspection", "getQuickFixes"));
            }
            return AndroidLintQuickFix.EMPTY_ARRAY;
        }
    }

    public static class AndroidLintGradleDeprecatedInspection
    extends AndroidLintInspectionBase {
        public AndroidLintGradleDeprecatedInspection() {
            super(AndroidBundle.message("android.lint.inspections.gradle.deprecated", new Object[0]), GradleDetector.DEPRECATED);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintGradleDeprecatedInspection", "getQuickFixes"));
            }
            String before = GradleDetector.getOldValue((Issue)GradleDetector.DEPRECATED, (String)message);
            String after = GradleDetector.getNewValue((Issue)GradleDetector.DEPRECATED, (String)message);
            if (before != null && after != null) {
                AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new ReplaceStringQuickFix(null, before, after)};
                if (androidLintQuickFixArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintGradleDeprecatedInspection", "getQuickFixes"));
                }
                return androidLintQuickFixArray;
            }
            if (AndroidLintQuickFix.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintGradleDeprecatedInspection", "getQuickFixes"));
            }
            return AndroidLintQuickFix.EMPTY_ARRAY;
        }
    }

    public static class AndroidLintGradleDependencyInspection
    extends AndroidLintInspectionBase {
        public AndroidLintGradleDependencyInspection() {
            super(AndroidBundle.message("android.lint.inspections.gradle.dependency", new Object[0]), GradleDetector.DEPENDENCY);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintGradleDependencyInspection", "getQuickFixes"));
            }
            String before = GradleDetector.getOldValue((Issue)GradleDetector.DEPENDENCY, (String)message);
            String after = GradleDetector.getNewValue((Issue)GradleDetector.DEPENDENCY, (String)message);
            if (before != null && after != null) {
                AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new ReplaceStringQuickFix("Change to " + after, before, after)};
                if (androidLintQuickFixArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintGradleDependencyInspection", "getQuickFixes"));
                }
                return androidLintQuickFixArray;
            }
            if (AndroidLintQuickFix.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintGradleDependencyInspection", "getQuickFixes"));
            }
            return AndroidLintQuickFix.EMPTY_ARRAY;
        }
    }

    public static class AndroidLintGradleCompatiblePluginInspection
    extends AndroidLintInspectionBase {
        public AndroidLintGradleCompatiblePluginInspection() {
            super(AndroidBundle.message("android.lint.inspections.gradle.plugin.compatible", new Object[0]), GradleDetector.GRADLE_PLUGIN_COMPATIBILITY);
        }
    }

    public static class AndroidLintGradleCompatibleInspection
    extends AndroidLintInspectionBase {
        public AndroidLintGradleCompatibleInspection() {
            super(AndroidBundle.message("android.lint.inspections.gradle.compatible", new Object[0]), GradleDetector.COMPATIBILITY);
        }
    }

    public static class AndroidLintExportedServiceInspection
    extends AndroidLintInspectionBase {
        public AndroidLintExportedServiceInspection() {
            super(AndroidBundle.message("android.lint.inspections.exported.service", new Object[0]), SecurityDetector.EXPORTED_SERVICE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintExportedServiceInspection", "getQuickFixes"));
            }
            AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new SetAttributeQuickFix(AndroidBundle.message("android.lint.fix.add.permission.attribute", new Object[0]), "permission", null)};
            if (androidLintQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintExportedServiceInspection", "getQuickFixes"));
            }
            return androidLintQuickFixArray;
        }
    }

    public static class AndroidLintScrollViewSizeInspection
    extends AndroidLintInspectionBase {
        public AndroidLintScrollViewSizeInspection() {
            super(AndroidBundle.message("android.lint.inspections.scroll.view.size", new Object[0]), ScrollViewChildDetector.ISSUE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintScrollViewSizeInspection", "getQuickFixes"));
            }
            AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new SetScrollViewSizeQuickFix()};
            if (androidLintQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintScrollViewSizeInspection", "getQuickFixes"));
            }
            return androidLintQuickFixArray;
        }
    }

    public static class AndroidLintPxUsageInspection
    extends AndroidLintInspectionBase {
        public AndroidLintPxUsageInspection() {
            super(AndroidBundle.message("android.lint.inspections.px.usage", new Object[0]), PxUsageDetector.PX_ISSUE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintPxUsageInspection", "getQuickFixes"));
            }
            AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new ConvertToDpQuickFix()};
            if (androidLintQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintPxUsageInspection", "getQuickFixes"));
            }
            return androidLintQuickFixArray;
        }
    }

    public static class AndroidLintProguardSplitInspection
    extends AndroidLintInspectionBase {
        public AndroidLintProguardSplitInspection() {
            super(AndroidBundle.message("android.lint.inspections.proguard.split", new Object[0]), ProguardDetector.SPLIT_CONFIG);
        }
    }

    public static class AndroidLintProguardInspection
    extends AndroidLintInspectionBase {
        public AndroidLintProguardInspection() {
            super(AndroidBundle.message("android.lint.inspections.proguard", new Object[0]), ProguardDetector.WRONG_KEEP);
        }
    }

    public static class AndroidLintObsoleteLayoutParamInspection
    extends AndroidLintInspectionBase {
        public AndroidLintObsoleteLayoutParamInspection() {
            super(AndroidBundle.message("android.lint.inspections.obsolete.layout.param", new Object[0]), ObsoleteLayoutParamsDetector.ISSUE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintObsoleteLayoutParamInspection", "getQuickFixes"));
            }
            AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new RemoveAttributeQuickFix()};
            if (androidLintQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintObsoleteLayoutParamInspection", "getQuickFixes"));
            }
            return androidLintQuickFixArray;
        }
    }

    public static class AndroidLintNotSiblingInspection
    extends AndroidLintInspectionBase {
        public AndroidLintNotSiblingInspection() {
            super(AndroidBundle.message("android.lint.inspections.not.sibling", new Object[0]), WrongIdDetector.NOT_SIBLING);
        }
    }

    public static class AndroidLintNfcTechWhitespaceInspection
    extends AndroidLintInspectionBase {
        public AndroidLintNfcTechWhitespaceInspection() {
            super(AndroidBundle.message("android.lint.inspections.nfc.tech.whitespace", new Object[0]), NfcTechListDetector.ISSUE);
        }
    }

    public static class AndroidLintNewerVersionAvailableInspection
    extends AndroidLintInspectionBase {
        public AndroidLintNewerVersionAvailableInspection() {
            super(AndroidBundle.message("android.lint.inspections.newer.version.available", new Object[0]), GradleDetector.REMOTE_VERSION);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintNewerVersionAvailableInspection", "getQuickFixes"));
            }
            String obsolete = GradleDetector.getOldValue((Issue)GradleDetector.DEPENDENCY, (String)message);
            String available = GradleDetector.getNewValue((Issue)GradleDetector.DEPENDENCY, (String)message);
            if (obsolete != null && available != null) {
                AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new ReplaceStringQuickFix("Update to " + available, obsolete, available)};
                if (androidLintQuickFixArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintNewerVersionAvailableInspection", "getQuickFixes"));
                }
                return androidLintQuickFixArray;
            }
            if (AndroidLintQuickFix.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintNewerVersionAvailableInspection", "getQuickFixes"));
            }
            return AndroidLintQuickFix.EMPTY_ARRAY;
        }
    }

    public static class AndroidLintNestedScrollingInspection
    extends AndroidLintInspectionBase {
        public AndroidLintNestedScrollingInspection() {
            super(AndroidBundle.message("android.lint.inspections.nested.scrolling", new Object[0]), NestedScrollingWidgetDetector.ISSUE);
        }
    }

    public static class AndroidLintMergeRootFrameInspection
    extends AndroidLintInspectionBase {
        public AndroidLintMergeRootFrameInspection() {
            super(AndroidBundle.message("android.lint.inspections.merge.root.frame", new Object[0]), MergeRootFrameLayoutDetector.ISSUE);
        }
    }

    public static class AndroidLintWebViewLayoutInspection
    extends AndroidLintInspectionBase {
        public AndroidLintWebViewLayoutInspection() {
            super(AndroidBundle.message("android.lint.inspections.web.view.layout", new Object[0]), WebViewDetector.ISSUE);
        }
    }

    public static class AndroidLintViewHolderInspection
    extends AndroidLintInspectionBase {
        public AndroidLintViewHolderInspection() {
            super(AndroidBundle.message("android.lint.inspections.view.holder", new Object[0]), ViewHolderDetector.ISSUE);
        }
    }

    public static class AndroidLintViewConstructorInspection
    extends AndroidLintInspectionBase {
        public AndroidLintViewConstructorInspection() {
            super(AndroidBundle.message("android.lint.inspections.view.constructor", new Object[0]), ViewConstructorDetector.ISSUE);
        }
    }

    public static class AndroidLintValidFragmentInspection
    extends AndroidLintInspectionBase {
        public AndroidLintValidFragmentInspection() {
            super(AndroidBundle.message("android.lint.inspections.valid.fragment", new Object[0]), FragmentDetector.ISSUE);
        }
    }

    public static class AndroidLintUsesMinSdkAttributesInspection
    extends AndroidLintInspectionBase {
        public AndroidLintUsesMinSdkAttributesInspection() {
            super(AndroidBundle.message("android.lint.inspections.uses.min.sdk.attributes", new Object[0]), ManifestDetector.USES_SDK);
        }
    }

    public static class AndroidLintMultipleUsesSdkInspection
    extends AndroidLintInspectionBase {
        public AndroidLintMultipleUsesSdkInspection() {
            super(AndroidBundle.message("android.lint.inspections.multiple.uses.sdk", new Object[0]), ManifestDetector.MULTIPLE_USES_SDK);
        }
    }

    public static class AndroidLintMockLocationInspection
    extends AndroidLintInspectionBase {
        public AndroidLintMockLocationInspection() {
            super(AndroidBundle.message("android.lint.inspections.mock.location", new Object[0]), ManifestDetector.MOCK_LOCATION);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintMockLocationInspection", "getQuickFixes"));
            }
            AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new MoveToDebugManifestQuickFix()};
            if (androidLintQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintMockLocationInspection", "getQuickFixes"));
            }
            return androidLintQuickFixArray;
        }
    }

    public static class AndroidLintManifestOrderInspection
    extends AndroidLintInspectionBase {
        public AndroidLintManifestOrderInspection() {
            super(AndroidBundle.message("android.lint.inspections.manifest.order", new Object[0]), ManifestDetector.ORDER);
        }
    }

    public static class AndroidLintDisableBaselineAlignmentInspection
    extends AndroidLintInspectionBase {
        public AndroidLintDisableBaselineAlignmentInspection() {
            super(AndroidBundle.message("android.lint.inspections.disable.baseline.alignment", new Object[0]), InefficientWeightDetector.BASELINE_WEIGHTS);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintDisableBaselineAlignmentInspection", "getQuickFixes"));
            }
            AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new SetAttributeQuickFix(AndroidBundle.message("android.lint.fix.set.baseline.attribute", new Object[0]), "baselineAligned", "false")};
            if (androidLintQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintDisableBaselineAlignmentInspection", "getQuickFixes"));
            }
            return androidLintQuickFixArray;
        }
    }

    public static class AndroidLintDeviceAdminInspection
    extends AndroidLintInspectionBase {
        public AndroidLintDeviceAdminInspection() {
            super(AndroidBundle.message("android.lint.inspections.device.admin", new Object[0]), ManifestDetector.DEVICE_ADMIN);
        }
    }

    public static class AndroidLintDeprecatedInspection
    extends AndroidLintInspectionBase {
        public AndroidLintDeprecatedInspection() {
            super(AndroidBundle.message("android.lint.inspections.deprecated", new Object[0]), DeprecationDetector.ISSUE);
        }
    }

    public static class AndroidLintNestedWeightsInspection
    extends AndroidLintInspectionBase {
        public AndroidLintNestedWeightsInspection() {
            super(AndroidBundle.message("android.lint.inspections.nested.weights", new Object[0]), InefficientWeightDetector.NESTED_WEIGHTS);
        }
    }

    public static class AndroidLintInefficientWeightInspection
    extends AndroidLintInspectionBase {
        public AndroidLintInefficientWeightInspection() {
            super(AndroidBundle.message("android.lint.inspections.inefficient.weight", new Object[0]), InefficientWeightDetector.INEFFICIENT_WEIGHT);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintInefficientWeightInspection", "getQuickFixes"));
            }
            AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new InefficientWeightQuickFix()};
            if (androidLintQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintInefficientWeightInspection", "getQuickFixes"));
            }
            return androidLintQuickFixArray;
        }
    }

    public static class AndroidLintHardcodedTextInspection
    extends AndroidLintInspectionBase {
        public AndroidLintHardcodedTextInspection() {
            super(AndroidBundle.message("android.lint.inspections.hardcoded.text", new Object[0]), HardcodedValuesDetector.ISSUE);
        }

        @Override
        @NotNull
        public IntentionAction[] getIntentions(@NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (startElement == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintHardcodedTextInspection", "getIntentions"));
            }
            if (endElement == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintHardcodedTextInspection", "getIntentions"));
            }
            IntentionAction[] intentionActionArray = new IntentionAction[]{new AndroidAddStringResourceQuickFix(startElement)};
            if (intentionActionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintHardcodedTextInspection", "getIntentions"));
            }
            return intentionActionArray;
        }
    }

    public static class AndroidLintGridLayoutInspection
    extends AndroidLintInspectionBase {
        public AndroidLintGridLayoutInspection() {
            super(AndroidBundle.message("android.lint.inspections.grid.layout", new Object[0]), GridLayoutDetector.ISSUE);
        }
    }

    public static class AndroidLintDuplicateIdsInspection
    extends AndroidLintInspectionBase {
        public AndroidLintDuplicateIdsInspection() {
            super(AndroidBundle.message("android.lint.inspections.duplicate.ids", new Object[0]), DuplicateIdDetector.WITHIN_LAYOUT);
        }
    }

    public static class AndroidLintUnusedQuantityInspection
    extends AndroidLintInspectionBase {
        public AndroidLintUnusedQuantityInspection() {
            super(AndroidBundle.message("android.lint.inspections.unused.quantity", new Object[0]), PluralsDetector.EXTRA);
        }
    }

    public static class AndroidLintMissingQuantityInspection
    extends AndroidLintInspectionBase {
        public AndroidLintMissingQuantityInspection() {
            super(AndroidBundle.message("android.lint.inspections.missing.quantity", new Object[0]), PluralsDetector.MISSING);
        }
    }

    public static class AndroidLintMissingPrefixInspection
    extends AndroidLintInspectionBase {
        public AndroidLintMissingPrefixInspection() {
            super(AndroidBundle.message("android.lint.inspections.missing.prefix", new Object[0]), DetectMissingPrefix.MISSING_NAMESPACE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintMissingPrefixInspection", "getQuickFixes"));
            }
            AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new AddMissingPrefixQuickFix()};
            if (androidLintQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintMissingPrefixInspection", "getQuickFixes"));
            }
            return androidLintQuickFixArray;
        }
    }

    public static class AndroidLintScrollViewCountInspection
    extends AndroidLintInspectionBase {
        public AndroidLintScrollViewCountInspection() {
            super(AndroidBundle.message("android.lint.inspections.scroll.view.count", new Object[0]), ChildCountDetector.SCROLLVIEW_ISSUE);
        }
    }

    public static class AndroidLintAdapterViewChildrenInspection
    extends AndroidLintInspectionBase {
        public AndroidLintAdapterViewChildrenInspection() {
            super(AndroidBundle.message("android.lint.inspections.adapter.view.children", new Object[0]), ChildCountDetector.ADAPTER_VIEW_ISSUE);
        }
    }

    public static class AndroidLintAccidentalOctalInspection
    extends AndroidLintInspectionBase {
        public AndroidLintAccidentalOctalInspection() {
            super(AndroidBundle.message("android.lint.inspections.accidental.octal", new Object[0]), GradleDetector.ACCIDENTAL_OCTAL);
        }
    }

    public static class AndroidLintSuspiciousImportInspection
    extends AndroidLintInspectionBase {
        public AndroidLintSuspiciousImportInspection() {
            super(AndroidBundle.message("android.lint.inspections.suspicious.import", new Object[0]), WrongImportDetector.ISSUE);
        }
    }

    public static class AndroidLintUnknownIdInLayoutInspection
    extends AndroidLintInspectionBase {
        public AndroidLintUnknownIdInLayoutInspection() {
            super(AndroidBundle.message("android.lint.inspections.unknown.id.in.layout", new Object[0]), WrongIdDetector.UNKNOWN_ID_LAYOUT);
        }
    }

    public static class AndroidLintEnforceUTF8Inspection
    extends AndroidLintInspectionBase {
        public AndroidLintEnforceUTF8Inspection() {
            super(AndroidBundle.message("android.lint.inspections.enforce.utf8", new Object[0]), Utf8Detector.ISSUE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintEnforceUTF8Inspection", "getQuickFixes"));
            }
            AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new ReplaceStringQuickFix(null, null, "utf-8")};
            if (androidLintQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintEnforceUTF8Inspection", "getQuickFixes"));
            }
            return androidLintQuickFixArray;
        }
    }

    public static class AndroidLintTextViewEditsInspection
    extends AndroidLintInspectionBase {
        public AndroidLintTextViewEditsInspection() {
            super(AndroidBundle.message("android.lint.inspections.text.view.edits", new Object[0]), TextViewDetector.ISSUE);
        }
    }

    public static class AndroidLintSdCardPathInspection
    extends AndroidLintInspectionBase {
        public AndroidLintSdCardPathInspection() {
            super(AndroidBundle.message("android.lint.inspections.sd.card.path", new Object[0]), SdCardDetector.ISSUE);
        }
    }

    public static class AndroidLintPrivateResourceInspection
    extends AndroidLintInspectionBase {
        public AndroidLintPrivateResourceInspection() {
            super(AndroidBundle.message("android.lint.inspections.private.resource", new Object[0]), PrivateResourceDetector.ISSUE);
        }
    }

    public static class AndroidLintParcelCreatorInspection
    extends AndroidLintInspectionBase {
        public AndroidLintParcelCreatorInspection() {
            super(AndroidBundle.message("android.lint.inspections.parcel.creator", new Object[0]), ParcelDetector.ISSUE);
        }
    }

    public static class AndroidLintLibraryCustomViewInspection
    extends AndroidLintInspectionBase {
        public AndroidLintLibraryCustomViewInspection() {
            super(AndroidBundle.message("android.lint.inspections.library.custom.view", new Object[0]), NamespaceDetector.CUSTOM_VIEW);
        }
    }

    public static class AndroidLintUseValueOfInspection
    extends AndroidLintInspectionBase {
        public AndroidLintUseValueOfInspection() {
            super(AndroidBundle.message("android.lint.inspections.use.value.of", new Object[0]), JavaPerformanceDetector.USE_VALUE_OF);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintUseValueOfInspection", "getQuickFixes"));
            }
            String replacedType = JavaPerformanceDetector.getReplacedType((String)message);
            if (replacedType != null) {
                AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new ReplaceStringQuickFix("Replace with valueOf()", "(new\\s+" + replacedType + ")", replacedType + ".valueOf")};
                if (androidLintQuickFixArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintUseValueOfInspection", "getQuickFixes"));
                }
                return androidLintQuickFixArray;
            }
            if (AndroidLintQuickFix.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintUseValueOfInspection", "getQuickFixes"));
            }
            return AndroidLintQuickFix.EMPTY_ARRAY;
        }
    }

    public static class AndroidLintUseSparseArraysInspection
    extends AndroidLintInspectionBase {
        public AndroidLintUseSparseArraysInspection() {
            super(AndroidBundle.message("android.lint.inspections.use.sparse.arrays", new Object[0]), JavaPerformanceDetector.USE_SPARSE_ARRAY);
        }
    }

    public static class AndroidLintDrawAllocationInspection
    extends AndroidLintInspectionBase {
        public AndroidLintDrawAllocationInspection() {
            super(AndroidBundle.message("android.lint.inspections.draw.allocation", new Object[0]), JavaPerformanceDetector.PAINT_ALLOC);
        }
    }

    public static class AndroidLintHardcodedDebugModeInspection
    extends AndroidLintInspectionBase {
        public AndroidLintHardcodedDebugModeInspection() {
            super(AndroidBundle.message("android.lint.inspections.hardcoded.debug.mode", new Object[0]), HardcodedDebugModeDetector.ISSUE);
        }
    }

    public static class AndroidLintExtraTextInspection
    extends AndroidLintInspectionBase {
        public AndroidLintExtraTextInspection() {
            super(AndroidBundle.message("android.lint.inspections.extra.text", new Object[0]), ExtraTextDetector.ISSUE);
        }
    }

    public static class AndroidLintResourceAsColorInspection
    extends AndroidLintInspectionBase {
        public AndroidLintResourceAsColorInspection() {
            super(AndroidBundle.message("android.lint.inspections.resource.as.color", new Object[0]), ColorUsageDetector.ISSUE);
        }
    }

    public static class AndroidLintButtonCaseInspection
    extends AndroidLintInspectionBase {
        public AndroidLintButtonCaseInspection() {
            super(AndroidBundle.message("android.lint.inspections.button.case", new Object[0]), ButtonDetector.CASE);
        }
    }

    public static class AndroidLintBackButtonInspection
    extends AndroidLintInspectionBase {
        public AndroidLintBackButtonInspection() {
            super(AndroidBundle.message("android.lint.inspections.back.button", new Object[0]), ButtonDetector.BACK_BUTTON);
        }
    }

    public static class AndroidLintButtonOrderInspection
    extends AndroidLintInspectionBase {
        public AndroidLintButtonOrderInspection() {
            super(AndroidBundle.message("android.lint.inspections.button.order", new Object[0]), ButtonDetector.ORDER);
        }
    }

    public static class AndroidLintContentDescriptionInspection
    extends AndroidLintInspectionBase {
        public AndroidLintContentDescriptionInspection() {
            super(AndroidBundle.message("android.lint.inspections.content.description", new Object[0]), AccessibilityDetector.ISSUE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintContentDescriptionInspection", "getQuickFixes"));
            }
            AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new SetAttributeQuickFix(AndroidBundle.message("android.lint.fix.add.content.description", new Object[0]), "contentDescription", null)};
            if (androidLintQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintContentDescriptionInspection", "getQuickFixes"));
            }
            return androidLintQuickFixArray;
        }
    }

    public static class AndroidLintUnknownIdInspection
    extends AndroidLintInspectionBase {
        public AndroidLintUnknownIdInspection() {
            super(AndroidBundle.message("android.lint.inspections.unknown.id", new Object[0]), WrongIdDetector.UNKNOWN_ID);
        }
    }

    public static class AndroidLintWrongViewCastInspection
    extends AndroidLintInspectionBase {
        public AndroidLintWrongViewCastInspection() {
            super(AndroidBundle.message("android.lint.inspections.wrong.view.cast", new Object[0]), ViewTypeDetector.ISSUE);
        }
    }

    public static class AndroidLintStringFormatInvalidInspection
    extends AndroidLintInspectionBase {
        public AndroidLintStringFormatInvalidInspection() {
            super(AndroidBundle.message("android.lint.inspections.string.format.invalid", new Object[0]), StringFormatDetector.INVALID);
        }
    }

    public static class AndroidLintStringFormatMatchesInspection
    extends AndroidLintInspectionBase {
        public AndroidLintStringFormatMatchesInspection() {
            super(AndroidBundle.message("android.lint.inspections.string.format.matches", new Object[0]), StringFormatDetector.ARG_TYPES);
        }
    }

    public static class AndroidLintStringFormatCountInspection
    extends AndroidLintInspectionBase {
        public AndroidLintStringFormatCountInspection() {
            super(AndroidBundle.message("android.lint.inspections.string.format.count", new Object[0]), StringFormatDetector.ARG_COUNT);
        }
    }

    public static class AndroidLintAssertInspection
    extends AndroidLintInspectionBase {
        public AndroidLintAssertInspection() {
            super(AndroidBundle.message("android.lint.inspections.assert", new Object[0]), AssertDetector.ISSUE);
        }
    }

    public static class AndroidLintAppCompatResourceInspection
    extends AndroidLintInspectionBase {
        public AndroidLintAppCompatResourceInspection() {
            super(AndroidBundle.message("android.lint.inspections.app.compat.resource", new Object[0]), AppCompatResourceDetector.ISSUE);
        }
    }

    public static class AndroidLintAppCompatMethodInspection
    extends AndroidLintInspectionBase {
        public AndroidLintAppCompatMethodInspection() {
            super(AndroidBundle.message("android.lint.inspections.app.compat.method", new Object[0]), AppCompatCallDetector.ISSUE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintAppCompatMethodInspection", "getQuickFixes"));
            }
            String oldCall = AppCompatCallDetector.getOldCall((String)message);
            String newCall = AppCompatCallDetector.getNewCall((String)message);
            if (oldCall != null && newCall != null) {
                AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new ReplaceStringQuickFix("Replace with " + newCall + "()", oldCall, newCall)};
                if (androidLintQuickFixArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintAppCompatMethodInspection", "getQuickFixes"));
                }
                return androidLintQuickFixArray;
            }
            if (AndroidLintQuickFix.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintAppCompatMethodInspection", "getQuickFixes"));
            }
            return AndroidLintQuickFix.EMPTY_ARRAY;
        }
    }

    public static class AndroidLintAlwaysShowActionInspection
    extends AndroidLintInspectionBase {
        public AndroidLintAlwaysShowActionInspection() {
            super(AndroidBundle.message("android.lint.inspections.always.show.action", new Object[0]), AlwaysShowActionDetector.ISSUE);
        }

        @Override
        @NotNull
        public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintAlwaysShowActionInspection", "getQuickFixes"));
            }
            AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new ReplaceStringQuickFix("Replace with ifRoom", "(always)", "ifRoom")};
            if (androidLintQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionToolProvider$AndroidLintAlwaysShowActionInspection", "getQuickFixes"));
            }
            return androidLintQuickFixArray;
        }
    }

    public static class AndroidLintUnusedIdsInspection
    extends AndroidLintInspectionBase {
        public AndroidLintUnusedIdsInspection() {
            super(AndroidBundle.message("android.lint.inspections.unused.ids", new Object[0]), UnusedResourceDetector.ISSUE_IDS);
        }
    }

    public static class AndroidLintUnusedAttributeInspection
    extends AndroidLintInspectionBase {
        public AndroidLintUnusedAttributeInspection() {
            super(AndroidBundle.message("android.lint.inspections.unused.attribute", new Object[0]), ApiDetector.UNUSED);
        }
    }

    public static class AndroidLintUnusedResourcesInspection
    extends AndroidLintInspectionBase {
        public AndroidLintUnusedResourcesInspection() {
            super(AndroidBundle.message("android.lint.inspections.unused.resources", new Object[0]), UnusedResourceDetector.ISSUE);
        }
    }

    public static class AndroidLintExtraTranslationInspection
    extends AndroidLintInspectionBase {
        public AndroidLintExtraTranslationInspection() {
            super(AndroidBundle.message("android.lint.inspections.extra.translation", new Object[0]), TranslationDetector.EXTRA);
        }
    }

    public static class AndroidLintMissingTranslationInspection
    extends AndroidLintInspectionBase {
        public AndroidLintMissingTranslationInspection() {
            super(AndroidBundle.message("android.lint.inspections.missing.translation", new Object[0]), TranslationDetector.MISSING);
        }
    }

    public static class AndroidLintMissingSuperCallInspection
    extends AndroidLintInspectionBase {
        public AndroidLintMissingSuperCallInspection() {
            super(AndroidBundle.message("android.lint.inspections.missing.super.call", new Object[0]), CallSuperDetector.ISSUE);
        }
    }

    public static class AndroidLintOverdrawInspection
    extends AndroidLintInspectionBase {
        public AndroidLintOverdrawInspection() {
            super(AndroidBundle.message("android.lint.inspections.overdraw", new Object[0]), OverdrawDetector.ISSUE);
        }
    }

    public static class AndroidLintIconNoDpiInspection
    extends AndroidLintInspectionBase {
        public AndroidLintIconNoDpiInspection() {
            super(AndroidBundle.message("android.lint.inspections.icon.no.dpi", new Object[0]), IconDetector.ICON_NODPI);
        }
    }

    public static class AndroidLintIconDuplicatesConfigInspection
    extends AndroidLintInspectionBase {
        public AndroidLintIconDuplicatesConfigInspection() {
            super(AndroidBundle.message("android.lint.inspections.icon.duplicates.config", new Object[0]), IconDetector.DUPLICATES_CONFIGURATIONS);
        }
    }

    public static class AndroidLintIconDuplicatesInspection
    extends AndroidLintInspectionBase {
        public AndroidLintIconDuplicatesInspection() {
            super(AndroidBundle.message("android.lint.inspections.icon.duplicates", new Object[0]), IconDetector.DUPLICATES_NAMES);
        }
    }

    public static class AndroidLintGifUsageInspection
    extends AndroidLintInspectionBase {
        public AndroidLintGifUsageInspection() {
            super(AndroidBundle.message("android.lint.inspections.gif.usage", new Object[0]), IconDetector.GIF_USAGE);
        }
    }

    public static class AndroidLintGetInstanceInspection
    extends AndroidLintInspectionBase {
        public AndroidLintGetInstanceInspection() {
            super(AndroidBundle.message("android.lint.inspections.get.instance", new Object[0]), CipherGetInstanceDetector.ISSUE);
        }
    }

    public static class AndroidLintIconMixedNinePatchInspection
    extends AndroidLintInspectionBase {
        public AndroidLintIconMixedNinePatchInspection() {
            super(AndroidBundle.message("android.lint.inspections.icon.mixed.nine.patch", new Object[0]), IconDetector.ICON_MIX_9PNG);
        }
    }

    public static class AndroidLintIconMissingDensityFolderInspection
    extends AndroidLintInspectionBase {
        public AndroidLintIconMissingDensityFolderInspection() {
            super(AndroidBundle.message("android.lint.inspections.icon.missing.density.folder", new Object[0]), IconDetector.ICON_MISSING_FOLDER);
        }
    }

    public static class AndroidLintIconDensitiesInspection
    extends AndroidLintInspectionBase {
        public AndroidLintIconDensitiesInspection() {
            super(AndroidBundle.message("android.lint.inspections.icon.densities", new Object[0]), IconDetector.ICON_DENSITIES);
        }
    }

    public static class AndroidLintIconLocationInspection
    extends AndroidLintInspectionBase {
        public AndroidLintIconLocationInspection() {
            super(AndroidBundle.message("android.lint.inspections.icon.location", new Object[0]), IconDetector.ICON_LOCATION);
        }
    }

    public static class AndroidLintIconDipSizeInspection
    extends AndroidLintInspectionBase {
        public AndroidLintIconDipSizeInspection() {
            super(AndroidBundle.message("android.lint.inspections.icon.dip.size", new Object[0]), IconDetector.ICON_DIP_SIZE);
        }
    }

    public static class AndroidLintIconExpectedSizeInspection
    extends AndroidLintInspectionBase {
        public AndroidLintIconExpectedSizeInspection() {
            super(AndroidBundle.message("android.lint.inspections.icon.expected.size", new Object[0]), IconDetector.ICON_EXPECTED_SIZE);
        }
    }

    public static class AndroidLintDuplicateIncludedIdsInspection
    extends AndroidLintInspectionBase {
        public AndroidLintDuplicateIncludedIdsInspection() {
            super(AndroidBundle.message("android.lint.inspections.duplicate.included.ids", new Object[0]), DuplicateIdDetector.CROSS_LAYOUT);
        }
    }

    public static class AndroidLintInconsistentLayoutInspection
    extends AndroidLintInspectionBase {
        public AndroidLintInconsistentLayoutInspection() {
            super(AndroidBundle.message("android.lint.inspections.inconsistent.layout", new Object[0]), LayoutConsistencyDetector.INCONSISTENT_IDS);
        }
    }

    public static class AndroidLintInconsistentArraysInspection
    extends AndroidLintInspectionBase {
        public AndroidLintInconsistentArraysInspection() {
            super(AndroidBundle.message("android.lint.inspections.inconsistent.arrays", new Object[0]), ArraySizeDetector.INCONSISTENT);
        }
    }

    public static class AndroidLintAaptCrashInspection
    extends AndroidLintInspectionBase {
        public AndroidLintAaptCrashInspection() {
            super(AndroidBundle.message("android.lint.inspections.aapt.crash", new Object[0]), ResourceCycleDetector.CRASH);
        }
    }
}

