/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.android.annotations.concurrency.GuardedBy;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.utils.XmlUtils;
import com.intellij.analysis.AnalysisScope;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.BatchSuppressableTool;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.SuppressManager;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.XmlSuppressionProvider;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.inspections.lint.AndroidLintGlobalInspectionContext;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.inspections.lint.ProblemData;
import org.jetbrains.android.inspections.lint.SuppressLintIntentionAction;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidLintInspectionBase
extends GlobalInspectionTool
implements BatchSuppressableTool {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.inspections.lint.AndroidLintInspectionBase");
    private static final Object ISSUE_MAP_LOCK = new Object();
    @GuardedBy(value="ISSUE_MAP_LOCK")
    private static volatile Map<Issue, String> ourIssue2InspectionShortName;
    protected final Issue myIssue;
    private final String[] myGroupPath;
    private final String myDisplayName;

    protected AndroidLintInspectionBase(@NotNull String displayName, @NotNull Issue issue) {
        if (displayName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase", "<init>"));
        }
        if (issue == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase", "<init>"));
        }
        this.myIssue = issue;
        Category category = issue.getCategory();
        String[] categoryNames = category != null ? AndroidLintInspectionBase.computeAllNames(category) : ArrayUtil.EMPTY_STRING_ARRAY;
        this.myGroupPath = ArrayUtil.mergeArrays((String[])new String[]{AndroidBundle.message("android.inspections.group.name", new Object[0]), AndroidBundle.message("android.lint.inspections.subgroup.name", new Object[0])}, (String[])categoryNames);
        this.myDisplayName = displayName;
    }

    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase", "getQuickFixes"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase", "getQuickFixes"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase", "getQuickFixes"));
        }
        AndroidLintQuickFix[] androidLintQuickFixArray = this.getQuickFixes(message);
        if (androidLintQuickFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase", "getQuickFixes"));
        }
        return androidLintQuickFixArray;
    }

    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase", "getQuickFixes"));
        }
        if (AndroidLintQuickFix.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase", "getQuickFixes"));
        }
        return AndroidLintQuickFix.EMPTY_ARRAY;
    }

    @NotNull
    public IntentionAction[] getIntentions(@NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase", "getIntentions"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase", "getIntentions"));
        }
        if (IntentionAction.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase", "getIntentions"));
        }
        return IntentionAction.EMPTY_ARRAY;
    }

    public boolean isGraphNeeded() {
        return false;
    }

    @NotNull
    private LocalQuickFix[] getLocalQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase", "getLocalQuickFixes"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase", "getLocalQuickFixes"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase", "getLocalQuickFixes"));
        }
        AndroidLintQuickFix[] fixes = this.getQuickFixes(startElement, endElement, message);
        LocalQuickFix[] result = new LocalQuickFix[fixes.length];
        for (int i = 0; i < fixes.length; ++i) {
            if (!fixes[i].isApplicable(startElement, endElement, AndroidQuickfixContexts.BatchContext.TYPE)) continue;
            result[i] = new MyLocalQuickFix(fixes[i]);
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase", "getLocalQuickFixes"));
        }
        return result;
    }

    public void runInspection(@NotNull AnalysisScope scope, final @NotNull InspectionManager manager, final @NotNull GlobalInspectionContext globalContext, final @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase", "runInspection"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase", "runInspection"));
        }
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase", "runInspection"));
        }
        if (problemDescriptionsProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase", "runInspection"));
        }
        AndroidLintGlobalInspectionContext androidLintContext = (AndroidLintGlobalInspectionContext)globalContext.getExtension(AndroidLintGlobalInspectionContext.ID);
        if (androidLintContext == null) {
            return;
        }
        Map<Issue, Map<File, List<ProblemData>>> problemMap = androidLintContext.getResults();
        if (problemMap == null) {
            return;
        }
        Map<File, List<ProblemData>> file2ProblemList = problemMap.get(this.myIssue);
        if (file2ProblemList == null) {
            return;
        }
        for (final Map.Entry<File, List<ProblemData>> entry : file2ProblemList.entrySet()) {
            File file = entry.getKey();
            final VirtualFile vFile = LocalFileSystem.getInstance().findFileByIoFile(file);
            if (vFile == null) continue;
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    ProblemDescriptor[] descriptors;
                    PsiManager psiManager = PsiManager.getInstance((Project)globalContext.getProject());
                    PsiFile psiFile = psiManager.findFile(vFile);
                    if (psiFile != null && (descriptors = AndroidLintInspectionBase.this.computeProblemDescriptors(psiFile, manager, (List)entry.getValue())).length > 0) {
                        problemDescriptionsProcessor.addProblemElement((RefEntity)globalContext.getRefManager().getReference((PsiElement)psiFile), (CommonProblemDescriptor[])descriptors);
                    }
                }
            });
        }
    }

    @NotNull
    private ProblemDescriptor[] computeProblemDescriptors(@NotNull PsiFile psiFile, @NotNull InspectionManager manager, @NotNull List<ProblemData> problems) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase", "computeProblemDescriptors"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase", "computeProblemDescriptors"));
        }
        if (problems == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase", "computeProblemDescriptors"));
        }
        ArrayList<ProblemDescriptor> result = new ArrayList<ProblemDescriptor>();
        for (ProblemData problemData : problems) {
            String s = problemData.getMessage();
            String message = XmlUtils.toXmlTextValue((String)s);
            TextRange range = problemData.getTextRange();
            if (range.getStartOffset() == range.getEndOffset()) {
                Module module;
                PsiFile f = psiFile;
                if (f instanceof PsiBinaryFile && (module = ModuleUtil.findModuleForPsiElement((PsiElement)f)) != null) {
                    VirtualFile manifestFile;
                    AndroidFacet facet = AndroidFacet.getInstance(module);
                    VirtualFile virtualFile = manifestFile = facet != null ? AndroidRootUtil.getPrimaryManifestFile(facet) : null;
                    if (manifestFile != null) {
                        f = f.getManager().findFile(manifestFile);
                    }
                }
                if (f == null || this.isSuppressedFor((PsiElement)f)) continue;
                result.add(manager.createProblemDescriptor((PsiElement)f, message, false, this.getLocalQuickFixes((PsiElement)f, (PsiElement)f, s), ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
                continue;
            }
            PsiElement startElement = psiFile.findElementAt(range.getStartOffset());
            PsiElement endElement = psiFile.findElementAt(range.getEndOffset() - 1);
            if (startElement == null || endElement == null || this.isSuppressedFor(startElement)) continue;
            result.add(manager.createProblemDescriptor(startElement, endElement, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, this.getLocalQuickFixes(startElement, endElement, s)));
        }
        ProblemDescriptor[] problemDescriptorArray = result.toArray(new ProblemDescriptor[result.size()]);
        if (problemDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase", "computeProblemDescriptors"));
        }
        return problemDescriptorArray;
    }

    @NotNull
    public SuppressQuickFix[] getBatchSuppressActions(@Nullable PsiElement element) {
        SuppressLintQuickFix suppressLintQuickFix = new SuppressLintQuickFix(this.myIssue);
        SuppressQuickFix[] suppressQuickFixArray = new SuppressQuickFix[]{suppressLintQuickFix};
        if (suppressQuickFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase", "getBatchSuppressActions"));
        }
        return suppressQuickFixArray;
    }

    public boolean isSuppressedFor(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase", "isSuppressedFor"));
        }
        if (element.getLanguage() == JavaLanguage.INSTANCE) {
            return SuppressManager.getInstance().isSuppressedFor(element, this.getShortName());
        }
        if (element.getLanguage() == XMLLanguage.INSTANCE) {
            return XmlSuppressionProvider.isSuppressed((PsiElement)element, (String)this.getShortName());
        }
        return false;
    }

    public static void invalidateInspectionShortName2IssueMap() {
        ourIssue2InspectionShortName = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getInspectionShortNameByIssue(@NotNull Project project, @NotNull Issue issue) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase", "getInspectionShortNameByIssue"));
        }
        if (issue == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase", "getInspectionShortNameByIssue"));
        }
        Object object = ISSUE_MAP_LOCK;
        synchronized (object) {
            if (ourIssue2InspectionShortName == null) {
                ourIssue2InspectionShortName = new HashMap();
                InspectionProfile profile = InspectionProjectProfileManager.getInstance((Project)project).getInspectionProfile();
                for (InspectionToolWrapper e : profile.getInspectionTools(null)) {
                    InspectionProfileEntry entry;
                    String shortName = e.getShortName();
                    if (!shortName.startsWith("AndroidLint") || !((entry = e.getTool()) instanceof AndroidLintInspectionBase)) continue;
                    Issue s = ((AndroidLintInspectionBase)entry).getIssue();
                    ourIssue2InspectionShortName.put(s, shortName);
                }
            }
            return ourIssue2InspectionShortName.get(issue);
        }
    }

    @NotNull
    private static String[] computeAllNames(@NotNull Category category) {
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase", "computeAllNames"));
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Category c = category; c != null; c = c.getParent()) {
            String name = c.getName();
            if (name == null) {
                if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase", "computeAllNames"));
                }
                return ArrayUtil.EMPTY_STRING_ARRAY;
            }
            result.add(name);
        }
        String[] stringArray = (String[])ArrayUtil.reverseArray((Object[])ArrayUtil.toStringArray(result));
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase", "computeAllNames"));
        }
        return stringArray;
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = AndroidBundle.message("android.lint.inspections.group.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String[] getGroupPath() {
        if (this.myGroupPath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase", "getGroupPath"));
        }
        return this.myGroupPath;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = this.myDisplayName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase", "getDisplayName"));
        }
        return string;
    }

    public String getStaticDescription() {
        StringBuilder sb = new StringBuilder(1000);
        sb.append("<html><body>");
        sb.append(this.myIssue.getDescription(Issue.OutputFormat.HTML));
        sb.append("<br><br>");
        sb.append(this.myIssue.getExplanation(Issue.OutputFormat.HTML));
        List urls = this.myIssue.getMoreInfo();
        if (!urls.isEmpty()) {
            boolean separated = false;
            for (String url : urls) {
                if (this.myIssue.getExplanation(Issue.OutputFormat.RAW).contains(url)) continue;
                if (!separated) {
                    sb.append("<br><br>");
                    separated = true;
                } else {
                    sb.append("<br>");
                }
                sb.append("<a href=\"");
                sb.append(url);
                sb.append("\">");
                sb.append(url);
                sb.append("</a>");
            }
        }
        sb.append("</body></html>");
        return sb.toString();
    }

    public boolean isEnabledByDefault() {
        return this.myIssue.isEnabledByDefault();
    }

    @NotNull
    public String getShortName() {
        String string = StringUtil.trimEnd((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"Inspection");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase", "getShortName"));
        }
        return string;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        Severity defaultSeverity = this.myIssue.getDefaultSeverity();
        if (defaultSeverity == null) {
            HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
            if (highlightDisplayLevel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase", "getDefaultLevel"));
            }
            return highlightDisplayLevel;
        }
        HighlightDisplayLevel displayLevel = AndroidLintInspectionBase.toHighlightDisplayLevel(defaultSeverity);
        HighlightDisplayLevel highlightDisplayLevel = displayLevel != null ? displayLevel : HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    @Nullable
    static HighlightDisplayLevel toHighlightDisplayLevel(@NotNull Severity severity) {
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase", "toHighlightDisplayLevel"));
        }
        switch (severity) {
            case ERROR: {
                return HighlightDisplayLevel.ERROR;
            }
            case FATAL: {
                return HighlightDisplayLevel.ERROR;
            }
            case WARNING: {
                return HighlightDisplayLevel.WARNING;
            }
            case INFORMATIONAL: {
                return HighlightDisplayLevel.WEAK_WARNING;
            }
            case IGNORE: {
                return null;
            }
        }
        LOG.error("Unknown severity " + severity);
        return null;
    }

    private static boolean isSingleFileScope(EnumSet<Scope> scopes) {
        if (scopes.size() != 1) {
            return false;
        }
        Scope scope = (Scope)scopes.iterator().next();
        return scope == Scope.JAVA_FILE || scope == Scope.RESOURCE_FILE || scope == Scope.MANIFEST || scope == Scope.PROGUARD_FILE || scope == Scope.OTHER;
    }

    public boolean worksInBatchModeOnly() {
        Implementation implementation = this.myIssue.getImplementation();
        if (AndroidLintInspectionBase.isSingleFileScope(implementation.getScope())) {
            return false;
        }
        for (EnumSet scopes : implementation.getAnalysisScopes()) {
            if (!AndroidLintInspectionBase.isSingleFileScope(scopes)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public Issue getIssue() {
        Issue issue = this.myIssue;
        if (issue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase", "getIssue"));
        }
        return issue;
    }

    static class MyLocalQuickFix
    implements LocalQuickFix {
        private final AndroidLintQuickFix myLintQuickFix;

        MyLocalQuickFix(@NotNull AndroidLintQuickFix lintQuickFix) {
            if (lintQuickFix == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase$MyLocalQuickFix", "<init>"));
            }
            this.myLintQuickFix = lintQuickFix;
        }

        @NotNull
        public String getName() {
            String string = this.myLintQuickFix.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase$MyLocalQuickFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = AndroidBundle.message("android.lint.quickfixes.family", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase$MyLocalQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase$MyLocalQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase$MyLocalQuickFix", "applyFix"));
            }
            this.myLintQuickFix.apply(descriptor.getStartElement(), descriptor.getEndElement(), AndroidQuickfixContexts.BatchContext.getInstance());
        }
    }

    private static class SuppressLintQuickFix
    implements SuppressQuickFix {
        private Issue myIssue;

        private SuppressLintQuickFix(Issue issue) {
            this.myIssue = issue;
        }

        public boolean isAvailable(@NotNull Project project, @NotNull PsiElement context) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase$SuppressLintQuickFix", "isAvailable"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase$SuppressLintQuickFix", "isAvailable"));
            }
            return true;
        }

        @NotNull
        public String getName() {
            if ("Suppress with @SuppressLint (Java) or tools:ignore (XML)" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase$SuppressLintQuickFix", "getName"));
            }
            return "Suppress with @SuppressLint (Java) or tools:ignore (XML)";
        }

        @NotNull
        public String getFamilyName() {
            if ("Suppress" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase$SuppressLintQuickFix", "getFamilyName"));
            }
            return "Suppress";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase$SuppressLintQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/inspections/lint/AndroidLintInspectionBase$SuppressLintQuickFix", "applyFix"));
            }
            PsiElement myElement = descriptor.getPsiElement();
            PsiFile file = (PsiFile)PsiTreeUtil.getParentOfType((PsiElement)myElement, PsiFile.class, (boolean)false);
            if (file != null) {
                new SuppressLintIntentionAction(this.myIssue.getId(), myElement).invoke(project, null, file);
            }
        }
    }
}

