/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.android.resources.ResourceType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.android.intentions.AndroidAddStringResourceAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidAddStringResourceQuickFix
extends AndroidAddStringResourceAction {
    private final PsiElement myStartElement;

    public AndroidAddStringResourceQuickFix(@NotNull PsiElement startElement) {
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidAddStringResourceQuickFix", "<init>"));
        }
        this.myStartElement = startElement;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidAddStringResourceQuickFix", "isAvailable"));
        }
        if (!this.myStartElement.isValid()) {
            return false;
        }
        XmlAttributeValue value = AndroidAddStringResourceQuickFix.getAttributeValue(this.myStartElement);
        return value != null && AndroidAddStringResourceQuickFix.getStringLiteralValue(project, (PsiElement)value, file, ResourceType.STRING) != null;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidAddStringResourceQuickFix", "invoke"));
        }
        this.invokeIntention(project, editor, file, null);
    }

    public void invokeIntention(Project project, Editor editor, PsiFile file, String resName) {
        XmlAttributeValue attributeValue = AndroidAddStringResourceQuickFix.getAttributeValue(this.myStartElement);
        if (attributeValue != null) {
            AndroidAddStringResourceQuickFix.doInvoke(project, editor, file, resName, (PsiElement)attributeValue, ResourceType.STRING);
        }
    }

    @Nullable
    private static XmlAttributeValue getAttributeValue(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/lint/AndroidAddStringResourceQuickFix", "getAttributeValue"));
        }
        XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttribute.class);
        return attribute != null ? attribute.getValueElement() : null;
    }
}

