/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.android.resources.ResourceType;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.HashSet;
import com.intellij.util.xml.DomFileDescription;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.dom.AndroidAnyAttributeDescriptor;
import org.jetbrains.android.dom.AndroidResourceDomFileDescription;
import org.jetbrains.android.dom.AndroidXmlTagDescriptor;
import org.jetbrains.android.dom.manifest.ManifestDomFileDescription;
import org.jetbrains.android.dom.xml.AndroidXmlResourcesUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AndroidUnknownAttributeInspection
extends LocalInspectionTool {
    private static volatile Set<String> ourSupportedResourceTypes;

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = AndroidBundle.message("android.inspections.group.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/AndroidUnknownAttributeInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = AndroidBundle.message("android.inspections.unknown.attribute.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/AndroidUnknownAttributeInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("AndroidUnknownAttribute" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/AndroidUnknownAttributeInspection", "getShortName"));
        }
        return "AndroidUnknownAttribute";
    }

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/AndroidUnknownAttributeInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/inspections/AndroidUnknownAttributeInspection", "checkFile"));
        }
        if (!(file instanceof XmlFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)file);
        if (facet == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        if (AndroidUnknownAttributeInspection.isMyFile(facet, (XmlFile)file)) {
            MyVisitor visitor = new MyVisitor(manager, isOnTheFly);
            file.accept((PsiElementVisitor)visitor);
            return visitor.myResult.toArray(new ProblemDescriptor[visitor.myResult.size()]);
        }
        return ProblemDescriptor.EMPTY_ARRAY;
    }

    static boolean isMyFile(@NotNull AndroidFacet facet, XmlFile file) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/inspections/AndroidUnknownAttributeInspection", "isMyFile"));
        }
        String resourceType = facet.getLocalResourceManager().getFileResourceType((PsiFile)file);
        if (resourceType != null) {
            if (ourSupportedResourceTypes == null) {
                ourSupportedResourceTypes = new HashSet();
                for (DomFileDescription description : (DomFileDescription[])DomFileDescription.EP_NAME.getExtensions()) {
                    if (!(description instanceof AndroidResourceDomFileDescription)) continue;
                    String[] resourceTypes = ((AndroidResourceDomFileDescription)description).getResourceTypes();
                    Collections.addAll(ourSupportedResourceTypes, resourceTypes);
                }
            }
            if (!ourSupportedResourceTypes.contains(resourceType)) {
                return false;
            }
            if (ResourceType.XML.getName().equals(resourceType)) {
                XmlTag rootTag = file.getRootTag();
                return rootTag != null && AndroidXmlResourcesUtil.isSupportedRootTag(facet, rootTag.getName());
            }
            return true;
        }
        return ManifestDomFileDescription.isManifestFile(file, facet);
    }

    private static class MyVisitor
    extends XmlRecursiveElementVisitor {
        private final InspectionManager myInspectionManager;
        private final boolean myOnTheFly;
        final List<ProblemDescriptor> myResult = new ArrayList<ProblemDescriptor>();

        private MyVisitor(InspectionManager inspectionManager, boolean onTheFly) {
            this.myInspectionManager = inspectionManager;
            this.myOnTheFly = onTheFly;
        }

        public void visitXmlAttribute(XmlAttribute attribute) {
            XmlTag tag;
            String namespace;
            if (!"xmlns".equals(attribute.getNamespacePrefix()) && ("http://schemas.android.com/apk/res/android".equals(namespace = attribute.getNamespace()) || namespace.isEmpty()) && (tag = attribute.getParent()) != null && tag.getDescriptor() instanceof AndroidXmlTagDescriptor && attribute.getDescriptor() instanceof AndroidAnyAttributeDescriptor) {
                PsiElement nameElement;
                ASTNode node = attribute.getNode();
                assert (node != null);
                ASTNode nameNode = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(node);
                PsiElement psiElement = nameElement = nameNode != null ? nameNode.getPsi() : null;
                if (nameElement != null) {
                    this.myResult.add(this.myInspectionManager.createProblemDescriptor(nameElement, AndroidBundle.message("android.inspections.unknown.attribute.message", attribute.getName()), this.myOnTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
                }
            }
        }
    }
}

