/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.xml;

import com.android.resources.ResourceType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.android.dom.AndroidResourceDomFileDescription;
import org.jetbrains.android.dom.xml.XmlResourceElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlResourceDomFileDescription
extends AndroidResourceDomFileDescription<XmlResourceElement> {
    public XmlResourceDomFileDescription() {
        super(XmlResourceElement.class, "PreferenceScreen", ResourceType.XML.getName());
    }

    public boolean acceptsOtherRootTagNames() {
        return true;
    }

    public static boolean isXmlResourceFile(final @NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/dom/xml/XmlResourceDomFileDescription", "isXmlResourceFile"));
        }
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return new XmlResourceDomFileDescription().isMyFile(file, null);
            }
        });
    }

    @Override
    public boolean isMyFile(@NotNull XmlFile file, @Nullable Module module) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/dom/xml/XmlResourceDomFileDescription", "isMyFile"));
        }
        if (!super.isMyFile(file, module)) {
            return false;
        }
        XmlTag rootTag = file.getRootTag();
        if (rootTag == null || rootTag.getNamespace().length() > 0) {
            return false;
        }
        for (XmlAttribute attribute : rootTag.getAttributes()) {
            if (!attribute.getName().equals("xmlns")) continue;
            return false;
        }
        return true;
    }
}

