/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.transition;

import com.android.resources.ResourceType;
import com.intellij.psi.xml.XmlFile;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.android.dom.AndroidResourceDomFileDescription;
import org.jetbrains.annotations.NotNull;

public class TransitionDomUtil {
    public static final String TRANSITION_MANAGER_TAG = "transitionManager";
    public static final String TRANSITION_TAG = "transition";
    public static final String TRANSITION_SET_TAG = "transitionSet";
    public static final String FADE_TAG = "fade";
    public static final String TARGETS_TAG = "targets";
    public static final String TARGET_TAG = "target";
    public static final String CHANGE_BOUNDS_TAG = "changeBounds";
    public static final String AUTO_TRANSITION_TAG = "autoTransition";
    public static final String DEFAULT_ROOT = "transitionManager";
    private static final String[] ROOTS = new String[]{"transitionManager", "transitionSet", "fade", "changeBounds", "autoTransition", "targets"};

    private TransitionDomUtil() {
    }

    public static List<String> getPossibleRoots() {
        return Arrays.asList(ROOTS);
    }

    public static boolean isTransitionResourceFile(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/dom/transition/TransitionDomUtil", "isTransitionResourceFile"));
        }
        return AndroidResourceDomFileDescription.doIsMyFile(file, new String[]{ResourceType.TRANSITION.getName()});
    }
}

