/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.tools.idea.gradle.IdeaAndroidProject;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PackageReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiPackageReference;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import org.jetbrains.android.AndroidApplicationPackageRenameProcessor;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidPackageConverter
extends Converter<String>
implements CustomReferenceConverter<String> {
    public String fromString(@Nullable @NonNls String s, ConvertContext context) {
        return s;
    }

    public String toString(@Nullable String s, ConvertContext context) {
        return s;
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<String> value, PsiElement element, ConvertContext context) {
        String s = value.getStringValue();
        PsiReference[] psiReferenceArray = s != null ? new MyPackageReferenceSet(s, element).getPsiReferences() : PsiReference.EMPTY_ARRAY;
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/converters/AndroidPackageConverter", "createReferences"));
        }
        return psiReferenceArray;
    }

    private static class MyPsiPackageReference
    extends PsiPackageReference {
        private final MyPackageReferenceSet myReferenceSet;
        private final TextRange myTextRange;

        public MyPsiPackageReference(MyPackageReferenceSet referenceSet, TextRange textRange, int index) {
            super((PackageReferenceSet)referenceSet, textRange, index);
            this.myReferenceSet = referenceSet;
            this.myTextRange = textRange;
        }

        @NotNull
        public ResolveResult[] multiResolve(boolean incompleteCode) {
            ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults((PsiElement[])new PsiElement[]{this.myElement});
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/converters/AndroidPackageConverter$MyPsiPackageReference", "multiResolve"));
            }
            return resolveResultArray;
        }

        public boolean isReferenceTo(PsiElement element) {
            ResolveResult[] results;
            for (ResolveResult result : results = this.doMultiResolve()) {
                if (!this.getElement().getManager().areElementsEquivalent(result.getElement(), element)) continue;
                return true;
            }
            return false;
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            return this.myElement;
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/dom/converters/AndroidPackageConverter$MyPsiPackageReference", "bindToElement"));
            }
            if (!(element instanceof PsiPackage) || !(this.myElement instanceof XmlAttributeValue)) {
                throw new IncorrectOperationException("Cannot bind to " + element);
            }
            String newPackageName = ((PsiPackage)element).getQualifiedName();
            String basePackage = ((XmlAttributeValue)this.myElement).getValue();
            String oldPackageName = this.myElement.getText().substring(this.myReferenceSet.myStartInElement, this.myTextRange.getEndOffset());
            PsiFile file = this.myElement.getContainingFile();
            if (basePackage.length() > 0 && file instanceof XmlFile) {
                AndroidApplicationPackageRenameProcessor.processAllAttributesToUpdate((XmlFile)file, basePackage, oldPackageName, newPackageName, new Processor<Pair<GenericAttributeValue, String>>(){

                    public boolean process(Pair<GenericAttributeValue, String> pair) {
                        ((GenericAttributeValue)pair.getFirst()).setStringValue((String)pair.getSecond());
                        return true;
                    }
                });
            }
            return this.myElement;
        }
    }

    private static class MyPackageReferenceSet
    extends PackageReferenceSet {
        final int myStartInElement;

        public MyPackageReferenceSet(String s, PsiElement element) {
            this(s, element, ElementManipulators.getOffsetInElement((PsiElement)element));
        }

        public MyPackageReferenceSet(String str, PsiElement element, int startInElement) {
            super(str, element, startInElement);
            this.myStartInElement = startInElement;
        }

        @NotNull
        protected PsiPackageReference createReference(TextRange range, int index) {
            IdeaAndroidProject project;
            AndroidFacet facet = AndroidFacet.getInstance(this.getElement());
            if (facet != null && (project = facet.getIdeaAndroidProject()) != null && project.overridesManifestPackage()) {
                PsiPackageReference psiPackageReference = new PsiPackageReference((PackageReferenceSet)this, range, index);
                if (psiPackageReference == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/converters/AndroidPackageConverter$MyPackageReferenceSet", "createReference"));
                }
                return psiPackageReference;
            }
            MyPsiPackageReference myPsiPackageReference = new MyPsiPackageReference(this, range, index);
            if (myPsiPackageReference == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/converters/AndroidPackageConverter$MyPackageReferenceSet", "createReference"));
            }
            return myPsiPackageReference;
        }
    }
}

