/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.xml.XmlElementDescriptorProvider;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.SoftHashMap;
import com.intellij.util.xml.DefinesXml;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.impl.dom.DomElementXmlDescriptor;
import icons.AndroidIcons;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.android.dom.AndroidDomElement;
import org.jetbrains.android.dom.AndroidXmlTagDescriptor;
import org.jetbrains.android.dom.layout.LayoutViewElement;
import org.jetbrains.android.dom.xml.XmlResourceElement;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.SimpleClassMapConstructor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidDomElementDescriptorProvider
implements XmlElementDescriptorProvider {
    private static final Map<String, Ref<Icon>> ourViewTagName2Icon = new SoftHashMap();

    @Nullable
    private static XmlElementDescriptor getDescriptor(DomElement domElement, XmlTag tag, @Nullable String baseClassName) {
        XmlElementDescriptor domDescriptor;
        XmlElementDescriptor parentDescriptor;
        AndroidFacet facet = AndroidFacet.getInstance(domElement);
        if (facet == null) {
            return null;
        }
        String name = domElement.getXmlTag().getName();
        PsiClass aClass = baseClassName != null ? SimpleClassMapConstructor.findClassByTagName(facet, name, baseClassName) : null;
        Icon icon = AndroidDomElementDescriptorProvider.getIconForTag(name, domElement);
        DefinesXml definesXml = (DefinesXml)domElement.getAnnotation(DefinesXml.class);
        if (definesXml != null) {
            return new AndroidXmlTagDescriptor(aClass, (XmlElementDescriptor)new DomElementXmlDescriptor(domElement), baseClassName, icon);
        }
        PsiElement parent = tag.getParent();
        if (parent instanceof XmlTag && (parentDescriptor = ((XmlTag)parent).getDescriptor()) != null && parentDescriptor instanceof AndroidXmlTagDescriptor && (domDescriptor = parentDescriptor.getElementDescriptor(tag, (XmlTag)parent)) != null) {
            return new AndroidXmlTagDescriptor(aClass, domDescriptor, baseClassName, icon);
        }
        return null;
    }

    public XmlElementDescriptor getDescriptor(XmlTag tag) {
        Pair<AndroidDomElement, String> pair = AndroidDomElementDescriptorProvider.getDomElementAndBaseClassQName(tag);
        if (pair == null) {
            return null;
        }
        return AndroidDomElementDescriptorProvider.getDescriptor((DomElement)pair.getFirst(), tag, (String)pair.getSecond());
    }

    @Nullable
    public static Pair<AndroidDomElement, String> getDomElementAndBaseClassQName(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/dom/AndroidDomElementDescriptorProvider", "getDomElementAndBaseClassQName"));
        }
        Project project = tag.getProject();
        if (project.isDefault()) {
            return null;
        }
        DomElement domElement = DomManager.getDomManager((Project)project).getDomElement(tag);
        if (!(domElement instanceof AndroidDomElement)) {
            return null;
        }
        String className = null;
        if (domElement instanceof LayoutViewElement) {
            className = "android.view.View";
        } else if (domElement instanceof XmlResourceElement) {
            className = "android.preference.Preference";
        }
        return Pair.create((Object)((AndroidDomElement)domElement), (Object)className);
    }

    @Nullable
    public static Icon getIconForTag(@Nullable String tagName, @Nullable DomElement context) {
        if (tagName == null || !(context instanceof LayoutViewElement)) {
            return null;
        }
        return AndroidDomElementDescriptorProvider.getIconForViewTag(tagName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Icon getIconForViewTag(@NotNull String tagName) {
        if (tagName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/dom/AndroidDomElementDescriptorProvider", "getIconForViewTag"));
        }
        Map<String, Ref<Icon>> map = ourViewTagName2Icon;
        synchronized (map) {
            Ref iconRef;
            if (ourViewTagName2Icon.isEmpty()) {
                Map<String, Icon> map2 = AndroidDomElementDescriptorProvider.getInitialViewTagName2IconMap();
                for (Map.Entry<String, Icon> entry : map2.entrySet()) {
                    ourViewTagName2Icon.put(entry.getKey(), (Ref<Icon>)Ref.create((Object)entry.getValue()));
                }
            }
            if ((iconRef = ourViewTagName2Icon.get(tagName)) == null) {
                iconRef = Ref.create((Object)IconLoader.findIcon((String)("AndroidIcons.Views." + tagName)));
                ourViewTagName2Icon.put(tagName, (Ref<Icon>)iconRef);
            }
            return (Icon)iconRef.get();
        }
    }

    @NotNull
    private static Map<String, Icon> getInitialViewTagName2IconMap() {
        HashMap map = new HashMap();
        map.put((Object)"fragment", (Object)AndroidIcons.Views.Fragment);
        map.put((Object)"include", (Object)AndroidIcons.Views.Include);
        map.put((Object)"view", (Object)AndroidIcons.Views.View);
        map.put((Object)"requestFocus", (Object)AndroidIcons.Views.RequestFocus);
        HashMap hashMap = map;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/AndroidDomElementDescriptorProvider", "getInitialViewTagName2IconMap"));
        }
        return hashMap;
    }
}

