/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler;

import com.android.sdklib.IAndroidTarget;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.android.compiler.AndroidAptCompiler;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourcesValidityState
implements ValidityState {
    private final Map<String, Long> myResourceTimestamps = new HashMap<String, Long>();
    private final String myAndroidTargetName;

    public ResourcesValidityState(Module module) {
        VirtualFile assetsDir;
        VirtualFile resourcesDir;
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            this.myAndroidTargetName = "";
            return;
        }
        AndroidFacetConfiguration configuration = (AndroidFacetConfiguration)facet.getConfiguration();
        AndroidPlatform platform = configuration.getAndroidPlatform();
        IAndroidTarget target = platform != null ? platform.getTarget() : null;
        this.myAndroidTargetName = target != null ? target.getFullName() : "";
        VirtualFile manifestFile = AndroidRootUtil.getManifestFile(facet);
        if (manifestFile != null) {
            this.myResourceTimestamps.put(manifestFile.getPath(), manifestFile.getTimeStamp());
        }
        if ((resourcesDir = ResourcesValidityState.getResourcesDir(facet)) != null) {
            this.collectFiles(resourcesDir);
        }
        if ((assetsDir = AndroidRootUtil.getAssetsDir(facet)) != null) {
            this.collectFiles(assetsDir);
        }
        for (AndroidFacet depFacet : AndroidUtils.getAllAndroidDependencies(module, true)) {
            VirtualFile depAssetDir;
            VirtualFile depResDir;
            VirtualFile depManifest = AndroidRootUtil.getManifestFile(depFacet);
            if (depManifest != null) {
                this.myResourceTimestamps.put(depManifest.getPath(), depManifest.getTimeStamp());
            }
            if ((depResDir = ResourcesValidityState.getResourcesDir(depFacet)) != null) {
                this.collectFiles(depResDir);
            }
            if (!configuration.isIncludeAssetsFromLibraries() || (depAssetDir = AndroidRootUtil.getAssetsDir(depFacet)) == null) continue;
            this.collectFiles(depAssetDir);
        }
    }

    @Nullable
    private static VirtualFile getResourcesDir(@NotNull AndroidFacet facet) {
        VirtualFile parent;
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/ResourcesValidityState", "getResourcesDir"));
        }
        VirtualFile dir = AndroidAptCompiler.getResourceDirForApkCompiler(facet);
        if (dir != null && "combined-resources".equals((parent = dir.getParent()).getName())) {
            return dir;
        }
        return AndroidRootUtil.getResourceDir(facet);
    }

    private void collectFiles(VirtualFile resourcesDir) {
        for (VirtualFile child : resourcesDir.getChildren()) {
            if (child.isDirectory()) {
                this.collectFiles(child);
                continue;
            }
            this.myResourceTimestamps.put(child.getPath(), child.getTimeStamp());
        }
    }

    public ResourcesValidityState(DataInput is) throws IOException {
        int count = is.readInt();
        for (int i = 0; i < count; ++i) {
            String path = is.readUTF();
            long timestamp = is.readLong();
            this.myResourceTimestamps.put(path, timestamp);
        }
        this.myAndroidTargetName = is.readUTF();
    }

    public boolean equalsTo(ValidityState otherState) {
        if (!(otherState instanceof ResourcesValidityState)) {
            return false;
        }
        ResourcesValidityState rhs = (ResourcesValidityState)otherState;
        return ((Object)this.myResourceTimestamps).equals(rhs.myResourceTimestamps);
    }

    public void save(DataOutput os) throws IOException {
        os.writeInt(this.myResourceTimestamps.size());
        for (Map.Entry<String, Long> e : this.myResourceTimestamps.entrySet()) {
            os.writeUTF(e.getKey());
            os.writeLong(e.getValue());
        }
        os.writeUTF(this.myAndroidTargetName);
    }
}

