/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import java.io.File;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.annotations.NotNull;

class ExcludedSourcesFilter
implements Condition<File> {
    private final Project myProject;

    public ExcludedSourcesFilter(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/ExcludedSourcesFilter", "<init>"));
        }
        this.myProject = project;
    }

    public boolean value(File file) {
        return !AndroidCompileUtil.isExcludedFromCompilation(file, this.myProject);
    }
}

