/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler;

import com.android.sdklib.IAndroidTarget;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.compiler.ClassPostProcessingCompiler;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.FileProcessingCompiler;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.util.ArrayUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.compiler.AndroidDexCompiler;
import org.jetbrains.android.compiler.AndroidPackagingCompiler;
import org.jetbrains.android.compiler.ResourcesValidityState;
import org.jetbrains.android.compiler.tools.AndroidApt;
import org.jetbrains.android.dom.manifest.Application;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;

public class AndroidResourcesPackagingCompiler
implements ClassPostProcessingCompiler {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.compiler.AndroidResourcesPackagingCompiler");
    public static final String RELEASE_SUFFIX = ".release";

    @NotNull
    public FileProcessingCompiler.ProcessingItem[] getProcessingItems(CompileContext context) {
        ArrayList<MyItem> items = new ArrayList<MyItem>();
        for (Module module : ModuleManager.getInstance((Project)context.getProject()).getModules()) {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null || facet.isLibraryProject()) continue;
            VirtualFile manifestFile = AndroidRootUtil.getManifestFileForCompiler(facet);
            ArrayList<String> assetDirPathsList = new ArrayList<String>();
            AndroidResourcesPackagingCompiler.collectAssetDirs(facet, assetDirPathsList);
            String[] assetDirPaths = ArrayUtil.toStringArray(assetDirPathsList);
            if (manifestFile == null) {
                context.addMessage(CompilerMessageCategory.ERROR, AndroidBundle.message("android.compilation.error.manifest.not.found", module.getName()), null, -1, -1);
                continue;
            }
            AndroidFacetConfiguration configuration = (AndroidFacetConfiguration)facet.getConfiguration();
            VirtualFile outputDir = AndroidDexCompiler.getOutputDirectoryForDex(module);
            if (outputDir == null) continue;
            String outputPath = AndroidResourcesPackagingCompiler.getOutputFile(module, outputDir).getPath();
            AndroidPlatform platform = configuration.getAndroidPlatform();
            if (platform == null) continue;
            String[] resourcesDirPaths = AndroidCompileUtil.collectResourceDirs(facet, true, context);
            IAndroidTarget target = platform.getTarget();
            int platformToolsRevision = platform.getSdkData().getPlatformToolsRevision();
            if (resourcesDirPaths.length == 0) {
                context.addMessage(CompilerMessageCategory.WARNING, "Resource directory not found for module " + module.getName(), null, -1, -1);
            }
            items.add(new MyItem(module, target, platformToolsRevision, manifestFile, resourcesDirPaths, assetDirPaths, outputPath, false, AndroidCompileUtil.isReleaseBuild(context)));
        }
        FileProcessingCompiler.ProcessingItem[] processingItemArray = items.toArray(new FileProcessingCompiler.ProcessingItem[items.size()]);
        if (processingItemArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidResourcesPackagingCompiler", "getProcessingItems"));
        }
        return processingItemArray;
    }

    private static void collectAssetDirs(@NotNull AndroidFacet facet, @NotNull List<String> result) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidResourcesPackagingCompiler", "collectAssetDirs"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/compiler/AndroidResourcesPackagingCompiler", "collectAssetDirs"));
        }
        VirtualFile assetsDir = AndroidRootUtil.getAssetsDir(facet);
        if (assetsDir != null) {
            result.add(FileUtil.toSystemDependentName((String)assetsDir.getPath()));
        }
        if (((AndroidFacetConfiguration)facet.getConfiguration()).isIncludeAssetsFromLibraries()) {
            for (AndroidFacet depFacet : AndroidUtils.getAllAndroidDependencies(facet.getModule(), true)) {
                VirtualFile depAssetsDir = AndroidRootUtil.getAssetsDir(depFacet);
                if (depAssetsDir == null) continue;
                result.add(FileUtil.toSystemDependentName((String)depAssetsDir.getPath()));
            }
        }
    }

    static File getOutputFile(Module module, VirtualFile outputDir) {
        return new File(outputDir.getPath(), module.getName() + ".apk.res");
    }

    public FileProcessingCompiler.ProcessingItem[] process(CompileContext context, FileProcessingCompiler.ProcessingItem[] items) {
        if (!AndroidCompileUtil.isFullBuild(context)) {
            return FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY;
        }
        context.getProgressIndicator().setText("Packaging Android resources...");
        ArrayList<MyItem> result = new ArrayList<MyItem>();
        for (FileProcessingCompiler.ProcessingItem processingItem : items) {
            MyItem item = (MyItem)processingItem;
            if (!AndroidCompileUtil.isModuleAffected(context, item.myModule)) continue;
            AndroidResourcesPackagingCompiler.doProcess(context, item, false);
            if (context.getMessages(CompilerMessageCategory.ERROR).length == 0) {
                AndroidResourcesPackagingCompiler.doProcess(context, item, true);
            }
            if (context.getMessages(CompilerMessageCategory.ERROR).length != 0) continue;
            result.add(item);
        }
        return result.toArray(new FileProcessingCompiler.ProcessingItem[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doProcess(final CompileContext context, MyItem item, boolean releasePackage) {
        VirtualFile preprocessedManifestFile;
        if (!AndroidPackagingCompiler.shouldGenerateApk(item.myModule, context, releasePackage)) {
            return;
        }
        File manifestTmpDir = null;
        try {
            if (releasePackage) {
                preprocessedManifestFile = item.myManifestFile;
            } else {
                Pair<VirtualFile, File> pair = AndroidResourcesPackagingCompiler.copyManifestAndSetDebuggableToTrue(item.myModule, item.myManifestFile);
                preprocessedManifestFile = (VirtualFile)pair.getFirst();
                manifestTmpDir = (File)pair.getSecond();
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            context.addMessage(CompilerMessageCategory.ERROR, '[' + item.myModule.getName() + "] Cannot preprocess AndroidManifest.xml for debug build", item.myManifestFile.getUrl(), -1, -1);
            return;
        }
        Map<VirtualFile, VirtualFile> presentableFilesMap = Collections.singletonMap(item.myManifestFile, preprocessedManifestFile);
        try {
            String outputPath = releasePackage ? item.myOutputPath + RELEASE_SUFFIX : item.myOutputPath;
            Map<CompilerMessageCategory, List<String>> messages = AndroidCompileUtil.toCompilerMessageCategoryKeys(AndroidApt.packageResources((IAndroidTarget)item.myAndroidTarget, (int)item.myPlatformToolsRevision, (String)preprocessedManifestFile.getPath(), (String[])item.myResourceDirPaths, (String[])item.myAssetsDirPaths, (String)outputPath, null, (!releasePackage ? 1 : 0) != 0, (int)0, null, (String)"", (FileFilter)new FileFilter(){

                @Override
                public boolean accept(File file) {
                    VirtualFile vFile = LocalFileSystem.getInstance().findFileByIoFile(file);
                    return vFile != null && !ProjectRootManager.getInstance((Project)context.getProject()).getFileIndex().isIgnored(vFile);
                }
            }));
            AndroidCompileUtil.addMessages(context, messages, presentableFilesMap, item.myModule);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    if (context.getProject().isDisposed()) {
                        return;
                    }
                    context.addMessage(CompilerMessageCategory.ERROR, e.getMessage(), null, -1, -1);
                }
            });
        }
        finally {
            if (manifestTmpDir != null) {
                FileUtil.delete((File)manifestTmpDir);
            }
        }
    }

    @NotNull
    private static Pair<VirtualFile, File> copyManifestAndSetDebuggableToTrue(final @NotNull Module module, final @NotNull VirtualFile manifestFile) throws IOException {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidResourcesPackagingCompiler", "copyManifestAndSetDebuggableToTrue"));
        }
        if (manifestFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/compiler/AndroidResourcesPackagingCompiler", "copyManifestAndSetDebuggableToTrue"));
        }
        File dir = FileUtil.createTempDirectory((String)"android_manifest_copy", (String)"tmp");
        final VirtualFile vDir = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(dir);
        if (vDir == null) {
            throw new IOException("Cannot create temp directory for manifest copy");
        }
        final VirtualFile[] manifestFileCopy = new VirtualFile[1];
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            manifestFileCopy[0] = manifestFile.copy((Object)module.getProject(), vDir, manifestFile.getName());
                        }
                        catch (IOException e) {
                            LOG.info((Throwable)e);
                            return;
                        }
                        if (manifestFileCopy[0] == null) {
                            return;
                        }
                        Manifest manifestInCopy = AndroidUtils.loadDomElement(module, manifestFileCopy[0], Manifest.class);
                        if (manifestInCopy == null) {
                            return;
                        }
                        Application applicationInCopy = manifestInCopy.getApplication();
                        if (applicationInCopy == null) {
                            return;
                        }
                        applicationInCopy.getDebuggable().setValue(Boolean.TRUE.toString());
                    }
                });
                if (manifestFileCopy[0] != null) {
                    EncodingManager.getInstance().setEncoding(manifestFileCopy[0], null);
                }
                ApplicationManager.getApplication().saveAll();
            }
        }, ModalityState.defaultModalityState());
        if (manifestFileCopy[0] == null) {
            FileUtil.delete((File)dir);
            throw new IOException("Cannot copy manifest file to " + vDir.getPath());
        }
        Pair pair = Pair.create((Object)manifestFileCopy[0], (Object)dir);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidResourcesPackagingCompiler", "copyManifestAndSetDebuggableToTrue"));
        }
        return pair;
    }

    @NotNull
    public String getDescription() {
        if ("Android Resources Packaging Compiler" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidResourcesPackagingCompiler", "getDescription"));
        }
        return "Android Resources Packaging Compiler";
    }

    public boolean validateConfiguration(CompileScope scope) {
        return true;
    }

    public ValidityState createValidityState(DataInput in) throws IOException {
        return new MyValidityState(in);
    }

    private static class MyValidityState
    extends ResourcesValidityState {
        private final boolean myOutputFileExists;
        private final boolean myGenerateUnsignedApk;
        private final boolean myReleaseBuild;
        private final int myPlatformToolsRevision;

        public MyValidityState(Module module, boolean outputFileExists, boolean generateUnsignedApk, boolean releaseBuild, int platformToolsRevision) {
            super(module);
            this.myOutputFileExists = outputFileExists;
            this.myGenerateUnsignedApk = generateUnsignedApk;
            this.myReleaseBuild = releaseBuild;
            this.myPlatformToolsRevision = platformToolsRevision;
        }

        public MyValidityState(DataInput is) throws IOException {
            super(is);
            this.myGenerateUnsignedApk = is.readBoolean();
            this.myReleaseBuild = is.readBoolean();
            this.myOutputFileExists = true;
            this.myPlatformToolsRevision = is.readInt();
        }

        @Override
        public boolean equalsTo(ValidityState otherState) {
            if (!(otherState instanceof MyValidityState)) {
                return false;
            }
            MyValidityState otherState1 = (MyValidityState)otherState;
            if (this.myOutputFileExists != otherState1.myOutputFileExists) {
                return false;
            }
            if (this.myGenerateUnsignedApk != otherState1.myGenerateUnsignedApk) {
                return false;
            }
            if (this.myReleaseBuild != otherState1.myReleaseBuild) {
                return false;
            }
            if (this.myPlatformToolsRevision != otherState1.myPlatformToolsRevision) {
                return false;
            }
            return super.equalsTo(otherState);
        }

        @Override
        public void save(DataOutput os) throws IOException {
            super.save(os);
            os.writeBoolean(this.myGenerateUnsignedApk);
            os.writeBoolean(this.myReleaseBuild);
            os.writeInt(this.myPlatformToolsRevision);
        }
    }

    private static class MyItem
    implements FileProcessingCompiler.ProcessingItem {
        final Module myModule;
        final VirtualFile myManifestFile;
        final IAndroidTarget myAndroidTarget;
        final String[] myResourceDirPaths;
        final String[] myAssetsDirPaths;
        final String myOutputPath;
        private final boolean myFileExists;
        private final boolean myGenerateUnsignedApk;
        private boolean myReleaseBuild;
        final int myPlatformToolsRevision;

        private MyItem(Module module, IAndroidTarget androidTarget, int platformToolsRevision, VirtualFile manifestFile, String[] resourceDirPaths, String[] assetsDirPath, String outputPath, boolean generateUnsignedApk, boolean releaseBuild) {
            this.myModule = module;
            this.myAndroidTarget = androidTarget;
            this.myPlatformToolsRevision = platformToolsRevision;
            this.myManifestFile = manifestFile;
            this.myResourceDirPaths = resourceDirPaths;
            this.myAssetsDirPaths = assetsDirPath;
            this.myOutputPath = outputPath;
            this.myFileExists = new File(outputPath).exists();
            this.myGenerateUnsignedApk = generateUnsignedApk;
            this.myReleaseBuild = releaseBuild;
        }

        @NotNull
        public VirtualFile getFile() {
            VirtualFile moduleFile = this.myModule.getModuleFile();
            VirtualFile virtualFile = moduleFile != null ? moduleFile : this.myManifestFile;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidResourcesPackagingCompiler$MyItem", "getFile"));
            }
            return virtualFile;
        }

        public ValidityState getValidityState() {
            return new MyValidityState(this.myModule, this.myFileExists, this.myGenerateUnsignedApk, this.myReleaseBuild, this.myPlatformToolsRevision);
        }
    }
}

