/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler;

import com.android.sdklib.IAndroidTarget;
import com.intellij.compiler.CompilerIOUtil;
import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.ClassPostProcessingCompiler;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.FileProcessingCompiler;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.compiler.AndroidDexCompiler;
import org.jetbrains.android.compiler.ProguardRunningOptions;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidProguardCompiler
implements ClassPostProcessingCompiler {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.compiler.AndroidProguardCompiler");
    public static Key<String> PROGUARD_CFG_PATHS_KEY = Key.create((String)"ANDROID_PROGUARD_CFG_PATHS");

    @NotNull
    public FileProcessingCompiler.ProcessingItem[] getProcessingItems(final CompileContext context) {
        FileProcessingCompiler.ProcessingItem[] processingItemArray = (FileProcessingCompiler.ProcessingItem[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<FileProcessingCompiler.ProcessingItem[]>(){

            public FileProcessingCompiler.ProcessingItem[] compute() {
                Module[] modules = ModuleManager.getInstance((Project)context.getProject()).getModules();
                ArrayList<MyProcessingItem> items = new ArrayList<MyProcessingItem>();
                for (Module module : modules) {
                    ProguardRunningOptions proguardRunningOptions;
                    AndroidFacet facet = AndroidFacet.getInstance(module);
                    if (facet == null || facet.isLibraryProject() || (proguardRunningOptions = AndroidCompileUtil.getProguardConfigFilePathIfShouldRun(facet, context)) == null) continue;
                    List<String> proguardCfgPaths = proguardRunningOptions.getProguardCfgFiles();
                    if (proguardCfgPaths.size() == 0) {
                        context.addMessage(CompilerMessageCategory.ERROR, "Proguard config file path is not specified for module " + module.getName(), null, -1, -1);
                        continue;
                    }
                    ArrayList<VirtualFile> proguardConfigFiles = new ArrayList<VirtualFile>();
                    boolean proguardCfgNotFound = false;
                    for (String proguardCfgPath : proguardCfgPaths) {
                        VirtualFile proguardConfigFile = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)proguardCfgPath));
                        if (proguardConfigFile == null) {
                            context.addMessage(CompilerMessageCategory.ERROR, "Cannot find file " + proguardCfgPath, null, -1, -1);
                            proguardCfgNotFound = true;
                            break;
                        }
                        proguardConfigFiles.add(proguardConfigFile);
                    }
                    if (proguardCfgNotFound) continue;
                    CompilerModuleExtension extension = CompilerModuleExtension.getInstance((Module)module);
                    if (extension == null) {
                        LOG.error("Cannot find compiler module extension for module " + module.getName());
                        continue;
                    }
                    VirtualFile classFilesDir = extension.getCompilerOutputPath();
                    if (classFilesDir == null) {
                        context.addMessage(CompilerMessageCategory.INFORMATION, "Output directory is not specified for module " + module.getName(), null, -1, -1);
                        continue;
                    }
                    VirtualFile mainContentRoot = AndroidRootUtil.getMainContentRoot(facet);
                    if (mainContentRoot == null) {
                        context.addMessage(CompilerMessageCategory.ERROR, "Cannot find main content root for module " + module.getName(), null, -1, -1);
                        continue;
                    }
                    AndroidPlatform platform = ((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidPlatform();
                    if (platform == null) {
                        context.addMessage(CompilerMessageCategory.ERROR, AndroidBundle.message("android.compilation.proguardCfgNotFound.specify.platform", module.getName()), null, -1, -1);
                        continue;
                    }
                    String logsDirOsPath = FileUtil.toSystemDependentName((String)(mainContentRoot.getPath() + '/' + "proguard_logs"));
                    File logsDir = new File(logsDirOsPath);
                    if (!logsDir.exists() && !logsDir.mkdirs()) {
                        context.addMessage(CompilerMessageCategory.ERROR, "Cannot find directory " + logsDirOsPath, null, -1, -1);
                        continue;
                    }
                    List<VirtualFile> externalJars = AndroidRootUtil.getExternalLibraries(module);
                    HashSet classFilesDirs = new HashSet();
                    HashSet libClassFilesDirs = new HashSet();
                    AndroidDexCompiler.addModuleOutputDir((Collection<VirtualFile>)classFilesDirs, classFilesDir);
                    for (VirtualFile file : AndroidRootUtil.getDependentModules(module, classFilesDir)) {
                        if (file.isDirectory()) {
                            AndroidDexCompiler.addModuleOutputDir((Collection<VirtualFile>)classFilesDirs, file);
                            continue;
                        }
                        AndroidDexCompiler.addModuleOutputDir((Collection<VirtualFile>)libClassFilesDirs, file.getParent());
                    }
                    String sdkPath = platform.getSdkData().getPath();
                    VirtualFile outputDir = AndroidDexCompiler.getOutputDirectoryForDex(module);
                    String outputJarOsPath = FileUtil.toSystemDependentName((String)(outputDir.getPath() + '/' + "obfuscated_sources.jar"));
                    VirtualFile proguardCfgGeneratedByAapt = outputDir.findChild("proguard.txt");
                    if (proguardCfgGeneratedByAapt != null) {
                        proguardConfigFiles.add(proguardCfgGeneratedByAapt);
                    }
                    items.add(new MyProcessingItem(module, sdkPath, platform.getTarget(), platform.getSdkData().getSdkToolsRevision(), proguardConfigFiles, false, outputJarOsPath, classFilesDir, classFilesDirs.toArray(new VirtualFile[classFilesDirs.size()]), libClassFilesDirs.toArray(new VirtualFile[libClassFilesDirs.size()]), externalJars.toArray(new VirtualFile[externalJars.size()]), logsDirOsPath));
                }
                return items.toArray(new FileProcessingCompiler.ProcessingItem[items.size()]);
            }
        });
        if (processingItemArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidProguardCompiler", "getProcessingItems"));
        }
        return processingItemArray;
    }

    @Nullable
    private static String getJavaExecutablePath(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidProguardCompiler", "getJavaExecutablePath"));
        }
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        if (sdk == null) {
            return null;
        }
        SdkTypeId sdkType = sdk.getSdkType();
        if (!(sdkType instanceof JavaSdkType)) {
            return null;
        }
        return ((JavaSdkType)sdkType).getVMExecutablePath(sdk);
    }

    public FileProcessingCompiler.ProcessingItem[] process(CompileContext context, FileProcessingCompiler.ProcessingItem[] items) {
        ArrayList<FileProcessingCompiler.ProcessingItem> processedItems = new ArrayList<FileProcessingCompiler.ProcessingItem>();
        for (FileProcessingCompiler.ProcessingItem item : items) {
            MyProcessingItem processingItem = (MyProcessingItem)item;
            if (!AndroidCompileUtil.isModuleAffected(context, processingItem.myModule)) continue;
            Module module = ((MyProcessingItem)item).getModule();
            String javaExecutablePath = AndroidProguardCompiler.getJavaExecutablePath(module);
            if (javaExecutablePath == null) {
                context.addMessage(CompilerMessageCategory.ERROR, "Cannot find Java SDK for module " + module.getName(), null, -1, -1);
                continue;
            }
            List<VirtualFile> cfgFiles = processingItem.getProguardConfigFiles();
            String[] proguardCfgOsPaths = AndroidCompileUtil.toOsPaths(cfgFiles.toArray(new VirtualFile[cfgFiles.size()]));
            String[] classFilesDirOsPaths = AndroidCompileUtil.toOsPaths(processingItem.getClassFilesDirs());
            String[] libClassFilesDirOsPaths = AndroidCompileUtil.toOsPaths(processingItem.getLibClassFilesDirs());
            String[] externalJarOsPaths = AndroidCompileUtil.toOsPaths(processingItem.getExternalJars());
            try {
                String inputJarOsPath = AndroidCommonUtils.buildTempInputJar((String[])classFilesDirOsPaths, (String[])libClassFilesDirOsPaths);
                String logsDirOsPath = processingItem.getLogsDirectoryOsPath();
                Map<CompilerMessageCategory, List<String>> messages = AndroidCompileUtil.toCompilerMessageCategoryKeys(AndroidCommonUtils.launchProguard((IAndroidTarget)processingItem.getTarget(), (int)processingItem.getSdkToolsRevision(), (String)processingItem.getSdkOsPath(), (String)javaExecutablePath, (String)"", (String[])proguardCfgOsPaths, (String)inputJarOsPath, (String[])externalJarOsPaths, (String)processingItem.getOutputJarOsPath(), (String)logsDirOsPath));
                CompilerUtil.refreshIOFile((File)new File(processingItem.getOutputJarOsPath()));
                AndroidCompileUtil.addMessages(context, messages, processingItem.myModule);
                if (!messages.get(CompilerMessageCategory.ERROR).isEmpty()) continue;
                processedItems.add(item);
            }
            catch (IOException e) {
                if (e.getMessage() == null) {
                    LOG.error((Throwable)e);
                    continue;
                }
                LOG.info((Throwable)e);
                context.addMessage(CompilerMessageCategory.ERROR, "I/O error: " + e.getMessage(), null, -1, -1);
            }
        }
        return processedItems.toArray(new FileProcessingCompiler.ProcessingItem[processedItems.size()]);
    }

    @NotNull
    public String getDescription() {
        if ("Android Proguard Runner" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidProguardCompiler", "getDescription"));
        }
        return "Android Proguard Runner";
    }

    public boolean validateConfiguration(CompileScope scope) {
        return true;
    }

    public ValidityState createValidityState(DataInput in) throws IOException {
        return new MyValidityState(in);
    }

    private static class MyValidityState
    implements ValidityState {
        private final String myTargetHashString;
        private final String mySdkPath;
        private final String myOutputDirPath;
        private final String myLogsDirectoryPath;
        private final Map<String, Long> myClassFilesMap;
        private final Map<String, Long> myExternalJarsMap;
        private final Map<String, Long> myConfigFileTimestamps;
        private final boolean myIncludeSystemProguardCfg;

        public MyValidityState(@NotNull IAndroidTarget target, @NotNull String sdkOsPath, @NotNull String outputJarOsPath, @NotNull VirtualFile[] classFilesDirs, @NotNull VirtualFile[] externalJars, @NotNull List<VirtualFile> proguardConfigFiles, boolean includeSystemProguardCfg, @Nullable String logsDirectoryOsPath) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidProguardCompiler$MyValidityState", "<init>"));
            }
            if (sdkOsPath == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/compiler/AndroidProguardCompiler$MyValidityState", "<init>"));
            }
            if (outputJarOsPath == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/compiler/AndroidProguardCompiler$MyValidityState", "<init>"));
            }
            if (classFilesDirs == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/android/compiler/AndroidProguardCompiler$MyValidityState", "<init>"));
            }
            if (externalJars == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/android/compiler/AndroidProguardCompiler$MyValidityState", "<init>"));
            }
            if (proguardConfigFiles == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "org/jetbrains/android/compiler/AndroidProguardCompiler$MyValidityState", "<init>"));
            }
            this.myTargetHashString = target.hashString();
            this.mySdkPath = sdkOsPath;
            this.myOutputDirPath = outputJarOsPath;
            this.myIncludeSystemProguardCfg = includeSystemProguardCfg;
            this.myClassFilesMap = new HashMap();
            HashSet visited = new HashSet();
            for (VirtualFile dir : classFilesDirs) {
                this.fillClassFilesMap(dir, (Set<VirtualFile>)visited);
            }
            this.myExternalJarsMap = new HashMap();
            for (VirtualFile jar : externalJars) {
                this.myExternalJarsMap.put(jar.getPath(), jar.getTimeStamp());
            }
            this.myConfigFileTimestamps = new HashMap();
            for (VirtualFile file : proguardConfigFiles) {
                this.myConfigFileTimestamps.put(file.getPath(), file.getTimeStamp());
            }
            this.myLogsDirectoryPath = logsDirectoryOsPath != null ? logsDirectoryOsPath : "";
        }

        private void fillClassFilesMap(VirtualFile file, Set<VirtualFile> visited) {
            if (file.isDirectory() && visited.add(file)) {
                for (VirtualFile child : file.getChildren()) {
                    this.fillClassFilesMap(child, visited);
                }
            } else if (StdFileTypes.CLASS.equals(file.getFileType())) {
                this.myClassFilesMap.put(file.getPath(), file.getTimeStamp());
            }
        }

        public MyValidityState(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidProguardCompiler$MyValidityState", "<init>"));
            }
            this.myTargetHashString = in.readUTF();
            this.mySdkPath = CompilerIOUtil.readString((DataInput)in);
            this.myOutputDirPath = CompilerIOUtil.readString((DataInput)in);
            this.myClassFilesMap = new HashMap();
            int classFilesCount = in.readInt();
            for (int i = 0; i < classFilesCount; ++i) {
                String path = CompilerIOUtil.readString((DataInput)in);
                long timestamp = in.readLong();
                this.myClassFilesMap.put(path, timestamp);
            }
            this.myExternalJarsMap = new HashMap();
            int externalJarsCount = in.readInt();
            for (int i = 0; i < externalJarsCount; ++i) {
                String path = CompilerIOUtil.readString((DataInput)in);
                long timestamp = in.readLong();
                this.myExternalJarsMap.put(path, timestamp);
            }
            this.myConfigFileTimestamps = new HashMap();
            int configFileCounts = in.readInt();
            for (int i = 0; i < configFileCounts; ++i) {
                String path = CompilerIOUtil.readString((DataInput)in);
                long timestamp = in.readLong();
                this.myConfigFileTimestamps.put(path, timestamp);
            }
            this.myIncludeSystemProguardCfg = in.readBoolean();
            this.myLogsDirectoryPath = CompilerIOUtil.readString((DataInput)in);
        }

        public boolean equalsTo(ValidityState otherState) {
            if (!(otherState instanceof MyValidityState)) {
                return false;
            }
            MyValidityState other = (MyValidityState)otherState;
            return this.myTargetHashString.equals(other.myTargetHashString) && this.mySdkPath.equals(other.mySdkPath) && this.myOutputDirPath.equals(other.myOutputDirPath) && ((Object)this.myClassFilesMap).equals(other.myClassFilesMap) && ((Object)this.myExternalJarsMap).equals(other.myExternalJarsMap) && ((Object)this.myConfigFileTimestamps).equals(other.myConfigFileTimestamps) && this.myIncludeSystemProguardCfg == other.myIncludeSystemProguardCfg && this.myLogsDirectoryPath.equals(other.myLogsDirectoryPath);
        }

        public void save(DataOutput out) throws IOException {
            out.writeUTF(this.myTargetHashString);
            CompilerIOUtil.writeString((String)this.mySdkPath, (DataOutput)out);
            CompilerIOUtil.writeString((String)this.myOutputDirPath, (DataOutput)out);
            out.writeInt(this.myClassFilesMap.size());
            for (String path : this.myClassFilesMap.keySet()) {
                CompilerIOUtil.writeString((String)path, (DataOutput)out);
                out.writeLong(this.myClassFilesMap.get(path));
            }
            out.writeInt(this.myExternalJarsMap.size());
            for (String path : this.myExternalJarsMap.keySet()) {
                CompilerIOUtil.writeString((String)path, (DataOutput)out);
                out.writeLong(this.myExternalJarsMap.get(path));
            }
            out.writeInt(this.myConfigFileTimestamps.size());
            for (String path : this.myConfigFileTimestamps.keySet()) {
                CompilerIOUtil.writeString((String)path, (DataOutput)out);
                out.writeLong(this.myConfigFileTimestamps.get(path));
            }
            out.writeBoolean(this.myIncludeSystemProguardCfg);
            CompilerIOUtil.writeString((String)this.myLogsDirectoryPath, (DataOutput)out);
        }
    }

    private static class MyProcessingItem
    implements FileProcessingCompiler.ProcessingItem {
        private final Module myModule;
        private final IAndroidTarget myTarget;
        private final int mySdkToolsRevision;
        private final String myOutputJarOsPath;
        private final VirtualFile myMainClassFilesDir;
        private final VirtualFile[] myClassFilesDirs;
        private final VirtualFile[] myLibClassFilesDirs;
        private final VirtualFile[] myExternalJars;
        private final String myLogsDirectoryOsPath;
        private final List<VirtualFile> myProguardConfigFiles;
        private final boolean myIncludeSystemProguardFile;
        private final String mySdkOsPath;

        private MyProcessingItem(@NotNull Module module, @NotNull String sdkOsPath, @NotNull IAndroidTarget target, int sdkToolsRevision, @NotNull List<VirtualFile> proguardConfigFiles, boolean includeSystemProguardFile, @NotNull String outputJarOsPath, @NotNull VirtualFile mainClassFilesDir, @NotNull VirtualFile[] classFilesDirs, @NotNull VirtualFile[] libCLassFilesDirs, @NotNull VirtualFile[] externalJars, @Nullable String logsDirectoryOsPath) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidProguardCompiler$MyProcessingItem", "<init>"));
            }
            if (sdkOsPath == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/compiler/AndroidProguardCompiler$MyProcessingItem", "<init>"));
            }
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/compiler/AndroidProguardCompiler$MyProcessingItem", "<init>"));
            }
            if (proguardConfigFiles == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/android/compiler/AndroidProguardCompiler$MyProcessingItem", "<init>"));
            }
            if (outputJarOsPath == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "6", "org/jetbrains/android/compiler/AndroidProguardCompiler$MyProcessingItem", "<init>"));
            }
            if (mainClassFilesDir == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "7", "org/jetbrains/android/compiler/AndroidProguardCompiler$MyProcessingItem", "<init>"));
            }
            if (classFilesDirs == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "8", "org/jetbrains/android/compiler/AndroidProguardCompiler$MyProcessingItem", "<init>"));
            }
            if (libCLassFilesDirs == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "9", "org/jetbrains/android/compiler/AndroidProguardCompiler$MyProcessingItem", "<init>"));
            }
            if (externalJars == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "10", "org/jetbrains/android/compiler/AndroidProguardCompiler$MyProcessingItem", "<init>"));
            }
            this.myModule = module;
            this.myTarget = target;
            this.mySdkToolsRevision = sdkToolsRevision;
            this.myProguardConfigFiles = proguardConfigFiles;
            this.myIncludeSystemProguardFile = includeSystemProguardFile;
            this.myOutputJarOsPath = outputJarOsPath;
            this.myMainClassFilesDir = mainClassFilesDir;
            this.mySdkOsPath = sdkOsPath;
            this.myClassFilesDirs = classFilesDirs;
            this.myLibClassFilesDirs = libCLassFilesDirs;
            this.myExternalJars = externalJars;
            this.myLogsDirectoryOsPath = logsDirectoryOsPath;
        }

        @NotNull
        public String getOutputJarOsPath() {
            String string = this.myOutputJarOsPath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidProguardCompiler$MyProcessingItem", "getOutputJarOsPath"));
            }
            return string;
        }

        @NotNull
        public String getSdkOsPath() {
            String string = this.mySdkOsPath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidProguardCompiler$MyProcessingItem", "getSdkOsPath"));
            }
            return string;
        }

        @NotNull
        public VirtualFile[] getClassFilesDirs() {
            if (this.myClassFilesDirs == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidProguardCompiler$MyProcessingItem", "getClassFilesDirs"));
            }
            return this.myClassFilesDirs;
        }

        @NotNull
        public VirtualFile[] getLibClassFilesDirs() {
            if (this.myLibClassFilesDirs == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidProguardCompiler$MyProcessingItem", "getLibClassFilesDirs"));
            }
            return this.myLibClassFilesDirs;
        }

        @NotNull
        public VirtualFile getFile() {
            VirtualFile virtualFile = this.myMainClassFilesDir;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidProguardCompiler$MyProcessingItem", "getFile"));
            }
            return virtualFile;
        }

        public List<VirtualFile> getProguardConfigFiles() {
            return this.myProguardConfigFiles;
        }

        public boolean isIncludeSystemProguardFile() {
            return this.myIncludeSystemProguardFile;
        }

        @NotNull
        public VirtualFile[] getExternalJars() {
            if (this.myExternalJars == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidProguardCompiler$MyProcessingItem", "getExternalJars"));
            }
            return this.myExternalJars;
        }

        @NotNull
        public IAndroidTarget getTarget() {
            IAndroidTarget iAndroidTarget = this.myTarget;
            if (iAndroidTarget == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidProguardCompiler$MyProcessingItem", "getTarget"));
            }
            return iAndroidTarget;
        }

        public int getSdkToolsRevision() {
            return this.mySdkToolsRevision;
        }

        @Nullable
        public String getLogsDirectoryOsPath() {
            return this.myLogsDirectoryOsPath;
        }

        public ValidityState getValidityState() {
            return new MyValidityState(this.myTarget, this.mySdkOsPath, this.myOutputJarOsPath, this.myClassFilesDirs, this.myExternalJars, this.myProguardConfigFiles, this.myIncludeSystemProguardFile, this.myLogsDirectoryOsPath);
        }

        @NotNull
        public Module getModule() {
            Module module = this.myModule;
            if (module == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidProguardCompiler$MyProcessingItem", "getModule"));
            }
            return module;
        }
    }
}

