/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler;

import com.android.sdklib.IAndroidTarget;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.GeneratingCompiler;
import com.intellij.openapi.compiler.SourceGeneratingCompiler;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.hash.HashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.compiler.AndroidAptCompiler;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.compiler.tools.AndroidApt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidPngFilesCachingCompiler
implements SourceGeneratingCompiler {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.compiler.AndroidPngFilesCachingCompiler");

    @NotNull
    public GeneratingCompiler.GenerationItem[] getGenerationItems(final CompileContext context) {
        GeneratingCompiler.GenerationItem[] generationItemArray = (GeneratingCompiler.GenerationItem[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<GeneratingCompiler.GenerationItem[]>(){

            public GeneratingCompiler.GenerationItem[] compute() {
                Module[] modules;
                ArrayList<MyItem> items = new ArrayList<MyItem>();
                for (Module module : modules = ModuleManager.getInstance((Project)context.getProject()).getModules()) {
                    VirtualFile resourcesDir;
                    AndroidFacet facet = AndroidFacet.getInstance(module);
                    if (facet == null || (resourcesDir = AndroidAptCompiler.getResourceDirForApkCompiler(facet)) == null) continue;
                    AndroidPlatform platform = ((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidPlatform();
                    if (platform == null) {
                        context.addMessage(CompilerMessageCategory.ERROR, AndroidBundle.message("android.compilation.error.specify.platform", module.getName()), null, -1, -1);
                        continue;
                    }
                    int platformToolsRevision = platform.getSdkData().getPlatformToolsRevision();
                    if (platformToolsRevision > 0 && platformToolsRevision <= 7) continue;
                    items.add(new MyItem(module, platform.getTarget(), resourcesDir));
                }
                return items.toArray(new GeneratingCompiler.GenerationItem[items.size()]);
            }
        });
        if (generationItemArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidPngFilesCachingCompiler", "getGenerationItems"));
        }
        return generationItemArray;
    }

    public GeneratingCompiler.GenerationItem[] generate(CompileContext context, GeneratingCompiler.GenerationItem[] items, VirtualFile outputRootDirectory) {
        if (items == null || items.length == 0 || !AndroidCompileUtil.isFullBuild(context)) {
            return new GeneratingCompiler.GenerationItem[0];
        }
        context.getProgressIndicator().setText("Processing PNG files...");
        ArrayList<MyItem> processedItems = new ArrayList<MyItem>();
        for (GeneratingCompiler.GenerationItem GenerationItem2 : items) {
            MyItem item = (MyItem)GenerationItem2;
            Module module = item.getModule();
            if (!AndroidCompileUtil.isModuleAffected(context, module)) continue;
            String resDirOsPath = FileUtil.toSystemDependentName((String)item.getResourceDir().getPath());
            try {
                String resCacheDirOsPath = AndroidCompileUtil.findResourcesCacheDirectory(module, true, context);
                if (resCacheDirOsPath == null) continue;
                Map<CompilerMessageCategory, List<String>> messages = AndroidCompileUtil.toCompilerMessageCategoryKeys(AndroidApt.crunch((IAndroidTarget)item.getTarget(), Collections.singletonList(resDirOsPath), (String)resCacheDirOsPath));
                AndroidCompileUtil.addMessages(context, messages, module);
                if (context.getMessages(CompilerMessageCategory.ERROR).length != 0) continue;
                processedItems.add(item);
            }
            catch (IOException e) {
                String message = e.getMessage();
                if (message != null) {
                    LOG.info((Throwable)e);
                    context.addMessage(CompilerMessageCategory.ERROR, e.getMessage(), null, -1, -1);
                    continue;
                }
                LOG.error((Throwable)e);
            }
        }
        return processedItems.toArray(new GeneratingCompiler.GenerationItem[processedItems.size()]);
    }

    @Nullable
    public VirtualFile getPresentableFile(CompileContext context, Module module, VirtualFile outputRoot, VirtualFile generatedFile) {
        return null;
    }

    @NotNull
    public String getDescription() {
        if ("Android PNG files caching compiler" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidPngFilesCachingCompiler", "getDescription"));
        }
        return "Android PNG files caching compiler";
    }

    public boolean validateConfiguration(CompileScope scope) {
        return true;
    }

    public ValidityState createValidityState(DataInput in) throws IOException {
        return new MyValidityState(in);
    }

    private static class MyValidityState
    implements ValidityState {
        private final String myTargetHashString;
        private final Map<String, Long> myTimestamps;

        private MyValidityState(@NotNull IAndroidTarget target, @NotNull VirtualFile resourceDir) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidPngFilesCachingCompiler$MyValidityState", "<init>"));
            }
            if (resourceDir == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/compiler/AndroidPngFilesCachingCompiler$MyValidityState", "<init>"));
            }
            this.myTimestamps = new HashMap();
            this.myTargetHashString = target.hashString();
            this.collectPngFiles(resourceDir, (Set<VirtualFile>)new HashSet());
        }

        public MyValidityState(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidPngFilesCachingCompiler$MyValidityState", "<init>"));
            }
            this.myTimestamps = new HashMap();
            this.myTargetHashString = in.readUTF();
            int pairsCount = in.readInt();
            for (int i = 0; i < pairsCount; ++i) {
                String path = in.readUTF();
                long timestamp = in.readLong();
                this.myTimestamps.put(path, timestamp);
            }
        }

        private void collectPngFiles(@NotNull VirtualFile file, @NotNull Set<VirtualFile> visited) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidPngFilesCachingCompiler$MyValidityState", "collectPngFiles"));
            }
            if (visited == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/compiler/AndroidPngFilesCachingCompiler$MyValidityState", "collectPngFiles"));
            }
            if (!visited.add(file)) {
                return;
            }
            if (file.isDirectory()) {
                for (VirtualFile child : file.getChildren()) {
                    this.collectPngFiles(child, visited);
                }
            } else if ("png".equals(file.getExtension())) {
                this.myTimestamps.put(file.getPath(), file.getTimeStamp());
            }
        }

        public boolean equalsTo(ValidityState otherState) {
            if (!(otherState instanceof MyValidityState)) {
                return false;
            }
            MyValidityState other = (MyValidityState)otherState;
            if (!Comparing.equal((String)this.myTargetHashString, (String)other.myTargetHashString)) {
                return false;
            }
            return ((Object)this.myTimestamps).equals(other.myTimestamps);
        }

        public void save(DataOutput out) throws IOException {
            out.writeUTF(this.myTargetHashString);
            out.writeInt(this.myTimestamps.size());
            for (Map.Entry<String, Long> e : this.myTimestamps.entrySet()) {
                out.writeUTF(e.getKey());
                out.writeLong(e.getValue());
            }
        }
    }

    private static class MyItem
    implements GeneratingCompiler.GenerationItem {
        private final Module myModule;
        private final IAndroidTarget myTarget;
        private final VirtualFile myResourceDir;
        private final MyValidityState myValidityState;

        private MyItem(@NotNull Module module, @NotNull IAndroidTarget target, @NotNull VirtualFile resourceDir) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidPngFilesCachingCompiler$MyItem", "<init>"));
            }
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/compiler/AndroidPngFilesCachingCompiler$MyItem", "<init>"));
            }
            if (resourceDir == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/compiler/AndroidPngFilesCachingCompiler$MyItem", "<init>"));
            }
            this.myModule = module;
            this.myTarget = target;
            this.myResourceDir = resourceDir;
            this.myValidityState = new MyValidityState(this.myTarget, this.myResourceDir);
        }

        @NotNull
        public IAndroidTarget getTarget() {
            IAndroidTarget iAndroidTarget = this.myTarget;
            if (iAndroidTarget == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidPngFilesCachingCompiler$MyItem", "getTarget"));
            }
            return iAndroidTarget;
        }

        @NotNull
        public VirtualFile getResourceDir() {
            VirtualFile virtualFile = this.myResourceDir;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidPngFilesCachingCompiler$MyItem", "getResourceDir"));
            }
            return virtualFile;
        }

        @NotNull
        public Module getModule() {
            Module module = this.myModule;
            if (module == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidPngFilesCachingCompiler$MyItem", "getModule"));
            }
            return module;
        }

        public boolean isTestSource() {
            return false;
        }

        @Nullable
        public String getPath() {
            return null;
        }

        public ValidityState getValidityState() {
            return this.myValidityState;
        }
    }
}

