/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler;

import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.ClassPostProcessingCompiler;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.FileProcessingCompiler;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashSet;
import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.compiler.AndroidDexCompiler;
import org.jetbrains.android.compiler.ClassesAndJarsValidityState;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.annotations.NotNull;

public class AndroidLibraryPackagingCompiler
implements ClassPostProcessingCompiler {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.compiler.AndroidLibraryPackagingCompiler");

    @NotNull
    public FileProcessingCompiler.ProcessingItem[] getProcessingItems(final CompileContext context) {
        FileProcessingCompiler.ProcessingItem[] processingItemArray = (FileProcessingCompiler.ProcessingItem[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<FileProcessingCompiler.ProcessingItem[]>(){

            public FileProcessingCompiler.ProcessingItem[] compute() {
                ArrayList<MyProcessingItem> result = new ArrayList<MyProcessingItem>();
                for (Module module : ModuleManager.getInstance((Project)context.getProject()).getModules()) {
                    AndroidFacet facet = AndroidFacet.getInstance(module);
                    if (facet == null || !facet.isLibraryProject()) continue;
                    CompilerModuleExtension extension = CompilerModuleExtension.getInstance((Module)module);
                    LOG.assertTrue(extension != null);
                    VirtualFile classesDir = extension.getCompilerOutputPath();
                    if (classesDir == null) continue;
                    HashSet firstPackageDirs = new HashSet();
                    AndroidDexCompiler.addModuleOutputDir((Collection<VirtualFile>)firstPackageDirs, classesDir);
                    if (firstPackageDirs.size() == 0) continue;
                    VirtualFile outputDirectory = AndroidDexCompiler.getOutputDirectoryForDex(module);
                    if (outputDirectory == null) {
                        LOG.error("Cannot find output directory for dex");
                        continue;
                    }
                    result.add(new MyProcessingItem(module, (VirtualFile[])firstPackageDirs.toArray((Object[])new VirtualFile[firstPackageDirs.size()]), outputDirectory));
                }
                return result.toArray(new FileProcessingCompiler.ProcessingItem[result.size()]);
            }
        });
        if (processingItemArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidLibraryPackagingCompiler", "getProcessingItems"));
        }
        return processingItemArray;
    }

    public FileProcessingCompiler.ProcessingItem[] process(CompileContext context, FileProcessingCompiler.ProcessingItem[] items) {
        if (!AndroidCompileUtil.isFullBuild(context) || items == null || items.length == 0) {
            return FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY;
        }
        context.getProgressIndicator().setText("Packaging library modules...");
        ArrayList<MyProcessingItem> result = new ArrayList<MyProcessingItem>();
        for (FileProcessingCompiler.ProcessingItem item : items) {
            MyProcessingItem processingItem = (MyProcessingItem)item;
            if (!AndroidCompileUtil.isModuleAffected(context, processingItem.getModule())) continue;
            String[] classesDirOsPaths = AndroidCompileUtil.toOsPaths(processingItem.getClassDirectories());
            String outputJarOsPath = FileUtil.toSystemDependentName((String)(processingItem.getOutputDirectory().getPath() + '/' + "classes.jar"));
            File outputJarFile = new File(outputJarOsPath);
            try {
                AndroidCommonUtils.packClassFilesIntoJar((String[])ArrayUtil.EMPTY_STRING_ARRAY, (String[])classesDirOsPaths, (File)outputJarFile);
                CompilerUtil.refreshIOFile((File)outputJarFile);
                result.add(processingItem);
            }
            catch (IOException e) {
                if (e.getMessage() == null) {
                    LOG.error((Throwable)e);
                    continue;
                }
                LOG.info((Throwable)e);
                context.addMessage(CompilerMessageCategory.ERROR, "Cannot pack sources of module " + processingItem.getModule().getName() + " to " + outputJarFile.getName() + ": " + e.getMessage(), null, -1, -1);
            }
        }
        return result.toArray(new MyProcessingItem[result.size()]);
    }

    @NotNull
    public String getDescription() {
        if ("Android Library Packaging Compiler" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidLibraryPackagingCompiler", "getDescription"));
        }
        return "Android Library Packaging Compiler";
    }

    public boolean validateConfiguration(CompileScope scope) {
        return true;
    }

    public ValidityState createValidityState(DataInput in) throws IOException {
        return new ClassesAndJarsValidityState(in);
    }

    private static class MyProcessingItem
    implements FileProcessingCompiler.ProcessingItem {
        private final Module myModule;
        private final VirtualFile[] myClassDirectories;
        private final VirtualFile myOutputDirectory;

        private MyProcessingItem(@NotNull Module module, @NotNull VirtualFile[] classDirectories, @NotNull VirtualFile directory) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidLibraryPackagingCompiler$MyProcessingItem", "<init>"));
            }
            if (classDirectories == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/compiler/AndroidLibraryPackagingCompiler$MyProcessingItem", "<init>"));
            }
            if (directory == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/compiler/AndroidLibraryPackagingCompiler$MyProcessingItem", "<init>"));
            }
            assert (classDirectories.length > 0);
            this.myOutputDirectory = directory;
            this.myClassDirectories = classDirectories;
            this.myModule = module;
        }

        @NotNull
        public VirtualFile getFile() {
            VirtualFile virtualFile = this.myClassDirectories[0].getParent();
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidLibraryPackagingCompiler$MyProcessingItem", "getFile"));
            }
            return virtualFile;
        }

        public ValidityState getValidityState() {
            return new ClassesAndJarsValidityState(Arrays.asList(this.myClassDirectories));
        }

        @NotNull
        public Module getModule() {
            Module module = this.myModule;
            if (module == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidLibraryPackagingCompiler$MyProcessingItem", "getModule"));
            }
            return module;
        }

        @NotNull
        public VirtualFile[] getClassDirectories() {
            if (this.myClassDirectories == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidLibraryPackagingCompiler$MyProcessingItem", "getClassDirectories"));
            }
            return this.myClassDirectories;
        }

        @NotNull
        public VirtualFile getOutputDirectory() {
            VirtualFile virtualFile = this.myOutputDirectory;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidLibraryPackagingCompiler$MyProcessingItem", "getOutputDirectory"));
            }
            return virtualFile;
        }
    }
}

