/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler;

import com.android.SdkConstants;
import com.android.sdklib.IAndroidTarget;
import com.intellij.facet.FacetManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.GeneratingCompiler;
import com.intellij.openapi.compiler.SourceGeneratingCompiler;
import com.intellij.openapi.compiler.TimestampValidityState;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.compiler.AndroidPackagingCompiler;
import org.jetbrains.android.compiler.tools.AndroidIdl;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.fileTypes.AndroidIdlFileType;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidIdlCompiler
implements SourceGeneratingCompiler {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.compiler.AndroidIdlCompiler");
    private static final GeneratingCompiler.GenerationItem[] EMPTY_GENERATION_ITEM_ARRAY = new GeneratingCompiler.GenerationItem[0];
    private final Project myProject;

    public AndroidIdlCompiler(Project project) {
        this.myProject = project;
    }

    @Nullable
    public VirtualFile getPresentableFile(CompileContext context, Module module, VirtualFile outputRoot, VirtualFile generatedFile) {
        return null;
    }

    public GeneratingCompiler.GenerationItem[] getGenerationItems(CompileContext context) {
        return (GeneratingCompiler.GenerationItem[])ApplicationManager.getApplication().runReadAction((Computable)new PrepareAction(context));
    }

    public GeneratingCompiler.GenerationItem[] generate(CompileContext context, GeneratingCompiler.GenerationItem[] items, VirtualFile outputRootDirectory) {
        if (items != null && items.length > 0) {
            context.getProgressIndicator().setText("Generating AIDL files...");
            return AndroidIdlCompiler.doGenerate(context, items, outputRootDirectory);
        }
        return EMPTY_GENERATION_ITEM_ARRAY;
    }

    @NotNull
    public String getDescription() {
        String string = FileUtil.getNameWithoutExtension((String)SdkConstants.FN_AIDL);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidIdlCompiler", "getDescription"));
        }
        return string;
    }

    public boolean validateConfiguration(CompileScope scope) {
        return true;
    }

    @Nullable
    public ValidityState createValidityState(DataInput is) throws IOException {
        return TimestampValidityState.load((DataInput)is);
    }

    private static GeneratingCompiler.GenerationItem[] doGenerate(final CompileContext context, GeneratingCompiler.GenerationItem[] items, VirtualFile outputRootDirectory) {
        if (context.getProject().isDisposed()) {
            return EMPTY_GENERATION_ITEM_ARRAY;
        }
        ArrayList<IdlGenerationItem> results = new ArrayList<IdlGenerationItem>(items.length);
        boolean toRefresh = false;
        for (GeneratingCompiler.GenerationItem item : items) {
            if (!(item instanceof IdlGenerationItem)) continue;
            final IdlGenerationItem idlItem = (IdlGenerationItem)item;
            if (!AndroidCompileUtil.isModuleAffected(context, idlItem.myModule)) continue;
            try {
                VirtualFile[] sourceRoots = AndroidPackagingCompiler.getSourceRootsForModuleAndDependencies(idlItem.myModule, false);
                String[] sourceRootPaths = AndroidCompileUtil.toOsPaths(sourceRoots);
                String outFilePath = FileUtil.toSystemDependentName((String)(outputRootDirectory.getPath() + '/' + idlItem.myPackageName.replace('.', '/') + '/' + idlItem.myFile.getNameWithoutExtension() + ".java"));
                final Map messages = AndroidCompileUtil.toCompilerMessageCategoryKeys(AndroidIdl.execute((IAndroidTarget)idlItem.myAndroidTarget, (String)idlItem.myFile.getPath(), (String)outFilePath, (String[])sourceRootPaths));
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        if (context.getProject().isDisposed()) {
                            return;
                        }
                        AndroidIdlCompiler.addMessages(context, messages, idlItem.myFile.getUrl());
                    }
                });
                if (!((List)messages.get(CompilerMessageCategory.ERROR)).isEmpty()) continue;
                toRefresh = true;
                results.add(idlItem);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        if (context.getProject().isDisposed()) {
                            return;
                        }
                        context.addMessage(CompilerMessageCategory.ERROR, e.getMessage(), idlItem.myFile.getUrl(), -1, -1);
                    }
                });
            }
        }
        if (toRefresh) {
            AndroidCompileUtil.markDirtyAndRefresh(outputRootDirectory, true);
        }
        return results.toArray(new GeneratingCompiler.GenerationItem[results.size()]);
    }

    private static void addMessages(CompileContext context, Map<CompilerMessageCategory, List<String>> messages, String url) {
        for (CompilerMessageCategory category : messages.keySet()) {
            List<String> messageList = messages.get(category);
            for (String message : messageList) {
                context.addMessage(category, message, url, -1, -1);
            }
        }
    }

    private final class PrepareAction
    implements Computable<GeneratingCompiler.GenerationItem[]> {
        private final CompileContext myContext;

        public PrepareAction(CompileContext context) {
            this.myContext = context;
        }

        public GeneratingCompiler.GenerationItem[] compute() {
            if (this.myContext.getProject().isDisposed()) {
                return EMPTY_GENERATION_ITEM_ARRAY;
            }
            VirtualFile[] files = this.myContext.getProjectCompileScope().getFiles((FileType)AndroidIdlFileType.ourFileType, true);
            ArrayList<GeneratingCompiler.GenerationItem> items = new ArrayList<GeneratingCompiler.GenerationItem>(files.length);
            for (VirtualFile file : files) {
                Module module = this.myContext.getModuleByFile(file);
                AndroidFacet facet = (AndroidFacet)FacetManager.getInstance((Module)module).getFacetByType(AndroidFacet.ID);
                if (facet == null) continue;
                IAndroidTarget target = ((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidTarget();
                if (target == null) {
                    this.myContext.addMessage(CompilerMessageCategory.ERROR, AndroidBundle.message("android.compilation.error.specify.platform", module.getName()), null, -1, -1);
                    continue;
                }
                String packageName = AndroidUtils.computePackageName(module, file);
                if (packageName == null) {
                    this.myContext.addMessage(CompilerMessageCategory.ERROR, "Cannot compute package for file", file.getUrl(), -1, -1);
                    continue;
                }
                this.addItem(file, facet, target, packageName, items);
            }
            return items.toArray(new GeneratingCompiler.GenerationItem[items.size()]);
        }

        private void addItem(VirtualFile file, AndroidFacet facet, IAndroidTarget target, String packageName, List<GeneratingCompiler.GenerationItem> items) {
            Module module = facet.getModule();
            String sourceRootPath = AndroidRootUtil.getAidlGenSourceRootPath(facet);
            if (sourceRootPath == null) {
                this.myContext.addMessage(CompilerMessageCategory.ERROR, AndroidBundle.message("android.compilation.error.apt.gen.not.specified", module.getName()), null, -1, -1);
                return;
            }
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)AndroidIdlCompiler.this.myProject).getFileIndex();
            items.add(new IdlGenerationItem(module, file, fileIndex.isInTestSourceContent(file), target, packageName));
        }
    }

    private static final class IdlGenerationItem
    implements GeneratingCompiler.GenerationItem {
        final Module myModule;
        final VirtualFile myFile;
        final boolean myTestSource;
        final IAndroidTarget myAndroidTarget;
        final String myPackageName;
        private final TimestampValidityState myValidityState;

        public IdlGenerationItem(@NotNull Module module, @NotNull VirtualFile file, boolean testSource, @NotNull IAndroidTarget androidTarget, @NotNull String packageName) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidIdlCompiler$IdlGenerationItem", "<init>"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/compiler/AndroidIdlCompiler$IdlGenerationItem", "<init>"));
            }
            if (androidTarget == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/android/compiler/AndroidIdlCompiler$IdlGenerationItem", "<init>"));
            }
            if (packageName == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/android/compiler/AndroidIdlCompiler$IdlGenerationItem", "<init>"));
            }
            this.myModule = module;
            this.myFile = file;
            this.myTestSource = testSource;
            this.myAndroidTarget = androidTarget;
            this.myPackageName = packageName;
            this.myValidityState = new TimestampValidityState(this.myFile.getTimeStamp());
        }

        @Nullable
        public String getPath() {
            return this.myPackageName.replace('.', '/') + '/' + this.myFile.getNameWithoutExtension() + ".java";
        }

        @Nullable
        public ValidityState getValidityState() {
            return this.myValidityState;
        }

        public Module getModule() {
            return this.myModule;
        }

        public boolean isTestSource() {
            return this.myTestSource;
        }
    }
}

