/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.GeneratingCompiler;
import com.intellij.openapi.compiler.SourceGeneratingCompiler;
import com.intellij.openapi.compiler.TimestampValidityState;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.compiler.ex.CompileContextEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashSet;
import com.intellij.util.io.ZipUtil;
import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.maven.AndroidExternalApklibDependenciesManager;
import org.jetbrains.android.maven.AndroidMavenUtil;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidExternalApklibExtractingCompiler
implements SourceGeneratingCompiler {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.compiler.AndroidExternalApklibExtractingCompiler");

    @Nullable
    public VirtualFile getPresentableFile(CompileContext context, Module module, VirtualFile outputRoot, VirtualFile generatedFile) {
        return null;
    }

    public GeneratingCompiler.GenerationItem[] getGenerationItems(final CompileContext context) {
        return (GeneratingCompiler.GenerationItem[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<GeneratingCompiler.GenerationItem[]>(){

            public GeneratingCompiler.GenerationItem[] compute() {
                ArrayList<MyGenerationItem> result = new ArrayList<MyGenerationItem>();
                for (Module module : ModuleManager.getInstance((Project)context.getProject()).getModules()) {
                    String mavenIdStr;
                    AndroidFacet facet = AndroidFacet.getInstance(module);
                    if (facet == null || !facet.isLibraryProject() || (mavenIdStr = AndroidMavenUtil.getMavenIdStringByExtApklibModule(facet.getModule())) == null) continue;
                    AndroidExternalApklibDependenciesManager manager = AndroidExternalApklibDependenciesManager.getInstance(context.getProject());
                    String artifactFilePath = manager.getArtifactFilePath(mavenIdStr);
                    if (artifactFilePath == null) {
                        context.addMessage(CompilerMessageCategory.ERROR, "Cannot find artifact file for generated module " + module.getName() + ". Try to force reimport Maven model", null, -1, -1);
                        continue;
                    }
                    VirtualFile root = AndroidRootUtil.getMainContentRoot(facet);
                    if (root == null) {
                        context.addMessage(CompilerMessageCategory.ERROR, "Cannot find main root in generated module containing AndroidManifest.xml" + module.getName() + ". Try to force reimport Maven model", null, -1, -1);
                        continue;
                    }
                    result.add(new MyGenerationItem(module, FileUtil.toSystemDependentName((String)root.getPath()), FileUtil.toSystemDependentName((String)artifactFilePath)));
                }
                return result.toArray(new GeneratingCompiler.GenerationItem[result.size()]);
            }
        });
    }

    public GeneratingCompiler.GenerationItem[] generate(CompileContext context, GeneratingCompiler.GenerationItem[] items, VirtualFile outputRootDirectory) {
        if (items == null || items.length == 0) {
            return new GeneratingCompiler.GenerationItem[0];
        }
        context.getProgressIndicator().setText(AndroidBundle.message("android.compile.messages.processing.external.apklib.dependencies", new Object[0]));
        GeneratingCompiler.GenerationItem[] generatedItems = AndroidExternalApklibExtractingCompiler.doGenerate(context, items);
        HashSet generatedVFiles = new HashSet();
        HashSet visited = new HashSet();
        for (GeneratingCompiler.GenerationItem item : generatedItems) {
            MyGenerationItem genItem = (MyGenerationItem)item;
            File contentRoot = new File(genItem.getGenContentRootPath());
            VirtualFile vContentRoot = LocalFileSystem.getInstance().findFileByIoFile(contentRoot);
            if (vContentRoot == null) continue;
            vContentRoot.refresh(false, true);
            VirtualFile vSrcRoot = vContentRoot.findChild("src");
            if (vSrcRoot == null) continue;
            AndroidCompileUtil.markDirty(vSrcRoot, true);
            AndroidUtils.collectFiles(vSrcRoot, (Set<VirtualFile>)visited, (Set<VirtualFile>)generatedVFiles);
        }
        if (context instanceof CompileContextEx) {
            ((CompileContextEx)context).markGenerated((Collection)generatedVFiles);
        }
        return generatedItems;
    }

    private static GeneratingCompiler.GenerationItem[] doGenerate(CompileContext context, GeneratingCompiler.GenerationItem[] items) {
        ArrayList<MyGenerationItem> result = new ArrayList<MyGenerationItem>();
        for (GeneratingCompiler.GenerationItem item : items) {
            Module module = item.getModule();
            if (!AndroidCompileUtil.isModuleAffected(context, module)) continue;
            MyGenerationItem genItem = (MyGenerationItem)item;
            String artifactPath = genItem.getArtifactPath();
            File artifactFile = new File(artifactPath);
            if (!artifactFile.exists()) {
                context.addMessage(CompilerMessageCategory.ERROR, "Cannot find file " + artifactPath, null, -1, -1);
                continue;
            }
            if (!artifactFile.isFile()) {
                context.addMessage(CompilerMessageCategory.ERROR, artifactPath + " is not file", null, -1, -1);
                continue;
            }
            String genContentRootPath = ((MyGenerationItem)item).getGenContentRootPath();
            File genContentRootFile = new File(genContentRootPath);
            if (genContentRootFile.exists() && !FileUtil.delete((File)genContentRootFile)) {
                context.addMessage(CompilerMessageCategory.ERROR, "Cannot delete old directory: " + genContentRootPath, null, -1, -1);
                continue;
            }
            if (!genContentRootFile.mkdir()) {
                context.addMessage(CompilerMessageCategory.ERROR, "Cannot create directory " + genContentRootPath, null, -1, -1);
                continue;
            }
            try {
                ZipUtil.extract((File)artifactFile, (File)genContentRootFile, null);
            }
            catch (IOException e) {
                String message = e.getMessage();
                if (message == null) {
                    context.addMessage(CompilerMessageCategory.ERROR, "Unknown I/O error", null, -1, -1);
                    LOG.error((Throwable)e);
                    continue;
                }
                context.addMessage(CompilerMessageCategory.ERROR, message, null, -1, -1);
                LOG.info((Throwable)e);
                continue;
            }
            result.add(genItem);
        }
        return result.toArray(new GeneratingCompiler.GenerationItem[result.size()]);
    }

    @NotNull
    public String getDescription() {
        if ("Android External Apklib Extracting Compiler" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidExternalApklibExtractingCompiler", "getDescription"));
        }
        return "Android External Apklib Extracting Compiler";
    }

    public boolean validateConfiguration(CompileScope scope) {
        return true;
    }

    public ValidityState createValidityState(DataInput in) throws IOException {
        return TimestampValidityState.load((DataInput)in);
    }

    private static class MyGenerationItem
    implements GeneratingCompiler.GenerationItem {
        private final Module myModule;
        private final String myGenContentRootPath;
        private final String myArtifactPath;
        private final TimestampValidityState myValidityState;

        private MyGenerationItem(@NotNull Module module, @NotNull String genContentRootPath, @NotNull String artifactPath) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidExternalApklibExtractingCompiler$MyGenerationItem", "<init>"));
            }
            if (genContentRootPath == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/compiler/AndroidExternalApklibExtractingCompiler$MyGenerationItem", "<init>"));
            }
            if (artifactPath == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/compiler/AndroidExternalApklibExtractingCompiler$MyGenerationItem", "<init>"));
            }
            this.myModule = module;
            this.myGenContentRootPath = genContentRootPath;
            this.myArtifactPath = artifactPath;
            this.myValidityState = new TimestampValidityState(new File(this.myArtifactPath).lastModified());
        }

        @Nullable
        public String getPath() {
            return this.myGenContentRootPath;
        }

        public ValidityState getValidityState() {
            return this.myValidityState;
        }

        @NotNull
        public Module getModule() {
            Module module = this.myModule;
            if (module == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidExternalApklibExtractingCompiler$MyGenerationItem", "getModule"));
            }
            return module;
        }

        public boolean isTestSource() {
            return false;
        }

        @NotNull
        public String getGenContentRootPath() {
            String string = this.myGenContentRootPath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidExternalApklibExtractingCompiler$MyGenerationItem", "getGenContentRootPath"));
            }
            return string;
        }

        @NotNull
        public String getArtifactPath() {
            String string = this.myArtifactPath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidExternalApklibExtractingCompiler$MyGenerationItem", "getArtifactPath"));
            }
            return string;
        }
    }
}

