/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler;

import com.intellij.compiler.DependencyProcessor;
import com.intellij.compiler.make.Cache;
import com.intellij.compiler.make.CacheCorruptedException;
import com.intellij.compiler.make.CachingSearcher;
import com.intellij.compiler.make.DependencyCache;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.ex.CompileContextEx;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.HashSet;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.annotations.Nullable;

public class AndroidDependencyProcessor
implements DependencyProcessor {
    public void processDependencies(CompileContext context, int classQualifiedName, final CachingSearcher searcher) throws CacheCorruptedException {
        if (!(context instanceof CompileContextEx)) {
            return;
        }
        final Project project = context.getProject();
        if (!ProjectFacetManager.getInstance((Project)project).hasFacets(AndroidFacet.ID)) {
            return;
        }
        DependencyCache depCache = ((CompileContextEx)context).getDependencyCache();
        Cache cache = depCache.getCache();
        String path = cache.getPath(classQualifiedName);
        String classFileName = new File(path).getName();
        if (!AndroidCommonUtils.R_PATTERN.matcher(classFileName).matches()) {
            return;
        }
        String qName = depCache.resolve(classQualifiedName);
        int idx = qName.indexOf(36);
        final String topLevelClassName = idx < 0 ? qName : qName.substring(0, idx);
        HashSet qNamesToMark = new HashSet();
        ApplicationManager.getApplication().runReadAction(new Runnable((Set)qNamesToMark){
            final /* synthetic */ Set val$qNamesToMark;
            {
                this.val$qNamesToMark = set;
            }

            @Override
            public void run() {
                PsiClass[] classes;
                for (PsiClass aClass : classes = JavaPsiFacade.getInstance((Project)project).findClasses(topLevelClassName, GlobalSearchScope.projectScope((Project)project))) {
                    Collection references = searcher.findReferences((PsiElement)aClass, true);
                    for (PsiReference reference : references) {
                        String ownerClassQName;
                        PsiClass ownerClass = AndroidDependencyProcessor.getOwnerClass(reference.getElement());
                        if (ownerClass == null || ownerClass.equals(aClass) || (ownerClassQName = ownerClass.getQualifiedName()) == null) continue;
                        this.val$qNamesToMark.add(ownerClassQName);
                    }
                }
            }
        });
        for (String toMark : qNamesToMark) {
            int qualifiedName = depCache.getSymbolTable().getId(toMark);
            depCache.markClass(qualifiedName);
        }
    }

    @Nullable
    private static PsiClass getOwnerClass(PsiElement element) {
        while (!(element instanceof PsiFile) && element != null) {
            if (element instanceof PsiClass && element.getParent() instanceof PsiJavaFile) {
                return (PsiClass)element;
            }
            element = element.getParent();
        }
        return null;
    }
}

