/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler;

import com.android.tools.idea.fileTypes.AndroidRenderscriptFileType;
import com.intellij.CommonBundle;
import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.CompilerWorkspaceConfiguration;
import com.intellij.compiler.impl.CompileContextImpl;
import com.intellij.compiler.impl.ModuleCompileScope;
import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.compiler.progress.CompilerTask;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.facet.Facet;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.Compiler;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.options.ExcludeEntryDescription;
import com.intellij.openapi.compiler.options.ExcludedEntriesConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.artifacts.ArtifactPropertiesProvider;
import com.intellij.packaging.impl.compiler.ArtifactCompileScope;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.android.compiler.AndroidAptCompiler;
import org.jetbrains.android.compiler.AndroidAutogenerator;
import org.jetbrains.android.compiler.AndroidAutogeneratorMode;
import org.jetbrains.android.compiler.AndroidPngFilesCachingCompiler;
import org.jetbrains.android.compiler.AndroidProguardCompiler;
import org.jetbrains.android.compiler.ProguardRunningOptions;
import org.jetbrains.android.compiler.artifact.AndroidApplicationArtifactProperties;
import org.jetbrains.android.compiler.artifact.AndroidApplicationArtifactType;
import org.jetbrains.android.compiler.artifact.AndroidArtifactPropertiesProvider;
import org.jetbrains.android.compiler.artifact.AndroidArtifactSigningMode;
import org.jetbrains.android.compiler.artifact.AndroidArtifactUtil;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.fileTypes.AndroidIdlFileType;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidCompilerMessageKind;
import org.jetbrains.android.util.AndroidExecutionUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleProperties;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class AndroidCompileUtil {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.compiler.AndroidCompileUtil");
    private static final Key<Boolean> RELEASE_BUILD_KEY = new Key("RELEASE_BUILD_KEY");
    @NonNls
    private static final String RESOURCES_CACHE_DIR_NAME = "res-cache";
    @NonNls
    private static final String GEN_MODULE_PREFIX = "~generated_";
    @NonNls
    public static final String OLD_PROGUARD_CFG_FILE_NAME = "proguard.cfg";
    public static final String UNSIGNED_SUFFIX = ".unsigned";

    private AndroidCompileUtil() {
    }

    @NotNull
    public static <T> Map<CompilerMessageCategory, T> toCompilerMessageCategoryKeys(@NotNull Map<AndroidCompilerMessageKind, T> map) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidCompileUtil", "toCompilerMessageCategoryKeys"));
        }
        HashMap result = new HashMap();
        for (Map.Entry<AndroidCompilerMessageKind, T> entry : map.entrySet()) {
            AndroidCompilerMessageKind key = entry.getKey();
            T value = entry.getValue();
            switch (key) {
                case ERROR: {
                    result.put(CompilerMessageCategory.ERROR, value);
                    break;
                }
                case INFORMATION: {
                    result.put(CompilerMessageCategory.INFORMATION, value);
                    break;
                }
                case WARNING: {
                    result.put(CompilerMessageCategory.WARNING, value);
                }
            }
        }
        HashMap hashMap = result;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidCompileUtil", "toCompilerMessageCategoryKeys"));
        }
        return hashMap;
    }

    @Nullable
    public static Pair<VirtualFile, Boolean> getDefaultProguardConfigFile(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidCompileUtil", "getDefaultProguardConfigFile"));
        }
        VirtualFile root = AndroidRootUtil.getMainContentRoot(facet);
        if (root == null) {
            return null;
        }
        VirtualFile proguardCfg = root.findChild("proguard-project.txt");
        if (proguardCfg != null) {
            return new Pair((Object)proguardCfg, (Object)true);
        }
        VirtualFile oldProguardCfg = root.findChild(OLD_PROGUARD_CFG_FILE_NAME);
        if (oldProguardCfg != null) {
            return new Pair((Object)oldProguardCfg, (Object)false);
        }
        return null;
    }

    public static void addMessages(CompileContext context, Map<CompilerMessageCategory, List<String>> messages, @Nullable Module module) {
        AndroidCompileUtil.addMessages(context, messages, null, module);
    }

    static void addMessages(final CompileContext context, final Map<CompilerMessageCategory, List<String>> messages, final @Nullable Map<VirtualFile, VirtualFile> presentableFilesMap, final @Nullable Module module) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                if (context.getProject().isDisposed()) {
                    return;
                }
                for (CompilerMessageCategory category : messages.keySet()) {
                    List messageList = (List)messages.get(category);
                    for (String message : messageList) {
                        String fileName;
                        String url = null;
                        int line = -1;
                        Matcher matcher = AndroidCommonUtils.COMPILER_MESSAGE_PATTERN.matcher(message);
                        if (matcher.matches() && new File(fileName = matcher.group(1)).exists()) {
                            url = AndroidCompileUtil.getPresentableFile("file://" + fileName, presentableFilesMap);
                            line = Integer.parseInt(matcher.group(2));
                        }
                        context.addMessage(category, (module != null ? '[' + module.getName() + "] " : "") + message, url, line, -1);
                    }
                }
            }
        });
    }

    @NotNull
    private static String getPresentableFile(@NotNull String url, @Nullable Map<VirtualFile, VirtualFile> presentableFilesMap) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidCompileUtil", "getPresentableFile"));
        }
        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
        if (file == null) {
            String string = url;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidCompileUtil", "getPresentableFile"));
            }
            return string;
        }
        if (presentableFilesMap == null) {
            String string = url;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidCompileUtil", "getPresentableFile"));
            }
            return string;
        }
        for (Map.Entry<VirtualFile, VirtualFile> entry : presentableFilesMap.entrySet()) {
            if (!Comparing.equal((Object)file, (Object)entry.getValue())) continue;
            String string = entry.getKey().getUrl();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidCompileUtil", "getPresentableFile"));
            }
            return string;
        }
        String string = url;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidCompileUtil", "getPresentableFile"));
        }
        return string;
    }

    private static void collectChildrenRecursively(@NotNull VirtualFile root, @NotNull VirtualFile anchor, @NotNull Collection<VirtualFile> result) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidCompileUtil", "collectChildrenRecursively"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/compiler/AndroidCompileUtil", "collectChildrenRecursively"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/compiler/AndroidCompileUtil", "collectChildrenRecursively"));
        }
        if (Comparing.equal((Object)root, (Object)anchor)) {
            return;
        }
        VirtualFile parent = anchor.getParent();
        if (parent == null) {
            return;
        }
        for (VirtualFile child : parent.getChildren()) {
            if (Comparing.equal((Object)child, (Object)anchor)) continue;
            result.add(child);
        }
        if (!Comparing.equal((Object)parent, (Object)root)) {
            AndroidCompileUtil.collectChildrenRecursively(root, parent, result);
        }
    }

    private static void unexcludeRootIfNecessary(@NotNull VirtualFile root, @NotNull ModifiableRootModel model, @NotNull Ref<Boolean> modelChangedFlag) {
        VirtualFile excludedRoot;
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidCompileUtil", "unexcludeRootIfNecessary"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/compiler/AndroidCompileUtil", "unexcludeRootIfNecessary"));
        }
        if (modelChangedFlag == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/compiler/AndroidCompileUtil", "unexcludeRootIfNecessary"));
        }
        HashSet excludedRoots = new HashSet(Arrays.asList(model.getExcludeRoots()));
        for (excludedRoot = root; excludedRoot != null && !excludedRoots.contains(excludedRoot); excludedRoot = excludedRoot.getParent()) {
        }
        if (excludedRoot == null) {
            return;
        }
        HashSet rootsToExclude = new HashSet();
        AndroidCompileUtil.collectChildrenRecursively(excludedRoot, root, (Collection<VirtualFile>)rootsToExclude);
        ContentEntry contentEntry = AndroidCompileUtil.findContentEntryForRoot(model, excludedRoot);
        if (contentEntry != null) {
            if (contentEntry.removeExcludeFolder(excludedRoot.getUrl())) {
                modelChangedFlag.set((Object)true);
            }
            for (VirtualFile rootToExclude : rootsToExclude) {
                if (excludedRoots.contains(rootToExclude)) continue;
                contentEntry.addExcludeFolder(rootToExclude);
                modelChangedFlag.set((Object)true);
            }
        }
    }

    @NotNull
    private static String getGenModuleName(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidCompileUtil", "getGenModuleName"));
        }
        String string = GEN_MODULE_PREFIX + module.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidCompileUtil", "getGenModuleName"));
        }
        return string;
    }

    @Nullable
    public static VirtualFile createSourceRootIfNotExist(@NotNull String path, @NotNull ModifiableRootModel model, @NotNull Ref<Boolean> modelChangedFlag) {
        boolean created;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidCompileUtil", "createSourceRootIfNotExist"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/compiler/AndroidCompileUtil", "createSourceRootIfNotExist"));
        }
        if (modelChangedFlag == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/compiler/AndroidCompileUtil", "createSourceRootIfNotExist"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        File rootFile = new File(path);
        if (!rootFile.exists()) {
            if (!rootFile.mkdirs()) {
                return null;
            }
            created = true;
        } else {
            created = false;
        }
        Module module = model.getModule();
        Project project = module.getProject();
        if (project.isDisposed() || module.isDisposed()) {
            return null;
        }
        VirtualFile root = created ? LocalFileSystem.getInstance().refreshAndFindFileByIoFile(rootFile) : LocalFileSystem.getInstance().findFileByIoFile(rootFile);
        if (root != null) {
            AndroidCompileUtil.unexcludeRootIfNecessary(root, model, modelChangedFlag);
            boolean markedAsSource = false;
            for (VirtualFile existingRoot : model.getSourceRoots()) {
                if (!Comparing.equal((Object)existingRoot, (Object)root)) continue;
                markedAsSource = true;
            }
            if (markedAsSource) {
                AndroidCompileUtil.markRootAsGenerated(model, root, modelChangedFlag);
            } else {
                AndroidCompileUtil.addSourceRoot(model, root);
                modelChangedFlag.set((Object)true);
            }
        }
        return root;
    }

    private static void markRootAsGenerated(ModifiableRootModel model, VirtualFile root, Ref<Boolean> modelChangedFlag) {
        ContentEntry contentEntry = AndroidCompileUtil.findContentEntryForRoot(model, root);
        if (contentEntry == null) {
            return;
        }
        for (SourceFolder sourceFolder : contentEntry.getSourceFolders()) {
            JavaSourceRootProperties props;
            if (!root.equals(sourceFolder.getFile()) || (props = (JavaSourceRootProperties)sourceFolder.getJpsElement().getProperties(JavaModuleSourceRootTypes.SOURCES)) == null) continue;
            props.setForGeneratedSources(true);
            modelChangedFlag.set((Object)true);
            break;
        }
    }

    private static void excludeFromCompilation(@NotNull Project project, @NotNull VirtualFile sourceRoot, @NotNull String aPackage) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidCompileUtil", "excludeFromCompilation"));
        }
        if (sourceRoot == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/compiler/AndroidCompileUtil", "excludeFromCompilation"));
        }
        if (aPackage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/compiler/AndroidCompileUtil", "excludeFromCompilation"));
        }
        String buildConfigPath = sourceRoot.getPath() + '/' + aPackage.replace('.', '/') + "/BuildConfig.java";
        String url = VfsUtilCore.pathToUrl((String)buildConfigPath);
        ExcludedEntriesConfiguration configuration = CompilerConfiguration.getInstance((Project)project).getExcludedEntriesConfiguration();
        for (ExcludeEntryDescription description : configuration.getExcludeEntryDescriptions()) {
            if (!Comparing.equal((String)description.getUrl(), (String)url)) continue;
            return;
        }
        configuration.addExcludeEntryDescription(new ExcludeEntryDescription(url, true, false, (Disposable)project));
    }

    private static void excludeFromCompilation(@NotNull Project project, @NotNull VirtualFile dir) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidCompileUtil", "excludeFromCompilation"));
        }
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/compiler/AndroidCompileUtil", "excludeFromCompilation"));
        }
        ExcludedEntriesConfiguration configuration = CompilerConfiguration.getInstance((Project)project).getExcludedEntriesConfiguration();
        for (ExcludeEntryDescription description : configuration.getExcludeEntryDescriptions()) {
            if (!Comparing.equal((Object)description.getVirtualFile(), (Object)dir)) continue;
            return;
        }
        configuration.addExcludeEntryDescription(new ExcludeEntryDescription(dir, true, false, (Disposable)project));
    }

    private static void removeGenModule(@NotNull ModifiableRootModel model, @NotNull Ref<Boolean> modelChangedFlag) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidCompileUtil", "removeGenModule"));
        }
        if (modelChangedFlag == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/compiler/AndroidCompileUtil", "removeGenModule"));
        }
        String genModuleName = AndroidCompileUtil.getGenModuleName(model.getModule());
        final Project project = model.getProject();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        Module genModule = moduleManager.findModuleByName(genModuleName);
        if (genModule == null) {
            return;
        }
        for (OrderEntry entry : model.getOrderEntries()) {
            if (!(entry instanceof ModuleOrderEntry) || !genModuleName.equals(((ModuleOrderEntry)entry).getModuleName())) continue;
            model.removeOrderEntry(entry);
            modelChangedFlag.set((Object)true);
        }
        final VirtualFile moduleFile = genModule.getModuleFile();
        moduleManager.disposeModule(genModule);
        if (moduleFile != null) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                moduleFile.delete((Object)project);
                            }
                            catch (IOException e) {
                                LOG.error((Throwable)e);
                            }
                        }
                    });
                }
            });
        }
    }

    @Nullable
    public static SourceFolder addSourceRoot(final ModifiableRootModel model, @NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/compiler/AndroidCompileUtil", "addSourceRoot"));
        }
        ContentEntry contentEntry = AndroidCompileUtil.findContentEntryForRoot(model, root);
        if (contentEntry == null) {
            final Project project = model.getProject();
            String message = "Cannot mark directory '" + FileUtil.toSystemDependentName((String)root.getPath()) + "' as source root, because it is not located under content root of module '" + model.getModule().getName() + "'\n<a href='fix'>Open Project Structure</a>";
            Notification notification = new Notification(AndroidBundle.message("android.autogeneration.notification.group", new Object[0]), "Autogeneration Error", message, NotificationType.ERROR, (NotificationListener)new NotificationListener.Adapter(){

                protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                    if (notification == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidCompileUtil$3", "hyperlinkActivated"));
                    }
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/compiler/AndroidCompileUtil$3", "hyperlinkActivated"));
                    }
                    notification.expire();
                    final ProjectStructureConfigurable configurable = ProjectStructureConfigurable.getInstance((Project)project);
                    ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable, new Runnable(){

                        @Override
                        public void run() {
                            Module module = model.getModule();
                            AndroidFacet facet = AndroidFacet.getInstance(module);
                            if (facet != null) {
                                configurable.select((Facet)facet, true);
                            }
                        }
                    });
                }
            });
            Notifications.Bus.notify((Notification)notification, (Project)project);
            LOG.debug(message);
            return null;
        }
        return contentEntry.addSourceFolder(root, (JpsModuleSourceRootType)JavaSourceRootType.SOURCE, (JpsElement)JpsJavaExtensionService.getInstance().createSourceRootProperties("", true));
    }

    @Nullable
    public static ContentEntry findContentEntryForRoot(@NotNull ModifiableRootModel model, @NotNull VirtualFile root) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidCompileUtil", "findContentEntryForRoot"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/compiler/AndroidCompileUtil", "findContentEntryForRoot"));
        }
        ContentEntry contentEntry = null;
        for (ContentEntry candidate : model.getContentEntries()) {
            VirtualFile contentRoot = candidate.getFile();
            if (contentRoot == null || !VfsUtilCore.isAncestor((VirtualFile)contentRoot, (VirtualFile)root, (boolean)false)) continue;
            contentEntry = candidate;
        }
        return contentEntry;
    }

    public static void generate(Module module, AndroidAutogeneratorMode mode) {
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet != null) {
            facet.scheduleSourceRegenerating(mode);
        }
    }

    public static boolean doGenerate(AndroidFacet facet, AndroidAutogeneratorMode mode) {
        assert (!ApplicationManager.getApplication().isDispatchThread());
        final CompileContext[] contextWrapper = new CompileContext[1];
        final Module module = facet.getModule();
        final Project project = module.getProject();
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                if (project.isDisposed()) {
                    return;
                }
                CompilerTask task = new CompilerTask(project, "Android auto-generation", true, false, true, true);
                ModuleCompileScope scope = new ModuleCompileScope(module, false);
                contextWrapper[0] = new CompileContextImpl(project, task, (CompileScope)scope, null, false, false);
            }
        });
        CompileContext context = contextWrapper[0];
        if (context == null) {
            return false;
        }
        AndroidCompileUtil.generate(facet, mode, context, false);
        return context.getMessages(CompilerMessageCategory.ERROR).length == 0;
    }

    public static boolean isModuleAffected(CompileContext context, Module module) {
        return ArrayUtil.find((Object[])context.getCompileScope().getAffectedModules(), (Object)module) >= 0;
    }

    public static void generate(AndroidFacet facet, AndroidAutogeneratorMode mode, CompileContext context, boolean force) {
        if (context == null) {
            return;
        }
        AndroidAutogenerator.run(mode, facet, context, force);
    }

    public static void removeDuplicatingClasses(Module module, @NotNull String packageName, @NotNull String className, @Nullable File classFile, String sourceRootPath) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/compiler/AndroidCompileUtil", "removeDuplicatingClasses"));
        }
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/compiler/AndroidCompileUtil", "removeDuplicatingClasses"));
        }
        if (sourceRootPath == null) {
            return;
        }
        VirtualFile sourceRoot = LocalFileSystem.getInstance().findFileByPath(sourceRootPath);
        if (sourceRoot == null) {
            return;
        }
        final Project project = module.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        String interfaceQualifiedName = packageName + '.' + className;
        PsiClass[] classes = facade.findClasses(interfaceQualifiedName, GlobalSearchScope.moduleScope((Module)module));
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        for (PsiClass c : classes) {
            String path;
            File f;
            VirtualFile virtualFile;
            PsiFile psiFile = c.getContainingFile();
            if (!className.equals(FileUtil.getNameWithoutExtension((String)psiFile.getName())) || (virtualFile = psiFile.getVirtualFile()) == null || !Comparing.equal((Object)projectFileIndex.getSourceRootForFile(virtualFile), (Object)sourceRoot) || FileUtil.filesEqual((File)(f = new File(path = virtualFile.getPath())), (File)classFile) || !f.exists()) continue;
            if (f.delete()) {
                virtualFile.refresh(true, false);
                continue;
            }
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    Messages.showErrorDialog((Project)project, (String)("Can't delete file " + path), (String)CommonBundle.getErrorTitle());
                }
            }, project.getDisposed());
        }
    }

    @NotNull
    public static String[] collectResourceDirs(AndroidFacet facet, boolean collectResCacheDirs, @Nullable CompileContext context) {
        AndroidPngFilesCachingCompiler pngFilesCachingCompiler;
        Project project = facet.getModule().getProject();
        AndroidPngFilesCachingCompiler androidPngFilesCachingCompiler = pngFilesCachingCompiler = collectResCacheDirs ? (AndroidPngFilesCachingCompiler)Extensions.findExtension((ExtensionPointName)Compiler.EP_NAME, (AreaInstance)project, AndroidPngFilesCachingCompiler.class) : null;
        if (collectResCacheDirs) assert (pngFilesCachingCompiler != null);
        ArrayList<String> result = new ArrayList<String>();
        AndroidCompileUtil.doCollectResourceDirs(facet, collectResCacheDirs, result, context);
        for (AndroidFacet depFacet : AndroidUtils.getAllAndroidDependencies(facet.getModule(), true)) {
            AndroidCompileUtil.doCollectResourceDirs(depFacet, collectResCacheDirs, result, context);
        }
        String[] stringArray = ArrayUtil.toStringArray(result);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidCompileUtil", "collectResourceDirs"));
        }
        return stringArray;
    }

    private static void doCollectResourceDirs(AndroidFacet facet, boolean collectResCacheDirs, List<String> result, CompileContext context) {
        VirtualFile resourcesDir;
        Module module = facet.getModule();
        if (collectResCacheDirs) {
            int platformToolsRevision;
            AndroidPlatform platform = ((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidPlatform();
            int n = platformToolsRevision = platform != null ? platform.getSdkData().getPlatformToolsRevision() : -1;
            if (platformToolsRevision < 0 || platformToolsRevision > 7) {
                String resCacheDirOsPath = AndroidCompileUtil.findResourcesCacheDirectory(module, false, context);
                if (resCacheDirOsPath != null) {
                    result.add(resCacheDirOsPath);
                } else {
                    LOG.info("PNG cache not found for module " + module.getName());
                }
            }
        }
        if ((resourcesDir = AndroidAptCompiler.getResourceDirForApkCompiler(facet)) != null) {
            result.add(resourcesDir.getPath());
        }
    }

    @Nullable
    public static String findResourcesCacheDirectory(@NotNull Module module, boolean createIfNotFound, @Nullable CompileContext context) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidCompileUtil", "findResourcesCacheDirectory"));
        }
        Project project = module.getProject();
        CompilerProjectExtension extension = CompilerProjectExtension.getInstance((Project)project);
        if (extension == null) {
            if (context != null) {
                context.addMessage(CompilerMessageCategory.ERROR, "Cannot get compiler settings for project " + project.getName(), null, -1, -1);
            }
            return null;
        }
        String projectOutputDirUrl = extension.getCompilerOutputUrl();
        if (projectOutputDirUrl == null) {
            if (context != null) {
                context.addMessage(CompilerMessageCategory.ERROR, "Cannot find output directory for project " + project.getName(), null, -1, -1);
            }
            return null;
        }
        String pngCacheDirPath = VfsUtil.urlToPath((String)projectOutputDirUrl) + '/' + RESOURCES_CACHE_DIR_NAME + '/' + module.getName();
        String pngCacheDirOsPath = FileUtil.toSystemDependentName((String)pngCacheDirPath);
        File pngCacheDir = new File(pngCacheDirOsPath);
        if (pngCacheDir.exists()) {
            if (pngCacheDir.isDirectory()) {
                return pngCacheDirOsPath;
            }
            if (context != null) {
                context.addMessage(CompilerMessageCategory.ERROR, "Cannot create directory " + pngCacheDirOsPath + " because file already exists", null, -1, -1);
            }
            return null;
        }
        if (!createIfNotFound) {
            return null;
        }
        if (!pngCacheDir.mkdirs()) {
            if (context != null) {
                context.addMessage(CompilerMessageCategory.ERROR, "Cannot create directory " + pngCacheDirOsPath, null, -1, -1);
            }
            return null;
        }
        return pngCacheDirOsPath;
    }

    public static boolean isFullBuild(@NotNull CompileContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidCompileUtil", "isFullBuild"));
        }
        return AndroidCompileUtil.isFullBuild(context.getCompileScope());
    }

    public static boolean isFullBuild(@NotNull CompileScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidCompileUtil", "isFullBuild"));
        }
        RunConfiguration c = CompileStepBeforeRun.getRunConfiguration((CompileScope)scope);
        return c == null || !AndroidCommonUtils.isTestConfiguration((String)c.getType().getId());
    }

    public static boolean isReleaseBuild(@NotNull CompileContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidCompileUtil", "isReleaseBuild"));
        }
        Boolean value = (Boolean)context.getCompileScope().getUserData(RELEASE_BUILD_KEY);
        if (value != null && value.booleanValue()) {
            return true;
        }
        Project project = context.getProject();
        Set artifacts = ArtifactCompileScope.getArtifactsToBuild((Project)project, (CompileScope)context.getCompileScope(), (boolean)false);
        if (artifacts != null) {
            for (Artifact artifact : artifacts) {
                AndroidArtifactSigningMode signingMode;
                ArtifactProperties properties = artifact.getProperties((ArtifactPropertiesProvider)AndroidArtifactPropertiesProvider.getInstance());
                if (!(properties instanceof AndroidApplicationArtifactProperties) || (signingMode = ((AndroidApplicationArtifactProperties)properties).getSigningMode()) == AndroidArtifactSigningMode.DEBUG || signingMode == AndroidArtifactSigningMode.DEBUG_WITH_CUSTOM_CERTIFICATE) continue;
                return true;
            }
        }
        return false;
    }

    public static void setReleaseBuild(@NotNull CompileScope compileScope) {
        if (compileScope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidCompileUtil", "setReleaseBuild"));
        }
        compileScope.putUserData(RELEASE_BUILD_KEY, (Object)Boolean.TRUE);
    }

    public static boolean createGenModulesAndSourceRoots(@NotNull AndroidFacet facet, @NotNull ModifiableRootModel model) {
        String renderscriptGenRootPath;
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidCompileUtil", "createGenModulesAndSourceRoots"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/compiler/AndroidCompileUtil", "createGenModulesAndSourceRoots"));
        }
        if (facet.isGradleProject() || !facet.getProperties().ENABLE_SOURCES_AUTOGENERATION) {
            return false;
        }
        Module module = facet.getModule();
        GlobalSearchScope moduleScope = facet.getModule().getModuleScope();
        Ref modelChangedFlag = Ref.create((Object)false);
        if (facet.isLibraryProject()) {
            AndroidCompileUtil.removeGenModule(model, (Ref<Boolean>)modelChangedFlag);
        }
        HashSet genRootsToCreate = new HashSet();
        HashSet genRootsToInit = new HashSet();
        String buildConfigGenRootPath = AndroidRootUtil.getBuildconfigGenSourceRootPath(facet);
        if (buildConfigGenRootPath != null) {
            genRootsToCreate.add(buildConfigGenRootPath);
        }
        if ((renderscriptGenRootPath = AndroidRootUtil.getRenderscriptGenSourceRootPath(facet)) != null) {
            boolean createIfNotExist = FileTypeIndex.getFiles((FileType)AndroidRenderscriptFileType.INSTANCE, (GlobalSearchScope)moduleScope).size() > 0;
            (createIfNotExist ? genRootsToCreate : genRootsToInit).add(renderscriptGenRootPath);
        }
        if (AndroidAptCompiler.isToCompileModule(module, (AndroidFacetConfiguration)facet.getConfiguration())) {
            String aptGenRootPath = AndroidRootUtil.getAptGenSourceRootPath(facet);
            if (aptGenRootPath != null) {
                genRootsToCreate.add(aptGenRootPath);
            }
        } else {
            VirtualFile aptSourceRoot = AndroidCompileUtil.initializeGenSourceRoot(model, AndroidRootUtil.getAptGenSourceRootPath(facet), true, false, (Ref<Boolean>)modelChangedFlag);
            if (aptSourceRoot != null) {
                AndroidCompileUtil.excludeAllBuildConfigsFromCompilation(facet, aptSourceRoot);
            }
            AndroidCompileUtil.includeAaptGenSourceRootToCompilation(facet);
        }
        String aidlGenRootPath = AndroidRootUtil.getAidlGenSourceRootPath(facet);
        if (aidlGenRootPath != null) {
            boolean createIfNotExist = FileTypeIndex.getFiles((FileType)AndroidIdlFileType.ourFileType, (GlobalSearchScope)moduleScope).size() > 0;
            (createIfNotExist ? genRootsToCreate : genRootsToInit).add(aidlGenRootPath);
        }
        genRootsToInit.addAll(genRootsToCreate);
        for (String genRootPath : genRootsToInit) {
            AndroidCompileUtil.initializeGenSourceRoot(model, genRootPath, genRootsToCreate.contains(genRootPath), true, (Ref<Boolean>)modelChangedFlag);
        }
        return (Boolean)modelChangedFlag.get();
    }

    private static void excludeAllBuildConfigsFromCompilation(AndroidFacet facet, VirtualFile sourceRoot) {
        String aPackage;
        Module module = facet.getModule();
        Project project = module.getProject();
        HashSet packages = new HashSet();
        Manifest manifest = facet.getManifest();
        String string = aPackage = manifest != null ? manifest.getPackage().getStringValue() : null;
        if (aPackage != null) {
            packages.add(aPackage);
        }
        packages.addAll(AndroidUtils.getDepLibsPackages(module));
        for (String p : packages) {
            AndroidCompileUtil.excludeFromCompilation(project, sourceRoot, p);
        }
    }

    private static void includeAaptGenSourceRootToCompilation(AndroidFacet facet) {
        Project project = facet.getModule().getProject();
        ExcludedEntriesConfiguration configuration = ((CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)project)).getExcludedEntriesConfiguration();
        ExcludeEntryDescription[] descriptions = configuration.getExcludeEntryDescriptions();
        configuration.removeAllExcludeEntryDescriptions();
        for (ExcludeEntryDescription description : descriptions) {
            VirtualFile vFile = description.getVirtualFile();
            if (Comparing.equal((Object)vFile, (Object)AndroidRootUtil.getAaptGenDir(facet))) continue;
            configuration.addExcludeEntryDescription(description);
        }
    }

    @Nullable
    private static VirtualFile initializeGenSourceRoot(@NotNull ModifiableRootModel model, @Nullable String sourceRootPath, boolean createIfNotExist, boolean excludeInNonExternalMode, @NotNull Ref<Boolean> modelChangedFlag) {
        Module module;
        CompilerWorkspaceConfiguration config;
        VirtualFile root;
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidCompileUtil", "initializeGenSourceRoot"));
        }
        if (modelChangedFlag == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/android/compiler/AndroidCompileUtil", "initializeGenSourceRoot"));
        }
        if (sourceRootPath == null) {
            return null;
        }
        VirtualFile sourceRoot = null;
        if (createIfNotExist && (root = AndroidCompileUtil.createSourceRootIfNotExist(sourceRootPath, model, modelChangedFlag)) != null) {
            sourceRoot = root;
        }
        if (sourceRoot == null) {
            sourceRoot = LocalFileSystem.getInstance().findFileByPath(sourceRootPath);
        }
        if (sourceRoot != null && excludeInNonExternalMode && !(config = CompilerWorkspaceConfiguration.getInstance((Project)(module = model.getModule()).getProject())).useOutOfProcessBuild()) {
            AndroidCompileUtil.excludeFromCompilation(module.getProject(), sourceRoot);
        }
        return sourceRoot;
    }

    @NotNull
    public static String[] toOsPaths(@NotNull VirtualFile[] classFilesDirs) {
        if (classFilesDirs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidCompileUtil", "toOsPaths"));
        }
        String[] classFilesDirOsPaths = new String[classFilesDirs.length];
        for (int i = 0; i < classFilesDirs.length; ++i) {
            classFilesDirOsPaths[i] = FileUtil.toSystemDependentName((String)classFilesDirs[i].getPath());
        }
        if (classFilesDirOsPaths == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidCompileUtil", "toOsPaths"));
        }
        return classFilesDirOsPaths;
    }

    @NotNull
    public static Map<CompilerMessageCategory, List<String>> execute(String ... argv) throws IOException {
        assert (!ApplicationManager.getApplication().isDispatchThread());
        Map messages = AndroidExecutionUtil.doExecute((String[])argv);
        Map<CompilerMessageCategory, List<String>> map = AndroidCompileUtil.toCompilerMessageCategoryKeys(messages);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidCompileUtil", "execute"));
        }
        return map;
    }

    public static String getApkName(Module module) {
        return module.getName() + ".apk";
    }

    @Nullable
    public static String getOutputPackage(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidCompileUtil", "getOutputPackage"));
        }
        VirtualFile compilerOutput = CompilerModuleExtension.getInstance((Module)module).getCompilerOutputPath();
        if (compilerOutput == null) {
            return null;
        }
        return new File(compilerOutput.getPath(), AndroidCompileUtil.getApkName(module)).getPath();
    }

    public static boolean isExcludedFromCompilation(@NotNull File file, @Nullable Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidCompileUtil", "isExcludedFromCompilation"));
        }
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByIoFile(file);
        return vFile != null && AndroidCompileUtil.isExcludedFromCompilation(vFile, project);
    }

    public static boolean isExcludedFromCompilation(VirtualFile child, @Nullable Project project) {
        CompilerManager compilerManager;
        CompilerManager compilerManager2 = compilerManager = project != null ? CompilerManager.getInstance((Project)project) : null;
        if (compilerManager == null) {
            return false;
        }
        if (!compilerManager.isExcludedFromCompilation(child)) {
            return false;
        }
        Module module = ModuleUtil.findModuleForFile((VirtualFile)child, (Project)project);
        if (module == null) {
            return true;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null || !facet.isLibraryProject()) {
            return true;
        }
        AndroidPlatform platform = ((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidPlatform();
        if (platform == null) {
            return true;
        }
        return platform.getSdkData().getPlatformToolsRevision() > 7;
    }

    @Nullable
    public static ProguardRunningOptions getProguardConfigFilePathIfShouldRun(@NotNull AndroidFacet facet, CompileContext context) {
        String[] paths;
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidCompileUtil", "getProguardConfigFilePathIfShouldRun"));
        }
        String pathsStr = (String)context.getCompileScope().getUserData(AndroidProguardCompiler.PROGUARD_CFG_PATHS_KEY);
        if (pathsStr != null && (paths = pathsStr.split(File.pathSeparator)).length > 0) {
            return new ProguardRunningOptions(Arrays.asList(paths));
        }
        AndroidPlatform platform = AndroidPlatform.getInstance(facet.getModule());
        String sdkHomePath = platform != null ? FileUtil.toCanonicalPath((String)platform.getSdkData().getPath()) : null;
        Project project = context.getProject();
        Set artifacts = ArtifactCompileScope.getArtifactsToBuild((Project)project, (CompileScope)context.getCompileScope(), (boolean)false);
        for (Artifact artifact : artifacts) {
            AndroidApplicationArtifactProperties p;
            ArtifactProperties properties;
            if (!(artifact.getArtifactType() instanceof AndroidApplicationArtifactType) || !facet.equals((Object)AndroidArtifactUtil.getPackagedFacet(project, artifact)) || !((properties = artifact.getProperties((ArtifactPropertiesProvider)AndroidArtifactPropertiesProvider.getInstance())) instanceof AndroidApplicationArtifactProperties) || !(p = (AndroidApplicationArtifactProperties)properties).isRunProGuard()) continue;
            List<String> paths2 = AndroidUtils.urlsToOsPaths(p.getProGuardCfgFiles(), sdkHomePath);
            return new ProguardRunningOptions(paths2);
        }
        AndroidFacetConfiguration configuration = (AndroidFacetConfiguration)facet.getConfiguration();
        JpsAndroidModuleProperties properties = configuration.getState();
        if (properties != null && properties.RUN_PROGUARD) {
            List urls = properties.myProGuardCfgFiles;
            List<String> paths3 = AndroidUtils.urlsToOsPaths(urls, sdkHomePath);
            return new ProguardRunningOptions(paths3);
        }
        return null;
    }

    @Nullable
    public static Module findCircularDependencyOnLibraryWithSamePackage(@NotNull AndroidFacet facet) {
        String aPackage;
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidCompileUtil", "findCircularDependencyOnLibraryWithSamePackage"));
        }
        Manifest manifest = facet.getManifest();
        String string = aPackage = manifest != null ? (String)manifest.getPackage().getValue() : null;
        if (aPackage == null) {
            return null;
        }
        for (AndroidFacet depFacet : AndroidUtils.getAllAndroidDependencies(facet.getModule(), true)) {
            List<AndroidFacet> depDependencies;
            Manifest depManifest = depFacet.getManifest();
            String depPackage = depManifest != null ? (String)depManifest.getPackage().getValue() : null;
            if (!aPackage.equals(depPackage) || !(depDependencies = AndroidUtils.getAllAndroidDependencies(depFacet.getModule(), false)).contains((Object)facet)) continue;
            return depFacet.getModule();
        }
        return null;
    }

    @NotNull
    public static String[] getLibPackages(@NotNull Module module, @NotNull String packageName) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidCompileUtil", "getLibPackages"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/compiler/AndroidCompileUtil", "getLibPackages"));
        }
        HashSet packageSet = new HashSet();
        packageSet.add(packageName);
        ArrayList<String> result = new ArrayList<String>();
        for (String libPackage : AndroidUtils.getDepLibsPackages(module)) {
            if (!packageSet.add(libPackage)) continue;
            result.add(libPackage);
        }
        String[] stringArray = ArrayUtil.toStringArray(result);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidCompileUtil", "getLibPackages"));
        }
        return stringArray;
    }

    public static boolean isLibraryWithBadCircularDependency(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidCompileUtil", "isLibraryWithBadCircularDependency"));
        }
        if (!facet.isLibraryProject()) {
            return false;
        }
        List<AndroidFacet> dependencies = AndroidUtils.getAllAndroidDependencies(facet.getModule(), false);
        Manifest manifest = facet.getManifest();
        if (manifest == null) {
            return false;
        }
        String aPackage = (String)manifest.getPackage().getValue();
        if (aPackage == null || aPackage.length() == 0) {
            return false;
        }
        for (AndroidFacet depFacet : dependencies) {
            List<AndroidFacet> depDependencies = AndroidUtils.getAllAndroidDependencies(depFacet.getModule(), true);
            if (!depDependencies.contains((Object)facet) || !dependencies.contains((Object)depFacet) || depFacet.getModule().getName().compareTo(facet.getModule().getName()) >= 0 && depFacet.isLibraryProject()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static String getUnsignedApkPath(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidCompileUtil", "getUnsignedApkPath"));
        }
        boolean useCompileServer = CompilerWorkspaceConfiguration.getInstance((Project)facet.getModule().getProject()).useOutOfProcessBuild();
        String apkPath = AndroidRootUtil.getApkPath(facet);
        if (apkPath != null) {
            return useCompileServer ? apkPath : AndroidCommonUtils.addSuffixToFileName((String)apkPath, (String)UNSIGNED_SUFFIX);
        }
        return null;
    }

    @Nullable
    public static <T> T handleExceptionError(@NotNull CompileContext context, @NotNull String messagePrefix, @NotNull Exception e) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidCompileUtil", "handleExceptionError"));
        }
        if (messagePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/compiler/AndroidCompileUtil", "handleExceptionError"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/compiler/AndroidCompileUtil", "handleExceptionError"));
        }
        AndroidCompileUtil.reportException(context, messagePrefix, e);
        return null;
    }

    public static void reportException(@NotNull CompileContext context, @NotNull String messagePrefix, @NotNull Exception e) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidCompileUtil", "reportException"));
        }
        if (messagePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/compiler/AndroidCompileUtil", "reportException"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/compiler/AndroidCompileUtil", "reportException"));
        }
        context.addMessage(CompilerMessageCategory.ERROR, messagePrefix + e.getClass().getSimpleName() + ": " + e.getMessage(), null, -1, -1);
    }

    public static void markDirtyAndRefresh(VirtualFile f, boolean recursively) {
        AndroidCompileUtil.markDirty(f, recursively);
        f.refresh(false, recursively);
    }

    public static void markDirty(VirtualFile f, boolean recursively) {
        if (f instanceof NewVirtualFile) {
            NewVirtualFile newF = (NewVirtualFile)f;
            if (recursively) {
                newF.markDirtyRecursively();
            } else {
                newF.markDirty();
            }
        }
    }

    @Nullable
    public static String getAaptManifestPackage(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidCompileUtil", "getAaptManifestPackage"));
        }
        if (facet.getProperties().USE_CUSTOM_MANIFEST_PACKAGE) {
            return facet.getProperties().CUSTOM_MANIFEST_PACKAGE;
        }
        Manifest manifest = facet.getManifest();
        return manifest != null ? manifest.getPackage().getStringValue() : null;
    }

    public static void createGenModulesAndSourceRoots(@NotNull Project project, final @NotNull Collection<AndroidFacet> facets) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidCompileUtil", "createGenModulesAndSourceRoots"));
        }
        if (facets == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/compiler/AndroidCompileUtil", "createGenModulesAndSourceRoots"));
        }
        if (project.isDisposed()) {
            return;
        }
        final ModifiableModuleModel moduleModel = ModuleManager.getInstance((Project)project).getModifiableModel();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                ArrayList<ModifiableRootModel> modelsToCommit = new ArrayList<ModifiableRootModel>();
                for (AndroidFacet facet : facets) {
                    Module module;
                    if (facet.isGradleProject() || (module = facet.getModule()).isDisposed()) continue;
                    ModifiableRootModel model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
                    if (AndroidCompileUtil.createGenModulesAndSourceRoots(facet, model)) {
                        modelsToCommit.add(model);
                        continue;
                    }
                    model.dispose();
                }
                if (modelsToCommit.size() == 0) {
                    return;
                }
                ModifiableModelCommitter.multiCommit((ModifiableRootModel[])modelsToCommit.toArray(new ModifiableRootModel[modelsToCommit.size()]), (ModifiableModuleModel)moduleModel);
            }
        });
    }
}

