/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler;

import com.android.sdklib.internal.build.BuildConfigGenerator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.GeneratingCompiler;
import com.intellij.openapi.compiler.SourceGeneratingCompiler;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xml.NanoXmlUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidBuildConfigGeneratingCompiler
implements SourceGeneratingCompiler {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.compiler.AndroidBuildConfigGeneratingCompiler");
    private static final String MANIFEST_LOCATION = NanoXmlUtil.createLocation((String[])new String[]{"manifest"});

    @Nullable
    public VirtualFile getPresentableFile(CompileContext context, Module module, VirtualFile outputRoot, VirtualFile generatedFile) {
        return null;
    }

    public GeneratingCompiler.GenerationItem[] getGenerationItems(final CompileContext context) {
        return (GeneratingCompiler.GenerationItem[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<GeneratingCompiler.GenerationItem[]>(){

            public GeneratingCompiler.GenerationItem[] compute() {
                ArrayList<MyGenerationItem> result = new ArrayList<MyGenerationItem>();
                for (Module module : ModuleManager.getInstance((Project)context.getProject()).getModules()) {
                    String packageName;
                    AndroidFacet facet = AndroidFacet.getInstance(module);
                    if (facet == null || AndroidCompileUtil.isLibraryWithBadCircularDependency(facet)) continue;
                    VirtualFile manifestFile = AndroidRootUtil.getManifestFileForCompiler(facet);
                    if (manifestFile == null) {
                        context.addMessage(CompilerMessageCategory.ERROR, AndroidBundle.message("android.compilation.error.manifest.not.found", module.getName()), null, -1, -1);
                        continue;
                    }
                    try {
                        packageName = AndroidBuildConfigGeneratingCompiler.parsePackageName(manifestFile);
                    }
                    catch (IOException e) {
                        context.addMessage(CompilerMessageCategory.ERROR, "I/O error: " + e.getMessage(), null, -1, -1);
                        continue;
                    }
                    if (packageName != null) {
                        packageName = packageName.trim();
                    }
                    if (packageName == null || packageName.length() <= 0) {
                        context.addMessage(CompilerMessageCategory.ERROR, AndroidBundle.message("package.not.found.error", new Object[0]), manifestFile.getUrl(), -1, -1);
                        continue;
                    }
                    boolean debug = !AndroidCompileUtil.isReleaseBuild(context);
                    result.add(new MyGenerationItem(module, packageName, debug));
                    for (String libPackage : AndroidCompileUtil.getLibPackages(module, packageName)) {
                        result.add(new MyGenerationItem(module, libPackage, debug));
                    }
                }
                return result.toArray(new GeneratingCompiler.GenerationItem[result.size()]);
            }
        });
    }

    public GeneratingCompiler.GenerationItem[] generate(CompileContext context, GeneratingCompiler.GenerationItem[] items, VirtualFile outputRootDirectory) {
        if (items == null || items.length == 0) {
            return new GeneratingCompiler.GenerationItem[0];
        }
        context.getProgressIndicator().setText("Generating BuildConfig.java...");
        String genFolderOsPath = FileUtil.toSystemDependentName((String)outputRootDirectory.getPath());
        ArrayList<MyGenerationItem> result = new ArrayList<MyGenerationItem>();
        for (GeneratingCompiler.GenerationItem item : items) {
            MyGenerationItem genItem = (MyGenerationItem)item;
            BuildConfigGenerator generator = new BuildConfigGenerator(genFolderOsPath, genItem.myPackage, genItem.myDebug);
            try {
                generator.generate();
                result.add(genItem);
            }
            catch (IOException e) {
                context.addMessage(CompilerMessageCategory.ERROR, "I/O error: " + e.getMessage(), null, -1, -1);
                LOG.info((Throwable)e);
            }
        }
        if (result.size() > 0) {
            AndroidCompileUtil.markDirtyAndRefresh(outputRootDirectory, true);
        }
        return result.toArray(new GeneratingCompiler.GenerationItem[result.size()]);
    }

    @Nullable
    private static String parsePackageName(@NotNull VirtualFile manifestFile) throws IOException {
        if (manifestFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidBuildConfigGeneratingCompiler", "parsePackageName"));
        }
        final Ref packageNameRef = Ref.create(null);
        NanoXmlUtil.parse((InputStream)manifestFile.getInputStream(), (IXMLBuilder)new NanoXmlUtil.BaseXmlBuilder(){

            public void addAttribute(String key, String nsPrefix, String nsURI, String value, String type) throws Exception {
                super.addAttribute(key, nsPrefix, nsURI, value, type);
                if ("package".equals(key) && MANIFEST_LOCATION.equals(this.getLocation())) {
                    packageNameRef.set((Object)value);
                    2.stop();
                }
            }

            public void elementAttributesProcessed(String name, String nsPrefix, String nsURI) throws Exception {
                super.elementAttributesProcessed(name, nsPrefix, nsURI);
                2.stop();
            }
        });
        return (String)packageNameRef.get();
    }

    @NotNull
    public String getDescription() {
        if ("Android BuildConfig Generator" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidBuildConfigGeneratingCompiler", "getDescription"));
        }
        return "Android BuildConfig Generator";
    }

    public boolean validateConfiguration(CompileScope scope) {
        return true;
    }

    public ValidityState createValidityState(DataInput in) throws IOException {
        return new MyValidityState(in);
    }

    private static class MyValidityState
    implements ValidityState {
        private final String myPackage;
        private boolean myDebug;

        private MyValidityState(DataInput in) throws IOException {
            this.myPackage = in.readUTF();
            this.myDebug = in.readBoolean();
        }

        private MyValidityState(@NotNull String aPackage, boolean debug) {
            if (aPackage == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidBuildConfigGeneratingCompiler$MyValidityState", "<init>"));
            }
            this.myPackage = aPackage;
            this.myDebug = debug;
        }

        public boolean equalsTo(ValidityState otherState) {
            if (!(otherState instanceof MyValidityState)) {
                return false;
            }
            MyValidityState otherState1 = (MyValidityState)otherState;
            return otherState1.myPackage.equals(this.myPackage) && otherState1.myDebug == this.myDebug;
        }

        public void save(DataOutput out) throws IOException {
            out.writeUTF(this.myPackage);
            out.writeBoolean(this.myDebug);
        }
    }

    private static class MyGenerationItem
    implements GeneratingCompiler.GenerationItem {
        final Module myModule;
        final String myPackage;
        final boolean myDebug;

        private MyGenerationItem(@NotNull Module module, @NotNull String aPackage, boolean debug) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidBuildConfigGeneratingCompiler$MyGenerationItem", "<init>"));
            }
            if (aPackage == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/compiler/AndroidBuildConfigGeneratingCompiler$MyGenerationItem", "<init>"));
            }
            this.myModule = module;
            this.myPackage = aPackage;
            this.myDebug = debug;
        }

        public String getPath() {
            return this.myPackage.replace('.', '/') + '/' + "BuildConfig.java";
        }

        public ValidityState getValidityState() {
            return new MyValidityState(this.myPackage, this.myDebug);
        }

        public Module getModule() {
            return this.myModule;
        }

        public boolean isTestSource() {
            return false;
        }
    }
}

