/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler;

import com.android.SdkConstants;
import com.android.sdklib.IAndroidTarget;
import com.intellij.compiler.CompilerWorkspaceConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.GeneratingCompiler;
import com.intellij.openapi.compiler.SourceGeneratingCompiler;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.compiler.AndroidDexCompiler;
import org.jetbrains.android.compiler.ResourceNamesValidityState;
import org.jetbrains.android.compiler.tools.AndroidApt;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.maven.AndroidMavenUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.android.util.JavaFilesFilter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidAptCompiler
implements SourceGeneratingCompiler {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.compiler.AndroidAptCompiler");
    private static final GeneratingCompiler.GenerationItem[] EMPTY_GENERATION_ITEM_ARRAY = new GeneratingCompiler.GenerationItem[0];

    @Nullable
    public VirtualFile getPresentableFile(CompileContext context, Module module, VirtualFile outputRoot, VirtualFile generatedFile) {
        return null;
    }

    public static boolean isToCompileModule(Module module, AndroidFacetConfiguration configuration) {
        if (CompilerWorkspaceConfiguration.getInstance((Project)module.getProject()).useOutOfProcessBuild()) {
            return true;
        }
        return !configuration.getState().RUN_PROCESS_RESOURCES_MAVEN_TASK || !AndroidMavenUtil.isMavenizedModule(module);
    }

    public GeneratingCompiler.GenerationItem[] getGenerationItems(CompileContext context) {
        return (GeneratingCompiler.GenerationItem[])ApplicationManager.getApplication().runReadAction((Computable)new PrepareAction(context));
    }

    public GeneratingCompiler.GenerationItem[] generate(CompileContext context, GeneratingCompiler.GenerationItem[] items, VirtualFile outputRootDirectory) {
        if (items != null && items.length > 0) {
            context.getProgressIndicator().setText(AndroidBundle.message("android.compile.messages.generating.r.java", new Object[0]));
            if (!context.getProject().isDisposed()) {
                return AndroidAptCompiler.doGenerate(context, items, outputRootDirectory);
            }
        }
        return EMPTY_GENERATION_ITEM_ARRAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static GeneratingCompiler.GenerationItem[] doGenerate(final CompileContext context, GeneratingCompiler.GenerationItem[] items, VirtualFile outputRootDirectory) {
        if (items == null || items.length == 0) {
            return EMPTY_GENERATION_ITEM_ARRAY;
        }
        String genRootPath = FileUtil.toSystemDependentName((String)outputRootDirectory.getPath());
        File genRootDir = new File(genRootPath);
        ArrayList<AptGenerationItem> results = new ArrayList<AptGenerationItem>(items.length);
        boolean toRefresh = false;
        for (GeneratingCompiler.GenerationItem item : items) {
            if (!(item instanceof AptGenerationItem)) continue;
            AptGenerationItem aptItem = (AptGenerationItem)item;
            if (!AndroidCompileUtil.isModuleAffected(context, aptItem.myModule)) continue;
            File tmpOutputDir = null;
            try {
                tmpOutputDir = FileUtil.createTempDirectory((String)"android_apt_output", (String)"tmp");
                Map<CompilerMessageCategory, List<String>> messages = AndroidCompileUtil.toCompilerMessageCategoryKeys(AndroidApt.compile((IAndroidTarget)aptItem.myAndroidTarget, (int)aptItem.myPlatformToolsRevision, (String)aptItem.myManifestFile.getPath(), (String)aptItem.myPackage, (String)tmpOutputDir.getPath(), (String[])aptItem.myResourcesPaths, (String[])aptItem.myLibraryPackages, (boolean)aptItem.myNonConstantFields, (String)aptItem.myProguardCfgOutputFileOsPath));
                if (aptItem.myProguardCfgOutputFileOsPath != null) {
                    LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(aptItem.myProguardCfgOutputFileOsPath));
                }
                toRefresh = true;
                AndroidCompileUtil.addMessages(context, messages, aptItem.myModule);
                if (!messages.get(CompilerMessageCategory.ERROR).isEmpty()) continue;
                if (!AndroidCommonUtils.directoriesContainSameContent((File)tmpOutputDir, (File)genRootDir, (FileFilter)JavaFilesFilter.INSTANCE)) {
                    if (genRootDir.exists() && !FileUtil.delete((File)genRootDir)) {
                        context.addMessage(CompilerMessageCategory.ERROR, "Cannot delete directory " + genRootPath, null, -1, -1);
                        continue;
                    }
                    File parent = genRootDir.getParentFile();
                    if (parent != null && !parent.exists() && !parent.mkdirs()) {
                        context.addMessage(CompilerMessageCategory.ERROR, "Cannot create directory " + parent.getPath(), null, -1, -1);
                        continue;
                    }
                    FileUtil.copyDir((File)tmpOutputDir, (File)genRootDir);
                    AndroidCompileUtil.markDirty(outputRootDirectory, true);
                }
                results.add(aptItem);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        if (context.getProject().isDisposed()) {
                            return;
                        }
                        context.addMessage(CompilerMessageCategory.ERROR, "I/O error: " + e.getMessage(), null, -1, -1);
                    }
                });
            }
            finally {
                if (tmpOutputDir != null) {
                    FileUtil.delete((File)tmpOutputDir);
                }
            }
        }
        if (toRefresh) {
            outputRootDirectory.refresh(false, true);
        }
        return results.toArray(new GeneratingCompiler.GenerationItem[results.size()]);
    }

    @NotNull
    public String getDescription() {
        String string = FileUtil.getNameWithoutExtension((String)SdkConstants.FN_AAPT);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidAptCompiler", "getDescription"));
        }
        return string;
    }

    public boolean validateConfiguration(CompileScope scope) {
        return true;
    }

    public ValidityState createValidityState(DataInput is) throws IOException {
        return new MyValidityState(is);
    }

    @Nullable
    public static VirtualFile getResourceDirForApkCompiler(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidAptCompiler", "getResourceDirForApkCompiler"));
        }
        return facet.getProperties().USE_CUSTOM_APK_RESOURCE_FOLDER ? AndroidAptCompiler.getCustomResourceDirForApt(facet) : AndroidRootUtil.getResourceDir(facet);
    }

    @Nullable
    public static VirtualFile getCustomResourceDirForApt(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidAptCompiler", "getCustomResourceDirForApt"));
        }
        return AndroidRootUtil.getFileByRelativeModulePath(facet.getModule(), facet.getProperties().CUSTOM_APK_RESOURCE_FOLDER, false);
    }

    private static class MyValidityState
    extends ResourceNamesValidityState {
        private final String myCustomGenPathR;
        private final Set<String> myNonExistingFiles;
        private final int myPlatformToolsRevision;
        private final boolean myNonConstantFields;
        private final String myProguardCfgOutputFileOsPath;

        MyValidityState(@NotNull Module module, @NotNull Set<String> nonExistingFiles, int platformToolsRevision, boolean nonConstantFields, @NotNull String proguardCfgOutputFileOsPath) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidAptCompiler$MyValidityState", "<init>"));
            }
            if (nonExistingFiles == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/compiler/AndroidAptCompiler$MyValidityState", "<init>"));
            }
            if (proguardCfgOutputFileOsPath == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/android/compiler/AndroidAptCompiler$MyValidityState", "<init>"));
            }
            super(module);
            this.myNonExistingFiles = nonExistingFiles;
            this.myPlatformToolsRevision = platformToolsRevision;
            this.myNonConstantFields = nonConstantFields;
            this.myProguardCfgOutputFileOsPath = proguardCfgOutputFileOsPath;
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null) {
                this.myCustomGenPathR = "";
                return;
            }
            AndroidFacetConfiguration configuration = (AndroidFacetConfiguration)facet.getConfiguration();
            this.myCustomGenPathR = configuration.getState().GEN_FOLDER_RELATIVE_PATH_APT;
        }

        public MyValidityState(DataInput is) throws IOException {
            super(is);
            String path = is.readUTF();
            this.myCustomGenPathR = path != null ? path : "";
            this.myNonExistingFiles = Collections.emptySet();
            this.myPlatformToolsRevision = is.readInt();
            this.myNonConstantFields = is.readBoolean();
            this.myProguardCfgOutputFileOsPath = is.readUTF();
        }

        @Override
        public boolean equalsTo(ValidityState otherState) {
            if (!(otherState instanceof MyValidityState)) {
                return false;
            }
            MyValidityState otherState1 = (MyValidityState)otherState;
            if (!((Object)otherState1.myNonExistingFiles).equals(this.myNonExistingFiles)) {
                return false;
            }
            if (this.myPlatformToolsRevision != otherState1.myPlatformToolsRevision) {
                return false;
            }
            if (this.myNonConstantFields != otherState1.myNonConstantFields) {
                return false;
            }
            if (!Comparing.equal((String)this.myProguardCfgOutputFileOsPath, (String)otherState1.myProguardCfgOutputFileOsPath)) {
                return false;
            }
            if (!super.equalsTo(otherState)) {
                return false;
            }
            return Comparing.equal((String)this.myCustomGenPathR, (String)otherState1.myCustomGenPathR);
        }

        @Override
        public void save(DataOutput os) throws IOException {
            super.save(os);
            os.writeUTF(this.myCustomGenPathR);
            os.writeInt(this.myPlatformToolsRevision);
            os.writeBoolean(this.myNonConstantFields);
            os.writeUTF(this.myProguardCfgOutputFileOsPath);
        }
    }

    private static final class PrepareAction
    implements Computable<GeneratingCompiler.GenerationItem[]> {
        private final CompileContext myContext;

        public PrepareAction(CompileContext context) {
            this.myContext = context;
        }

        public GeneratingCompiler.GenerationItem[] compute() {
            if (this.myContext.getProject().isDisposed()) {
                return EMPTY_GENERATION_ITEM_ARRAY;
            }
            Module[] modules = ModuleManager.getInstance((Project)this.myContext.getProject()).getModules();
            ArrayList<AptGenerationItem> items = new ArrayList<AptGenerationItem>();
            for (Module module : modules) {
                AndroidFacetConfiguration configuration;
                AndroidFacet facet = AndroidFacet.getInstance(module);
                if (facet == null || !AndroidAptCompiler.isToCompileModule(module, configuration = (AndroidFacetConfiguration)facet.getConfiguration()) || AndroidCompileUtil.isLibraryWithBadCircularDependency(facet)) continue;
                AndroidPlatform platform = configuration.getAndroidPlatform();
                if (platform == null) {
                    this.myContext.addMessage(CompilerMessageCategory.ERROR, AndroidBundle.message("android.compilation.error.specify.platform", module.getName()), null, -1, -1);
                    continue;
                }
                IAndroidTarget target = platform.getTarget();
                int platformToolsRevision = platform.getSdkData().getPlatformToolsRevision();
                String[] resPaths = AndroidCompileUtil.collectResourceDirs(facet, false, this.myContext);
                if (resPaths.length <= 0) continue;
                VirtualFile manifestFile = AndroidRootUtil.getManifestFileForCompiler(facet);
                if (manifestFile == null) {
                    this.myContext.addMessage(CompilerMessageCategory.ERROR, AndroidBundle.message("android.compilation.error.manifest.not.found", module.getName()), null, -1, -1);
                    continue;
                }
                Manifest manifest = AndroidUtils.loadDomElement(module, manifestFile, Manifest.class);
                if (manifest == null) {
                    this.myContext.addMessage(CompilerMessageCategory.ERROR, "Cannot parse file", manifestFile.getUrl(), -1, -1);
                    continue;
                }
                String packageName = (String)manifest.getPackage().getValue();
                if (packageName != null) {
                    packageName = packageName.trim();
                }
                if (packageName == null || packageName.length() <= 0) {
                    this.myContext.addMessage(CompilerMessageCategory.ERROR, AndroidBundle.message("package.not.found.error", new Object[0]), manifestFile.getUrl(), -1, -1);
                    continue;
                }
                if (!AndroidCommonUtils.contains2Identifiers((String)packageName)) {
                    String message = "[" + module.getName() + "] Package name must contain at least 2 segments";
                    this.myContext.addMessage(facet.isLibraryProject() ? CompilerMessageCategory.WARNING : CompilerMessageCategory.ERROR, message, manifestFile.getUrl(), -1, -1);
                    continue;
                }
                String[] libPackages = AndroidCompileUtil.getLibPackages(module, packageName);
                Module circularDepLibWithSamePackage = AndroidCompileUtil.findCircularDependencyOnLibraryWithSamePackage(facet);
                if (circularDepLibWithSamePackage != null && !facet.isLibraryProject()) {
                    this.myContext.addMessage(CompilerMessageCategory.WARNING, AndroidBundle.message("android.compilation.warning.circular.app.dependency", packageName, module.getName(), circularDepLibWithSamePackage.getName()), null, -1, -1);
                }
                boolean generateNonFinalFields = facet.isLibraryProject() || circularDepLibWithSamePackage != null;
                VirtualFile outputDirForDex = AndroidDexCompiler.getOutputDirectoryForDex(module);
                String proguardCfgOutputFileOsPath = AndroidCompileUtil.getProguardConfigFilePathIfShouldRun(facet, this.myContext) != null ? FileUtil.toSystemDependentName((String)(outputDirForDex.getPath() + '/' + "proguard.txt")) : null;
                items.add(new AptGenerationItem(module, manifestFile, resPaths, target, platformToolsRevision, packageName, libPackages, generateNonFinalFields, proguardCfgOutputFileOsPath));
            }
            return items.toArray(new GeneratingCompiler.GenerationItem[items.size()]);
        }
    }

    static final class AptGenerationItem
    implements GeneratingCompiler.GenerationItem {
        final Module myModule;
        final VirtualFile myManifestFile;
        final String[] myResourcesPaths;
        final IAndroidTarget myAndroidTarget;
        final String myPackage;
        final String[] myLibraryPackages;
        final boolean myNonConstantFields;
        final int myPlatformToolsRevision;
        private final MyValidityState myValidityState;
        private final String myProguardCfgOutputFileOsPath;

        private AptGenerationItem(@NotNull Module module, @NotNull VirtualFile manifestFile, @NotNull String[] resourcesPaths, @NotNull IAndroidTarget target, int platformToolsRevision, @NotNull String aPackage, @NotNull String[] libPackages, boolean nonConstantFields, @Nullable String proguardCfgOutputFileOsPath) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/compiler/AndroidAptCompiler$AptGenerationItem", "<init>"));
            }
            if (manifestFile == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/compiler/AndroidAptCompiler$AptGenerationItem", "<init>"));
            }
            if (resourcesPaths == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/compiler/AndroidAptCompiler$AptGenerationItem", "<init>"));
            }
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/android/compiler/AndroidAptCompiler$AptGenerationItem", "<init>"));
            }
            if (aPackage == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "org/jetbrains/android/compiler/AndroidAptCompiler$AptGenerationItem", "<init>"));
            }
            if (libPackages == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "6", "org/jetbrains/android/compiler/AndroidAptCompiler$AptGenerationItem", "<init>"));
            }
            this.myModule = module;
            this.myManifestFile = manifestFile;
            this.myResourcesPaths = resourcesPaths;
            this.myAndroidTarget = target;
            this.myPackage = aPackage;
            this.myLibraryPackages = libPackages;
            this.myNonConstantFields = nonConstantFields;
            this.myPlatformToolsRevision = platformToolsRevision;
            this.myProguardCfgOutputFileOsPath = proguardCfgOutputFileOsPath;
            this.myValidityState = new MyValidityState(this.myModule, Collections.<String>emptySet(), this.myPlatformToolsRevision, this.myNonConstantFields, proguardCfgOutputFileOsPath != null ? proguardCfgOutputFileOsPath : "");
        }

        public String getPath() {
            return "FAKE";
        }

        public ValidityState getValidityState() {
            return this.myValidityState;
        }

        public Module getModule() {
            return this.myModule;
        }

        public boolean isTestSource() {
            return false;
        }
    }
}

