/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.augment;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.android.augment.AndroidLightClassBase;
import org.jetbrains.annotations.NotNull;

abstract class AndroidLightClass
extends AndroidLightClassBase {
    private final PsiClass myContainingClass;
    protected final String myName;

    protected AndroidLightClass(@NotNull PsiClass context, @NotNull String name) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/augment/AndroidLightClass", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/augment/AndroidLightClass", "<init>"));
        }
        super(context.getManager());
        this.myContainingClass = context;
        this.myName = name;
    }

    public String toString() {
        return "AndroidRClass";
    }

    @Override
    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/augment/AndroidLightClass", "checkAdd"));
        }
        throw new IncorrectOperationException("Cannot add elements to R class");
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/augment/AndroidLightClass", "add"));
        }
        return this.myContainingClass.add(element);
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/augment/AndroidLightClass", "addBefore"));
        }
        return this.myContainingClass.addBefore(element, anchor);
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/augment/AndroidLightClass", "addAfter"));
        }
        return this.myContainingClass.addAfter(element, anchor);
    }

    public String getQualifiedName() {
        return this.myContainingClass.getQualifiedName() + '.' + this.myName;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiClass psiClass = this.myContainingClass;
        if (psiClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/augment/AndroidLightClass", "getNavigationElement"));
        }
        return psiClass;
    }

    public PsiClass getContainingClass() {
        return this.myContainingClass;
    }

    public String getName() {
        return this.myName;
    }

    public PsiElement getParent() {
        return this.myContainingClass;
    }
}

