/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import org.jetbrains.android.actions.AndroidRunSdkToolAction;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.annotations.NotNull;

public class AndroidRunHierarchyViewerAction
extends AndroidRunSdkToolAction {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.actions.AndroidRunHierarchyViewerAction");

    public AndroidRunHierarchyViewerAction() {
        super(AndroidBundle.message("android.launch.hierarchy.viewer.action", new Object[0]));
    }

    @Override
    protected void doRunTool(@NotNull Project project, @NotNull String sdkPath) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/actions/AndroidRunHierarchyViewerAction", "doRunTool"));
        }
        if (sdkPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/actions/AndroidRunHierarchyViewerAction", "doRunTool"));
        }
        String toolPath = sdkPath + File.separator + AndroidCommonUtils.toolPath((String)AndroidRunHierarchyViewerAction.getHierarchyViewerCmdName());
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setExePath(toolPath);
        LOG.info(commandLine.getCommandLineString());
        try {
            commandLine.createProcess();
        }
        catch (ExecutionException e) {
            LOG.info((Throwable)e);
        }
    }

    @NotNull
    private static String getHierarchyViewerCmdName() {
        String string = SystemInfo.isWindows ? "hierarchyviewer.bat" : "hierarchyviewer";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/AndroidRunHierarchyViewerAction", "getHierarchyViewerCmdName"));
        }
        return string;
    }
}

