/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.ddmlib.AndroidDebugBridge;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import org.jetbrains.android.actions.AndroidProcessChooserDialog;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.Nullable;

public class AndroidConnectDebuggerAction
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        final Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        assert (project != null);
        if (!AndroidSdkUtils.activateDdmsIfNecessary(project, new Computable<AndroidDebugBridge>(){

            @Nullable
            public AndroidDebugBridge compute() {
                return AndroidSdkUtils.getDebugBridge(project);
            }
        })) {
            return;
        }
        AndroidProcessChooserDialog dialog = new AndroidProcessChooserDialog(project);
        dialog.show();
    }

    public void update(AnActionEvent e) {
        super.update(e);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        e.getPresentation().setVisible(project != null && ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID).size() > 0);
    }
}

