/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.intellij.openapi.module.impl.scopes.JdkScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.SdkResolveScopeProvider;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.android.augment.AndroidInternalRClass;
import org.jetbrains.android.sdk.AndroidSdkType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidSdkResolveScopeProvider
extends SdkResolveScopeProvider {
    public GlobalSearchScope getScope(@NotNull Project project, @NotNull JdkOrderEntry entry) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/AndroidSdkResolveScopeProvider", "getScope"));
        }
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/AndroidSdkResolveScopeProvider", "getScope"));
        }
        Sdk sdk = entry.getJdk();
        if (sdk == null || !(sdk.getSdkType() instanceof AndroidSdkType)) {
            return null;
        }
        if (sdk.getRootProvider().getFiles(OrderRootType.SOURCES).length == 0) {
            return null;
        }
        return new MyJdkScope(project, entry);
    }

    public static class MyJdkScope
    extends JdkScope {
        private final Sdk mySdk;

        private MyJdkScope(Project project, @NotNull JdkOrderEntry jdkOrderEntry) {
            if (jdkOrderEntry == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/AndroidSdkResolveScopeProvider$MyJdkScope", "<init>"));
            }
            super(project, jdkOrderEntry);
            this.mySdk = jdkOrderEntry.getJdk();
        }

        @Nullable
        protected VirtualFile getFileRoot(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/AndroidSdkResolveScopeProvider$MyJdkScope", "getFileRoot"));
            }
            VirtualFile resultFromSuper = super.getFileRoot(file);
            if (resultFromSuper != null) {
                return resultFromSuper;
            }
            return this.myIndex.isInLibrarySource(file) ? this.myIndex.getSourceRootForFile(file) : null;
        }

        public boolean isForceSearchingInLibrarySources() {
            return true;
        }

        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/AndroidSdkResolveScopeProvider$MyJdkScope", "compare"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/AndroidSdkResolveScopeProvider$MyJdkScope", "compare"));
            }
            boolean inSources1 = this.myIndex.isInLibrarySource(file1);
            if (inSources1 != this.myIndex.isInLibrarySource(file2)) {
                return inSources1 ? 1 : -1;
            }
            return super.compare(file1, file2);
        }

        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/AndroidSdkResolveScopeProvider$MyJdkScope", "contains"));
            }
            return super.contains(file) || AndroidInternalRClass.isAndroidInternalR(file, this.mySdk);
        }
    }
}

