/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.android.dom.converters.OnClickConverter;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class AndroidImplicitUsagesProvider
implements ImplicitUsageProvider {
    public boolean isImplicitUsage(PsiElement element) {
        if (element instanceof PsiField) {
            return AndroidImplicitUsagesProvider.isImplicitFieldUsage((PsiField)element);
        }
        if (element instanceof PsiParameter) {
            return AndroidImplicitUsagesProvider.isImplicitParameterUsage((PsiParameter)element);
        }
        return false;
    }

    private static boolean isImplicitParameterUsage(@NotNull PsiParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/AndroidImplicitUsagesProvider", "isImplicitParameterUsage"));
        }
        if (AndroidFacet.getInstance((PsiElement)parameter) == null) {
            return false;
        }
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)parameter, PsiMethod.class);
        if (method == null || !OnClickConverter.CONVERTER_FOR_LAYOUT.checkSignature(method) && !OnClickConverter.CONVERTER_FOR_MENU.checkSignature(method)) {
            return false;
        }
        PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)method, PsiClass.class);
        if (aClass == null) {
            return false;
        }
        PsiClass activityBaseClass = JavaPsiFacade.getInstance((Project)aClass.getProject()).findClass("android.app.Activity", parameter.getResolveScope());
        if (activityBaseClass == null) {
            return false;
        }
        return aClass.isInheritor(activityBaseClass, true);
    }

    private static boolean isImplicitFieldUsage(@NotNull PsiField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/AndroidImplicitUsagesProvider", "isImplicitFieldUsage"));
        }
        if (!"CREATOR".equals(field.getName())) {
            return false;
        }
        PsiModifierList modifierList = field.getModifierList();
        if (modifierList == null || !modifierList.hasModifierProperty("static")) {
            return false;
        }
        PsiClass aClass = field.getContainingClass();
        return aClass != null && InheritanceUtil.isInheritor((PsiClass)aClass, (String)"android.os.Parcelable");
    }

    public boolean isImplicitRead(PsiElement element) {
        return false;
    }

    public boolean isImplicitWrite(PsiElement element) {
        if (!(element instanceof PsiField)) {
            return false;
        }
        AndroidFacet facet = AndroidFacet.getInstance(element);
        if (facet == null) {
            return false;
        }
        PsiField field = (PsiField)element;
        PsiModifierList modifierList = field.getModifierList();
        if (modifierList == null) {
            return false;
        }
        for (PsiAnnotation annotation : modifierList.getAnnotations()) {
            for (PsiNameValuePair pair : annotation.getParameterList().getAttributes()) {
                PsiAnnotationMemberValue value = pair.getValue();
                if (!AndroidImplicitUsagesProvider.isResourceReference(value)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isResourceReference(PsiAnnotationMemberValue value) {
        if (!(value instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression exp = (PsiReferenceExpression)value;
        String refName = exp.getReferenceName();
        if (refName == null || refName.length() == 0) {
            return false;
        }
        PsiExpression qExp = exp.getQualifierExpression();
        if (!(qExp instanceof PsiReferenceExpression)) {
            return false;
        }
        exp = (PsiReferenceExpression)qExp;
        refName = exp.getReferenceName();
        if (refName == null || refName.length() == 0) {
            return false;
        }
        qExp = exp.getQualifierExpression();
        if (!(qExp instanceof PsiReferenceExpression)) {
            return false;
        }
        exp = (PsiReferenceExpression)qExp;
        return "R".equals(exp.getReferenceName());
    }
}

