/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.xml.NanoXmlUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;

public class AndroidIdIndex
extends FileBasedIndexExtension<String, Set<String>> {
    public static final ID<String, Set<String>> INDEX_ID = ID.create((String)"android.id.index");
    public static final String MARKER = "$";
    private static final DataIndexer<String, Set<String>, FileContent> INDEXER = new DataIndexer<String, Set<String>, FileContent>(){

        @NotNull
        public Map<String, Set<String>> map(@NotNull FileContent inputData) {
            if (inputData == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/AndroidIdIndex$1", "map"));
            }
            CharSequence content = inputData.getContentAsText();
            if (CharArrayUtil.indexOf((CharSequence)content, (CharSequence)"http://schemas.android.com/apk/res/android", (int)0) == -1) {
                Map<String, Set<String>> map = Collections.emptyMap();
                if (map == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/AndroidIdIndex$1", "map"));
                }
                return map;
            }
            final HashMap map = new HashMap();
            NanoXmlUtil.parse((Reader)CharArrayUtil.readerFromCharSequence((CharSequence)inputData.getContentAsText()), (IXMLBuilder)new NanoXmlUtil.IXMLBuilderAdapter(){

                public void addAttribute(String key, String nsPrefix, String nsURI, String value, String type) throws Exception {
                    String id;
                    super.addAttribute(key, nsPrefix, nsURI, value, type);
                    boolean declaration = AndroidResourceUtil.isIdDeclaration(value);
                    if ((declaration || AndroidResourceUtil.isIdReference(value)) && (id = AndroidResourceUtil.getResourceNameByReferenceText(value)) != null) {
                        if (declaration) {
                            id = "+" + id;
                        }
                        map.put((Object)id, Collections.emptySet());
                    }
                }
            });
            if (map.size() > 0) {
                map.put((Object)AndroidIdIndex.MARKER, (Object)new HashSet((Collection)map.keySet()));
            }
            HashMap hashMap = map;
            if (hashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/AndroidIdIndex$1", "map"));
            }
            return hashMap;
        }
    };
    private static final DataExternalizer<Set<String>> DATA_EXTERNALIZER = new DataExternalizer<Set<String>>(){

        public void save(@NotNull DataOutput out, Set<String> value) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/AndroidIdIndex$2", "save"));
            }
            out.writeInt(value.size());
            for (String s : value) {
                out.writeUTF(s);
            }
        }

        public Set<String> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/AndroidIdIndex$2", "read"));
            }
            int size = in.readInt();
            HashSet result = new HashSet(size);
            for (int i = 0; i < size; ++i) {
                String s = in.readUTF();
                result.add(s);
            }
            return result;
        }
    };

    @NotNull
    public ID<String, Set<String>> getName() {
        ID<String, Set<String>> iD = INDEX_ID;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/AndroidIdIndex", "getName"));
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, Set<String>, FileContent> getIndexer() {
        DataIndexer<String, Set<String>, FileContent> dataIndexer = INDEXER;
        if (dataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/AndroidIdIndex", "getIndexer"));
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = new EnumeratorStringDescriptor();
        if (enumeratorStringDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/AndroidIdIndex", "getKeyDescriptor"));
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<Set<String>> getValueExternalizer() {
        DataExternalizer<Set<String>> dataExternalizer = DATA_EXTERNALIZER;
        if (dataExternalizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/AndroidIdIndex", "getValueExternalizer"));
        }
        return dataExternalizer;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DefaultFileTypeSpecificInputFilter defaultFileTypeSpecificInputFilter = new DefaultFileTypeSpecificInputFilter(new FileType[]{StdFileTypes.XML}){

            public boolean acceptInput(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/AndroidIdIndex$3", "acceptInput"));
                }
                return file.isInLocalFileSystem();
            }
        };
        if (defaultFileTypeSpecificInputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/AndroidIdIndex", "getInputFilter"));
        }
        return defaultFileTypeSpecificInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 4;
    }
}

