/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.resources.ResourceFolderType;
import com.google.common.collect.ObjectArrays;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import java.util.List;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.dom.wrappers.LazyValueResourceElementWrapper;
import org.jetbrains.android.dom.wrappers.ResourceElementWrapper;
import org.jetbrains.android.dom.wrappers.ValueResourceElementWrapper;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidFindUsagesHandlerFactory
extends FindUsagesHandlerFactory {
    public boolean canFindUsages(@NotNull PsiElement element) {
        AndroidFacet facet;
        XmlAttributeValue value;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/AndroidFindUsagesHandlerFactory", "canFindUsages"));
        }
        PsiElement element1 = LazyValueResourceElementWrapper.computeLazyElement(element);
        if (element1 == null) {
            return false;
        }
        if (element1 instanceof XmlAttributeValue && AndroidResourceUtil.findIdFields(value = (XmlAttributeValue)element1).length > 0) {
            return true;
        }
        if ((element1 = AndroidFindUsagesHandlerFactory.correctResourceElement(element1)) instanceof PsiField) {
            return AndroidResourceUtil.isResourceField((PsiField)element1);
        }
        if ((element1 instanceof PsiFile || element1 instanceof XmlTag) && (facet = AndroidFacet.getInstance(element1)) != null) {
            if (element1 instanceof PsiFile) {
                return facet.getLocalResourceManager().getFileResourceType((PsiFile)element1) != null;
            }
            String fileResType = facet.getLocalResourceManager().getFileResourceType(element1.getContainingFile());
            if (ResourceFolderType.VALUES.getName().equals(fileResType)) {
                return AndroidResourceUtil.getResourceTypeByValueResourceTag((XmlTag)element1) != null;
            }
        }
        return false;
    }

    @Nullable
    private static PsiElement correctResourceElement(PsiElement element) {
        if (element instanceof XmlElement && !(element instanceof XmlFile)) {
            XmlTag tag = element instanceof XmlTag ? (XmlTag)element : (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
            DomElement domElement = DomManager.getDomManager((Project)element.getProject()).getDomElement(tag);
            if (domElement instanceof ResourceElement) {
                return tag;
            }
            return null;
        }
        return element;
    }

    private static XmlAttributeValue wrapIfNecessary(XmlAttributeValue value) {
        if (value instanceof ResourceElementWrapper) {
            return value;
        }
        return new ValueResourceElementWrapper(value);
    }

    public FindUsagesHandler createFindUsagesHandler(@NotNull PsiElement element, boolean forHighlightUsages) {
        XmlAttributeValue value;
        Object[] fields;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/AndroidFindUsagesHandlerFactory", "createFindUsagesHandler"));
        }
        PsiElement e = LazyValueResourceElementWrapper.computeLazyElement(element);
        if (e == null) {
            return null;
        }
        AndroidFacet facet = AndroidFacet.getInstance(e);
        if (facet == null) {
            return null;
        }
        if (e instanceof XmlAttributeValue && (fields = AndroidResourceUtil.findIdFields(value = (XmlAttributeValue)e)).length > 0) {
            e = AndroidFindUsagesHandlerFactory.wrapIfNecessary(value);
            return new MyFindUsagesHandler(e, (PsiElement[])fields);
        }
        if ((e = AndroidFindUsagesHandlerFactory.correctResourceElement(e)) instanceof PsiFile) {
            PsiField[] fields2 = AndroidResourceUtil.findResourceFieldsForFileResource((PsiFile)e, true);
            if (fields2.length == 0) {
                return null;
            }
            return new MyFindUsagesHandler(e, (PsiElement[])fields2);
        }
        if (e instanceof XmlTag) {
            XmlAttribute nameAttr;
            XmlAttributeValue nameValue;
            XmlTag tag = (XmlTag)e;
            fields = AndroidResourceUtil.findResourceFieldsForValueResource(tag, true);
            if (fields.length == 0) {
                return null;
            }
            Object[] styleableFields = AndroidResourceUtil.findStyleableAttributeFields(tag, true);
            if (styleableFields.length > 0) {
                fields = (PsiField[])ObjectArrays.concat((Object[])fields, (Object[])styleableFields, PsiField.class);
            }
            XmlAttributeValue xmlAttributeValue = nameValue = (nameAttr = tag.getAttribute("name")) != null ? nameAttr.getValueElement() : null;
            assert (nameValue != null);
            return new MyFindUsagesHandler((PsiElement)nameValue, (PsiElement[])fields);
        }
        if (e instanceof PsiField) {
            PsiField field = (PsiField)e;
            List<PsiElement> resources = AndroidResourceUtil.findResourcesByField(field);
            if (resources.size() == 0) {
                return new MyFindUsagesHandler(e, new PsiElement[0]);
            }
            PsiElement resource = resources.get(0);
            return this.createFindUsagesHandler(resource, forHighlightUsages);
        }
        return null;
    }

    private static class MyFindUsagesHandler
    extends FindUsagesHandler {
        private final PsiElement[] myAdditionalElements;

        protected MyFindUsagesHandler(@NotNull PsiElement element, PsiElement ... additionalElements) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/AndroidFindUsagesHandlerFactory$MyFindUsagesHandler", "<init>"));
            }
            super(element);
            this.myAdditionalElements = additionalElements;
        }

        @NotNull
        public PsiElement[] getSecondaryElements() {
            if (this.myAdditionalElements == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/AndroidFindUsagesHandlerFactory$MyFindUsagesHandler", "getSecondaryElements"));
            }
            return this.myAdditionalElements;
        }
    }
}

