/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.model;

import com.intellij.designer.designSurface.ComponentTargetFilter;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.model.RadComponentVisitor;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindComponentVisitor
extends RadComponentVisitor {
    private final JComponent myComponent;
    private final ComponentTargetFilter myFilter;
    private RadComponent myResult;
    private final int myX;
    private final int myY;

    public FindComponentVisitor(@NotNull JComponent component, @Nullable ComponentTargetFilter filter, int x, int y) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/designer/model/FindComponentVisitor", "<init>"));
        }
        this.myComponent = component;
        this.myFilter = filter;
        this.myX = x;
        this.myY = y;
    }

    public RadComponent getResult() {
        return this.myResult;
    }

    @Override
    public boolean visit(RadComponent component) {
        return this.myResult == null && component.getBounds(this.myComponent).contains(this.myX, this.myY) && (this.myFilter == null || this.myFilter.preFilter(component));
    }

    @Override
    public void endVisit(RadComponent component) {
        if (this.myResult == null && (this.myFilter == null || this.myFilter.resultFilter(component))) {
            this.myResult = component;
        }
    }
}

