/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface.selection;

import com.intellij.designer.designSurface.DecorationLayer;
import com.intellij.designer.designSurface.selection.NonResizeSelectionDecorator;
import com.intellij.designer.designSurface.selection.ResizePoint;
import com.intellij.designer.designSurface.tools.InputTool;
import com.intellij.designer.model.RadComponent;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;

public class ResizeSelectionDecorator
extends NonResizeSelectionDecorator {
    private final List<ResizePoint> myPoints = new ArrayList<ResizePoint>();

    public ResizeSelectionDecorator(Color color, int lineWidth) {
        super(color, lineWidth);
    }

    public void clear() {
        this.myPoints.clear();
    }

    public void addPoint(ResizePoint point) {
        this.myPoints.add(point);
    }

    @Override
    public InputTool findTargetTool(DecorationLayer layer, RadComponent component, int x, int y) {
        for (ResizePoint point : this.myPoints) {
            InputTool tracker;
            if (!this.visible(component, point) || (tracker = point.findTargetTool(layer, component, x, y)) == null) continue;
            return tracker;
        }
        return super.findTargetTool(layer, component, x, y);
    }

    @Override
    public void decorate(DecorationLayer layer, Graphics2D g, RadComponent component) {
        super.decorate(layer, g, component);
        for (ResizePoint point : this.myPoints) {
            if (!this.visible(component, point)) continue;
            point.decorate(layer, g, component);
        }
    }

    protected boolean visible(RadComponent component, ResizePoint point) {
        return true;
    }
}

