/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer;

import com.intellij.designer.AbstractToolWindowManager;
import com.intellij.designer.DesignerToolWindowManager;
import com.intellij.designer.palette.PaletteToolWindowManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowAnchor;

public class ToggleEditorModeAction
extends ToggleAction {
    private final AbstractToolWindowManager myManager;
    private final Project myProject;
    private final ToolWindowAnchor myAnchor;

    public ToggleEditorModeAction(AbstractToolWindowManager manager, Project project, ToolWindowAnchor anchor) {
        super(StringUtil.capitalize((String)anchor.toString()), "Pin/unpin tool window to " + anchor + " side UI Designer Editor", null);
        this.myManager = manager;
        this.myProject = project;
        this.myAnchor = anchor;
    }

    public boolean isSelected(AnActionEvent e) {
        return this.myAnchor == this.myManager.getEditorMode();
    }

    public void setSelected(AnActionEvent e, boolean state) {
        if (state) {
            this.myManager.setEditorMode(this.myAnchor);
            AbstractToolWindowManager manager = this.getOppositeManager();
            if (manager.getEditorMode() == this.myAnchor) {
                manager.setEditorMode(this.myAnchor == ToolWindowAnchor.LEFT ? ToolWindowAnchor.RIGHT : ToolWindowAnchor.LEFT);
            }
        } else {
            this.myManager.setEditorMode(null);
        }
    }

    private AbstractToolWindowManager getOppositeManager() {
        DesignerToolWindowManager designerManager = DesignerToolWindowManager.getInstance(this.myProject);
        PaletteToolWindowManager paletteManager = PaletteToolWindowManager.getInstance(this.myProject);
        return this.myManager == designerManager ? paletteManager : designerManager;
    }
}

