/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer;

import com.intellij.designer.DesignerCustomizations;
import com.intellij.designer.DesignerEditor;
import com.intellij.designer.LightToolWindow;
import com.intellij.designer.LightToolWindowContent;
import com.intellij.designer.ToggleEditorModeAction;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.util.ParameterizedRunnable;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractToolWindowManager
implements ProjectComponent {
    public static final String EDITOR_MODE = "UI_DESIGNER_EDITOR_MODE.";
    private final MergingUpdateQueue myWindowQueue = new MergingUpdateQueue(this.getComponentName(), 200, true, null);
    protected final Project myProject;
    protected final FileEditorManager myFileEditorManager;
    protected volatile ToolWindow myToolWindow;
    private volatile boolean myToolWindowReady;
    private volatile boolean myToolWindowDisposed;
    private final PropertiesComponent myPropertiesComponent;
    public final String myEditorModeKey;
    private ToggleEditorModeAction myLeftEditorModeAction;
    private ToggleEditorModeAction myRightEditorModeAction;
    private MessageBusConnection myConnection;
    private final FileEditorManagerListener myListener = new FileEditorManagerListener(){

        public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/designer/AbstractToolWindowManager$1", "fileOpened"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/designer/AbstractToolWindowManager$1", "fileOpened"));
            }
            AbstractToolWindowManager.this.bindToDesigner(AbstractToolWindowManager.this.getActiveDesigner());
        }

        public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/designer/AbstractToolWindowManager$1", "fileClosed"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/designer/AbstractToolWindowManager$1", "fileClosed"));
            }
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    AbstractToolWindowManager.this.bindToDesigner(AbstractToolWindowManager.this.getActiveDesigner());
                }
            });
        }

        public void selectionChanged(@NotNull FileEditorManagerEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/designer/AbstractToolWindowManager$1", "selectionChanged"));
            }
            AbstractToolWindowManager.this.bindToDesigner(AbstractToolWindowManager.getDesigner(event.getNewEditor()));
        }
    };
    private final ParameterizedRunnable<DesignerEditorPanel> myCreateAction = new ParameterizedRunnable<DesignerEditorPanel>(){

        public void run(DesignerEditorPanel designer) {
            designer.putClientProperty(AbstractToolWindowManager.this.getComponentName(), AbstractToolWindowManager.this.createContent(designer));
        }
    };
    private final ParameterizedRunnable<DesignerEditorPanel> myUpdateAnchorAction = new ParameterizedRunnable<DesignerEditorPanel>(){

        public void run(DesignerEditorPanel designer) {
            LightToolWindow toolWindow = (LightToolWindow)designer.getClientProperty(AbstractToolWindowManager.this.getComponentName());
            toolWindow.updateAnchor(AbstractToolWindowManager.this.getEditorMode());
        }
    };
    private final ParameterizedRunnable<DesignerEditorPanel> myDisposeAction = new ParameterizedRunnable<DesignerEditorPanel>(){

        public void run(DesignerEditorPanel designer) {
            AbstractToolWindowManager.this.disposeContent(designer);
        }
    };

    protected AbstractToolWindowManager(Project project, FileEditorManager fileEditorManager) {
        this.myProject = project;
        this.myFileEditorManager = fileEditorManager;
        this.myPropertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        this.myEditorModeKey = EDITOR_MODE + this.getComponentName() + ".STATE";
    }

    public void projectOpened() {
        this.initToolWindow();
        StartupManager.getInstance((Project)this.myProject).registerPostStartupActivity(new Runnable(){

            @Override
            public void run() {
                AbstractToolWindowManager.this.myToolWindowReady = true;
                if (AbstractToolWindowManager.this.getEditorMode() == null) {
                    AbstractToolWindowManager.this.initListeners();
                    AbstractToolWindowManager.this.bindToDesigner(AbstractToolWindowManager.this.getActiveDesigner());
                }
            }
        });
    }

    public void projectClosed() {
        if (!this.myToolWindowDisposed) {
            this.disposeComponent();
            this.myToolWindowDisposed = true;
            this.myToolWindow = null;
        }
    }

    private void initListeners() {
        this.myConnection = this.myProject.getMessageBus().connect((Disposable)this.myProject);
        this.myConnection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)this.myListener);
    }

    private void removeListeners() {
        this.myConnection.disconnect();
        this.myConnection = null;
    }

    @Nullable
    private static DesignerEditorPanel getDesigner(FileEditor editor) {
        if (editor instanceof DesignerEditor) {
            DesignerEditor designerEditor = (DesignerEditor)editor;
            return designerEditor.getDesignerPanel();
        }
        return null;
    }

    @Nullable
    public DesignerEditorPanel getActiveDesigner() {
        for (FileEditor editor : this.myFileEditorManager.getSelectedEditors()) {
            DesignerEditorPanel designer = AbstractToolWindowManager.getDesigner(editor);
            if (designer == null) continue;
            return designer;
        }
        return null;
    }

    @Nullable
    protected static DesignerCustomizations getCustomizations() {
        return (DesignerCustomizations)DesignerCustomizations.EP_NAME.findExtension(DesignerCustomizations.class);
    }

    private void bindToDesigner(final DesignerEditorPanel designer) {
        this.myWindowQueue.cancelAllUpdates();
        this.myWindowQueue.queue(new Update("update"){

            public void run() {
                if (!AbstractToolWindowManager.this.myToolWindowReady || AbstractToolWindowManager.this.myToolWindowDisposed) {
                    return;
                }
                if (AbstractToolWindowManager.this.myToolWindow == null) {
                    if (designer == null) {
                        return;
                    }
                    AbstractToolWindowManager.this.initToolWindow();
                }
                AbstractToolWindowManager.this.updateToolWindow(designer);
            }
        });
    }

    protected abstract void initToolWindow();

    protected abstract void updateToolWindow(@Nullable DesignerEditorPanel var1);

    protected final void initGearActions() {
        ToolWindowEx toolWindow = (ToolWindowEx)this.myToolWindow;
        toolWindow.setAdditionalGearActions((ActionGroup)new DefaultActionGroup(new AnAction[]{this.createGearActions()}));
    }

    protected abstract ToolWindowAnchor getAnchor();

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public final ActionGroup createGearActions() {
        DefaultActionGroup group = new DefaultActionGroup("In Editor Mode", true);
        if (this.myLeftEditorModeAction == null) {
            this.myLeftEditorModeAction = new ToggleEditorModeAction(this, this.myProject, ToolWindowAnchor.LEFT);
        }
        group.add((AnAction)this.myLeftEditorModeAction);
        if (this.myRightEditorModeAction == null) {
            this.myRightEditorModeAction = new ToggleEditorModeAction(this, this.myProject, ToolWindowAnchor.RIGHT);
        }
        group.add((AnAction)this.myRightEditorModeAction);
        return group;
    }

    public final void bind(DesignerEditorPanel designer) {
        if (this.isEditorMode()) {
            this.myCreateAction.run((Object)designer);
        }
    }

    public final void dispose(DesignerEditorPanel designer) {
        if (this.isEditorMode()) {
            this.disposeContent(designer);
        }
    }

    protected final Object getContent(DesignerEditorPanel designer) {
        LightToolWindow toolWindow = (LightToolWindow)designer.getClientProperty(this.getComponentName());
        return toolWindow.getContent();
    }

    protected abstract LightToolWindow createContent(DesignerEditorPanel var1);

    protected final LightToolWindow createContent(DesignerEditorPanel designer, LightToolWindowContent content, String title, Icon icon, JComponent component, JComponent focusedComponent, int defaultWidth, AnAction[] actions) {
        return new LightToolWindow(content, title, icon, component, focusedComponent, designer.getContentSplitter(), this.getEditorMode(), this, this.myProject, this.myPropertiesComponent, this.getComponentName(), defaultWidth, actions);
    }

    protected final void disposeContent(DesignerEditorPanel designer) {
        String key = this.getComponentName();
        LightToolWindow toolWindow = (LightToolWindow)designer.getClientProperty(key);
        designer.putClientProperty(key, null);
        toolWindow.dispose();
    }

    private void runUpdateContent(ParameterizedRunnable<DesignerEditorPanel> action) {
        for (FileEditor editor : this.myFileEditorManager.getAllEditors()) {
            DesignerEditorPanel designer = AbstractToolWindowManager.getDesigner(editor);
            if (designer == null) continue;
            action.run((Object)designer);
        }
    }

    protected final boolean isEditorMode() {
        return this.getEditorMode() != null;
    }

    @Nullable
    final ToolWindowAnchor getEditorMode() {
        String value = this.myPropertiesComponent.getValue(this.myEditorModeKey);
        if (value == null) {
            return this.getAnchor();
        }
        return value.equals("ToolWindow") ? null : ToolWindowAnchor.fromText((String)value);
    }

    final void setEditorMode(@Nullable ToolWindowAnchor newState) {
        ToolWindowAnchor oldState = this.getEditorMode();
        this.myPropertiesComponent.setValue(this.myEditorModeKey, newState == null ? "ToolWindow" : newState.toString());
        if (oldState != null && newState != null) {
            this.runUpdateContent(this.myUpdateAnchorAction);
        } else if (newState != null) {
            this.removeListeners();
            this.updateToolWindow(null);
            this.runUpdateContent(this.myCreateAction);
        } else {
            this.runUpdateContent(this.myDisposeAction);
            this.initListeners();
            this.bindToDesigner(this.getActiveDesigner());
        }
    }

    final ToolWindow getToolWindow() {
        return this.myToolWindow;
    }
}

