/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.propertyTable.renderers;

import com.intellij.android.designer.model.RadModelBuilder;
import com.intellij.designer.componentTree.AttributeWrapper;
import com.intellij.designer.componentTree.TreeComponentDecorator;
import com.intellij.designer.model.PropertiesContainer;
import com.intellij.designer.model.PropertyContext;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.propertyTable.PropertyRenderer;
import com.intellij.designer.propertyTable.PropertyTable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ComponentRenderer
extends ColoredListCellRenderer
implements PropertyRenderer {
    protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
        this.clear();
        PropertyTable.updateRenderer((JComponent)((Object)this), (boolean)selected);
        if (value == "<unset>") {
            this.append("<unset>");
        } else if (value instanceof RadComponent) {
            this.renderComponent((RadComponent)((Object)value));
        }
    }

    private void renderComponent(RadComponent component) {
        TreeComponentDecorator decorator = RadModelBuilder.getTreeDecorator(component);
        if (decorator != null) {
            decorator.decorate(component, (SimpleColoredComponent)this, AttributeWrapper.DEFAULT, false);
            this.setIcon(component.getMetaModel().getIcon());
        }
    }

    @NotNull
    public JComponent getComponent(@Nullable PropertiesContainer container, PropertyContext context, @Nullable Object object, boolean selected, boolean hasFocus) {
        RadComponent idComponent;
        this.clear();
        PropertyTable.updateRenderer((JComponent)((Object)this), (boolean)selected);
        String value = (String)object;
        RadComponent radComponent = idComponent = container instanceof RadComponent ? this.getComponentById((RadComponent)container, value) : null;
        if (idComponent != null) {
            this.renderComponent(idComponent);
        } else if (!StringUtil.isEmpty((String)value)) {
            this.append("<not found>", SimpleTextAttributes.ERROR_ATTRIBUTES);
        }
        ComponentRenderer componentRenderer = this;
        if (componentRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/propertyTable/renderers/ComponentRenderer", "getComponent"));
        }
        return componentRenderer;
    }

    @Nullable
    public abstract RadComponent getComponentById(RadComponent var1, String var2);

    public void updateUI() {
        SwingUtilities.updateComponentTreeUI((Component)((Object)this));
    }
}

