/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.propertyTable.editors;

import com.android.resources.ResourceType;
import com.intellij.android.designer.model.RadModelBuilder;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.propertyTable.editors.ResourceDialog;
import com.intellij.android.designer.propertyTable.renderers.ResourceRenderer;
import com.intellij.designer.model.PropertiesContainer;
import com.intellij.designer.model.PropertyContext;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.model.RadPropertyContext;
import com.intellij.designer.propertyTable.InplaceContext;
import com.intellij.designer.propertyTable.PropertyEditor;
import com.intellij.designer.propertyTable.editors.ComboEditor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.ArrayUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EnumSet;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.ComboPopup;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.android.uipreview.ChooseResourceDialog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceEditor
extends PropertyEditor {
    private final ResourceType[] myTypes;
    protected ComponentWithBrowseButton myEditor;
    protected RadComponent myRootComponent;
    protected RadComponent myComponent;
    private JCheckBox myCheckBox;
    private final Border myCheckBoxBorder = new JTextField().getBorder();
    private boolean myIgnoreCheckBoxValue;
    private String myBooleanResourceValue;
    private final boolean myIsDimension;

    public ResourceEditor(Set<AttributeFormat> formats, String[] values) {
        this(ResourceEditor.convertTypes(formats), formats, values);
    }

    public ResourceEditor(@Nullable ResourceType[] types, Set<AttributeFormat> formats, @Nullable String[] values) {
        this.myTypes = types;
        this.myIsDimension = formats.contains((Object)AttributeFormat.Dimension);
        if (formats.contains((Object)AttributeFormat.Boolean)) {
            this.myCheckBox = new JCheckBox();
            this.myEditor = new ComponentWithBrowseButton<JCheckBox>(this.myCheckBox, null){

                public Dimension getPreferredSize() {
                    return ResourceEditor.this.getComponentPreferredSize();
                }
            };
            this.myCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!ResourceEditor.this.myIgnoreCheckBoxValue) {
                        ResourceEditor.this.myBooleanResourceValue = null;
                        ResourceEditor.this.fireValueCommitted(true, true);
                    }
                }
            });
        } else if (formats.contains((Object)AttributeFormat.Enum)) {
            ComboboxWithBrowseButton editor = new ComboboxWithBrowseButton((JComboBox)(SystemInfo.isWindows ? new MyComboBox() : new JComboBox())){

                public Dimension getPreferredSize() {
                    return ResourceEditor.this.getComponentPreferredSize();
                }
            };
            final JComboBox comboBox = editor.getComboBox();
            DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(values);
            model.insertElementAt("<unset>", 0);
            comboBox.setModel(model);
            comboBox.setEditable(true);
            ComboEditor.installListeners((JComboBox)comboBox, (ComboEditor.ComboEditorListener)new ComboEditor.ComboEditorListener(this){

                protected void onValueChosen() {
                    if (comboBox.getSelectedItem() == "<unset>") {
                        comboBox.setSelectedItem(null);
                    }
                    super.onValueChosen();
                }
            });
            this.myEditor = editor;
            comboBox.setSelectedIndex(0);
        } else {
            this.myEditor = new TextFieldWithBrowseButton(){

                protected void installPathCompletion(FileChooserDescriptor fileChooserDescriptor, @Nullable Disposable parent) {
                }

                public Dimension getPreferredSize() {
                    return ResourceEditor.this.getComponentPreferredSize();
                }
            };
            this.myEditor.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            }, KeyStroke.getKeyStroke(10, 0), 1);
            JTextField textField = this.getComboText();
            textField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ResourceEditor.this.fireValueCommitted(true, true);
                }
            });
            textField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    ResourceEditor.this.preferredSizeChanged();
                }
            });
        }
        if (this.myCheckBox == null) {
            this.myEditor.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            }, KeyStroke.getKeyStroke(8, 0), 1);
        }
        this.myEditor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourceEditor.this.showDialog();
            }
        });
        this.myEditor.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ResourceEditor.this.myEditor.getChildComponent().requestFocus();
            }
        });
    }

    private Dimension getComponentPreferredSize() {
        Dimension size1 = this.myEditor.getChildComponent().getPreferredSize();
        Dimension size2 = this.myEditor.getButton().getPreferredSize();
        return new Dimension(Math.max(size1.width, 25) + 5 + size2.width, size1.height);
    }

    private static ResourceType[] convertTypes(Set<AttributeFormat> formats) {
        EnumSet<ResourceType> types = EnumSet.noneOf(ResourceType.class);
        for (AttributeFormat format : formats) {
            switch (format) {
                case Boolean: {
                    types.add(ResourceType.BOOL);
                    break;
                }
                case Color: {
                    return ChooseResourceDialog.COLOR_TYPES;
                }
                case Dimension: {
                    types.add(ResourceType.DIMEN);
                    break;
                }
                case Integer: {
                    types.add(ResourceType.INTEGER);
                    break;
                }
                case Fraction: {
                    types.add(ResourceType.FRACTION);
                    break;
                }
                case String: {
                    types.add(ResourceType.STRING);
                    break;
                }
                case Reference: {
                    types.add(ResourceType.COLOR);
                    types.add(ResourceType.DRAWABLE);
                    types.add(ResourceType.STRING);
                    types.add(ResourceType.ID);
                    types.add(ResourceType.STYLE);
                }
            }
        }
        return types.toArray(new ResourceType[types.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public JComponent getComponent(@Nullable PropertiesContainer container, @Nullable PropertyContext context, Object object, @Nullable InplaceContext inplaceContext) {
        this.myComponent = (RadComponent)container;
        this.myRootComponent = context instanceof RadPropertyContext ? ((RadPropertyContext)context).getRootComponent() : null;
        String value = (String)object;
        JTextField text = this.getComboText();
        if (text == null) {
            this.myBooleanResourceValue = StringUtil.isEmpty((String)value) || value.equals("true") || value.equals("false") ? null : value;
            try {
                this.myIgnoreCheckBoxValue = true;
                this.myCheckBox.setSelected(Boolean.parseBoolean(value));
            }
            finally {
                this.myIgnoreCheckBoxValue = false;
            }
            if (inplaceContext == null) {
                this.myEditor.setBorder(null);
                this.myCheckBox.setText(null);
            } else {
                this.myEditor.setBorder(this.myCheckBoxBorder);
                this.myCheckBox.setText(this.myBooleanResourceValue);
            }
        } else {
            text.setText(value);
            if (inplaceContext != null) {
                text.setColumns(0);
                if (inplaceContext.isStartChar()) {
                    text.setText(inplaceContext.getText(text.getText()));
                }
            }
        }
        ComponentWithBrowseButton componentWithBrowseButton = this.myEditor;
        if (componentWithBrowseButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/propertyTable/editors/ResourceEditor", "getComponent"));
        }
        return componentWithBrowseButton;
    }

    public JComponent getPreferredFocusedComponent() {
        JTextField text = this.getComboText();
        return text == null ? this.myCheckBox : text;
    }

    public Object getValue() {
        JTextField text = this.getComboText();
        if (text == null) {
            return this.myBooleanResourceValue == null ? Boolean.toString(this.myCheckBox.isSelected()) : this.myBooleanResourceValue;
        }
        String value = text.getText();
        if (value == "<unset>" || StringUtil.isEmpty((String)value)) {
            return null;
        }
        if (!(!this.myIsDimension || value.startsWith("@") || value.endsWith("dip") || value.equalsIgnoreCase("wrap_content") || value.equalsIgnoreCase("fill_parent") || value.equalsIgnoreCase("match_parent"))) {
            if (value.length() <= 2) {
                return value + "dp";
            }
            int index = value.length() - 2;
            String dimension = value.substring(index);
            if (ArrayUtil.indexOf((Object[])ResourceRenderer.DIMENSIONS, (Object)dimension) == -1) {
                return value + "dp";
            }
        }
        return value;
    }

    public void updateUI() {
        SwingUtilities.updateComponentTreeUI((Component)this.myEditor);
    }

    protected void showDialog() {
        Module module = RadModelBuilder.getModule(this.myRootComponent);
        if (module == null) {
            if (this.myBooleanResourceValue != null) {
                this.fireEditingCancelled();
            }
            return;
        }
        ResourceDialog dialog = new ResourceDialog(module, this.myTypes, (String)this.getValue(), (RadViewComponent)this.myComponent);
        dialog.show();
        if (dialog.isOK()) {
            this.setValue(dialog.getResourceName());
        } else if (this.myBooleanResourceValue != null) {
            this.fireEditingCancelled();
        }
    }

    protected final void setValue(String value) {
        JTextField text = this.getComboText();
        if (text == null) {
            this.myBooleanResourceValue = value;
            this.fireValueCommitted(false, true);
        } else {
            text.setText(value);
            this.fireValueCommitted(true, true);
        }
    }

    private JTextField getComboText() {
        JComponent component = this.myEditor.getChildComponent();
        if (component instanceof JTextField) {
            return (JTextField)component;
        }
        if (component instanceof JComboBox) {
            JComboBox combo = (JComboBox)component;
            return (JTextField)combo.getEditor().getEditorComponent();
        }
        return null;
    }

    private static final class MyComboBox
    extends ComboBox {
        public MyComboBox() {
            ((JTextField)this.getEditor().getEditorComponent()).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ComboPopup popup;
                    if (MyComboBox.this.isPopupVisible() && (popup = MyComboBox.this.getPopup()) != null) {
                        MyComboBox.this.setSelectedItem(popup.getList().getSelectedValue());
                    }
                }
            });
        }
    }
}

