/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.propertyTable;

import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.propertyTable.IXmlAttributeLocator;
import com.intellij.designer.model.PropertiesContainer;
import com.intellij.designer.model.Property;
import com.intellij.designer.propertyTable.PropertyEditor;
import com.intellij.designer.propertyTable.PropertyRenderer;
import com.intellij.designer.propertyTable.renderers.LabelPropertyRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlAttribute;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FragmentProperty
extends Property<RadViewComponent>
implements IXmlAttributeLocator {
    private final String myAttribute;
    private final PropertyRenderer myRenderer;
    private final PropertyEditor myEditor;
    private final String myJavadocText;
    private final String myNamespace;

    public FragmentProperty(@NotNull String name, @Nullable String namespace, PropertyEditor editor, String javadocText) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/android/designer/propertyTable/FragmentProperty", "<init>"));
        }
        super(null, name);
        this.myRenderer = new LabelPropertyRenderer(null);
        this.myNamespace = namespace;
        this.myEditor = editor;
        this.myJavadocText = javadocText;
        this.setImportant(true);
        this.myAttribute = name;
    }

    public Property<RadViewComponent> createForNewPresentation(@Nullable Property parent, @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/android/designer/propertyTable/FragmentProperty", "createForNewPresentation"));
        }
        return null;
    }

    public Object getValue(@NotNull RadViewComponent component) throws Exception {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/android/designer/propertyTable/FragmentProperty", "getValue"));
        }
        String value = component.getTag().getAttributeValue(this.myAttribute, this.myNamespace);
        return value == null ? "" : value;
    }

    public void setValue(final @NotNull RadViewComponent component, final @Nullable Object value) throws Exception {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/android/designer/propertyTable/FragmentProperty", "setValue"));
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                if (StringUtil.isEmpty((String)((String)value))) {
                    XmlAttribute attribute = component.getTag().getAttribute(FragmentProperty.this.myAttribute, FragmentProperty.this.myNamespace);
                    if (attribute != null) {
                        attribute.delete();
                    }
                } else {
                    component.getTag().setAttribute(FragmentProperty.this.myAttribute, FragmentProperty.this.myNamespace, (String)value);
                }
            }
        });
    }

    public boolean isDefaultValue(@NotNull RadViewComponent component) throws Exception {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/android/designer/propertyTable/FragmentProperty", "isDefaultValue"));
        }
        return component.getTag().getAttribute(this.myAttribute, this.myNamespace) == null;
    }

    public void setDefaultValue(@NotNull RadViewComponent component) throws Exception {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/android/designer/propertyTable/FragmentProperty", "setDefaultValue"));
        }
        if (component.getTag().getAttribute(this.myAttribute, this.myNamespace) != null) {
            this.setValue(component, (Object)null);
        }
    }

    public boolean availableFor(List<PropertiesContainer> components) {
        return false;
    }

    @NotNull
    public PropertyRenderer getRenderer() {
        PropertyRenderer propertyRenderer = this.myRenderer;
        if (propertyRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/propertyTable/FragmentProperty", "getRenderer"));
        }
        return propertyRenderer;
    }

    public PropertyEditor getEditor() {
        return this.myEditor;
    }

    public String getJavadocText() {
        return this.myJavadocText;
    }

    @Override
    public boolean checkAttribute(RadViewComponent component, XmlAttribute attribute) {
        return component.getTag().getAttribute(this.myAttribute, this.myNamespace) == attribute;
    }
}

