/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.propertyTable;

import com.intellij.android.designer.propertyTable.CompoundProperty;
import com.intellij.android.designer.propertyTable.renderers.ResourceRenderer;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.propertyTable.PropertyRenderer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import java.util.EnumSet;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.annotations.NotNull;

public class CompoundDimensionProperty
extends CompoundProperty {
    private ResourceRenderer myRenderer;

    public CompoundDimensionProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/android/designer/propertyTable/CompoundDimensionProperty", "<init>"));
        }
        super(name);
        this.myRenderer = new ResourceRenderer(EnumSet.of(AttributeFormat.Dimension)){

            @Override
            protected void formatValue(RadComponent component, String value) {
                this.myColoredComponent.append("[");
                if (!StringUtil.isEmpty((String)value)) {
                    int index = 0;
                    for (String childValue : StringUtil.split((String)value, (String)",")) {
                        if (index++ > 0) {
                            this.myColoredComponent.append(", ");
                        }
                        if ((childValue = childValue.trim()).length() <= 0) continue;
                        if (childValue.equals("?")) {
                            this.myColoredComponent.append("?", SimpleTextAttributes.EXCLUDED_ATTRIBUTES);
                            continue;
                        }
                        super.formatValue(component, childValue);
                    }
                }
                this.myColoredComponent.append("]");
            }
        };
    }

    @Override
    protected CompoundProperty createForNewPresentation(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/android/designer/propertyTable/CompoundDimensionProperty", "createForNewPresentation"));
        }
        return new CompoundDimensionProperty(name);
    }

    @Override
    @NotNull
    public PropertyRenderer getRenderer() {
        ResourceRenderer resourceRenderer = this.myRenderer;
        if (resourceRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/propertyTable/CompoundDimensionProperty", "getRenderer"));
        }
        return resourceRenderer;
    }
}

