/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model.morphing;

import com.intellij.android.designer.model.ComponentMorphingTool;
import com.intellij.android.designer.model.RadComponentOperations;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.layout.grid.RadGridLayout;
import com.intellij.android.designer.model.layout.grid.RadGridLayoutComponent;
import com.intellij.android.designer.model.layout.table.RadTableLayoutComponent;
import com.intellij.android.designer.model.layout.table.RadTableRowLayout;
import com.intellij.designer.model.MetaModel;
import com.intellij.designer.model.RadComponent;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;

public class TableLayout {
    private static final String TABLE_ROW_KEY = "TableRow";

    public static RadViewComponent GridLayout(RadViewComponent component, MetaModel target) throws Exception {
        final RadComponent[][] components = ((RadTableLayoutComponent)component).getGridComponents(false);
        return new ComponentMorphingTool(component, new RadGridLayoutComponent(), target, new RadGridLayout()){

            @Override
            protected void convertChildren() throws Exception {
                for (RadComponent rowComponent : new ArrayList<RadComponent>(this.myOldComponent.getChildren())) {
                    if (RadTableRowLayout.is(rowComponent)) {
                        for (RadComponent cellComponent : new ArrayList<RadComponent>(rowComponent.getChildren())) {
                            RadComponentOperations.moveComponent(this.myOldComponent, (RadViewComponent)cellComponent, (RadViewComponent)rowComponent);
                        }
                        rowComponent.delete();
                        continue;
                    }
                    rowComponent.setClientProperty(TableLayout.TABLE_ROW_KEY, Boolean.TRUE);
                }
                super.convertChildren();
            }

            @Override
            protected void convertTag() {
                XmlTag tag = this.myNewComponent.getTag();
                if (components.length > 0) {
                    String columnCount = Integer.toString(components[0].length);
                    tag.setAttribute("rowCount", "http://schemas.android.com/apk/res/android", Integer.toString(components.length));
                    tag.setAttribute("columnCount", "http://schemas.android.com/apk/res/android", columnCount);
                    block0: for (int i = 0; i < components.length; ++i) {
                        RadComponent[] rowComponents = components[i];
                        RadComponent firstCellComponent = rowComponents[0];
                        if (firstCellComponent != null && firstCellComponent.extractClientProperty(TableLayout.TABLE_ROW_KEY) == Boolean.TRUE) {
                            XmlTag cellTag = ((RadViewComponent)firstCellComponent).getTag();
                            RadComponentOperations.deleteAttribute(cellTag, "layout_span");
                            cellTag.setAttribute("layout_column", "http://schemas.android.com/apk/res/android", "0");
                            cellTag.setAttribute("layout_columnSpan", "http://schemas.android.com/apk/res/android", columnCount);
                            cellTag.setAttribute("layout_gravity", "http://schemas.android.com/apk/res/android", "fill_horizontal");
                        }
                        for (RadComponent cellComponent : rowComponents) {
                            if (cellComponent == null) continue;
                            XmlTag cellTag = ((RadViewComponent)cellComponent).getTag();
                            cellTag.setAttribute("layout_row", "http://schemas.android.com/apk/res/android", Integer.toString(i));
                            continue block0;
                        }
                    }
                    for (RadComponent childComponent : this.myNewComponent.getChildren()) {
                        XmlAttribute attribute = ((RadViewComponent)childComponent).getTag().getAttribute("layout_span", "http://schemas.android.com/apk/res/android");
                        if (attribute == null) continue;
                        attribute.setName(attribute.getNamespacePrefix() + ":layout_columnSpan");
                    }
                }
            }
        }.result();
    }
}

