/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model.layout.table;

import com.intellij.android.designer.model.grid.GridInfo;
import com.intellij.android.designer.model.grid.RadCaptionColumn;
import com.intellij.android.designer.model.layout.table.RadTableLayoutComponent;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.model.IGroupDeleteComponent;
import com.intellij.designer.model.RadComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RadCaptionTableColumn
extends RadCaptionColumn<RadTableLayoutComponent>
implements IGroupDeleteComponent {
    public RadCaptionTableColumn(EditableArea mainArea, RadTableLayoutComponent container, int index, int offset, int width, boolean empty) {
        super(mainArea, container, index, offset, width, empty);
    }

    private void deleteColumn(List<RadComponent> deletedComponents) throws Exception {
        RadComponent[][] components;
        GridInfo info = ((RadTableLayoutComponent)this.myContainer).getVirtualGridInfo();
        for (RadComponent[] rowComponents : components = info.components) {
            int nextIndex;
            RadComponent component = rowComponents[this.myIndex];
            if (component == null) continue;
            for (nextIndex = this.myIndex + 1; nextIndex < rowComponents.length && component == rowComponents[nextIndex]; ++nextIndex) {
            }
            if (this.myIndex > 0 && component == rowComponents[this.myIndex - 1]) {
                RadTableLayoutComponent.setCellSpan(component, RadTableLayoutComponent.getCellSpan(component) - 1);
                continue;
            }
            Arrays.fill((Object[])rowComponents, this.myIndex, nextIndex, null);
            RadComponent parent = component.getParent();
            component.delete();
            deletedComponents.add(component);
            if (!parent.getChildren().isEmpty()) continue;
            parent.delete();
            deletedComponents.add(parent);
        }
    }

    @Override
    public void delete(List<RadComponent> columns) throws Exception {
        ArrayList<RadComponent> deletedComponents = new ArrayList<RadComponent>();
        RadComponent[][] components = ((RadTableLayoutComponent)this.myContainer).getGridComponents(false);
        for (RadComponent component : columns) {
            RadCaptionTableColumn column = (RadCaptionTableColumn)component;
            column.deleteColumn(deletedComponents);
        }
        for (int i = 0; i < components.length; ++i) {
            RadComponent[] rowComponents = components[i];
            RadComponent[] newRowComponents = new RadComponent[rowComponents.length - columns.size()];
            components[i] = newRowComponents;
            int index = 0;
            for (int j = 0; j < rowComponents.length; ++j) {
                boolean add = true;
                for (RadComponent column : columns) {
                    if (j != ((RadCaptionTableColumn)column).myIndex) continue;
                    add = false;
                    break;
                }
                if (!add) continue;
                newRowComponents[index++] = rowComponents[j];
            }
        }
        for (RadComponent[] rowComponents : components) {
            for (int j = 0; j < rowComponents.length; ++j) {
                RadComponent cellComponent = rowComponents[j];
                if (cellComponent == null) continue;
                RadTableLayoutComponent.setCellIndex(cellComponent, j);
            }
        }
        this.deselect(deletedComponents);
    }
}

