/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model.layout.relative;

import com.android.tools.idea.designer.MarginType;
import com.android.tools.idea.designer.Segment;
import com.android.tools.idea.designer.SegmentType;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.layout.relative.GuidelineHandler;
import com.intellij.android.designer.model.layout.relative.Match;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.model.RadComponent;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResizeHandler
extends GuidelineHandler {
    @Nullable
    private final SegmentType myHorizontalEdgeType;
    @Nullable
    private final SegmentType myVerticalEdgeType;

    public ResizeHandler(@NotNull RadViewComponent layout, @NotNull RadViewComponent resized, @NotNull OperationContext context, @Nullable SegmentType horizontalEdgeType, @Nullable SegmentType verticalEdgeType) {
        Set<RadViewComponent> nodes;
        if (layout == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/android/designer/model/layout/relative/ResizeHandler", "<init>"));
        }
        if (resized == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/android/designer/model/layout/relative/ResizeHandler", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/android/designer/model/layout/relative/ResizeHandler", "<init>"));
        }
        super(layout, context);
        assert (horizontalEdgeType != null || verticalEdgeType != null);
        assert (horizontalEdgeType != SegmentType.BASELINE && verticalEdgeType != SegmentType.BASELINE);
        assert (horizontalEdgeType != SegmentType.CENTER_HORIZONTAL && verticalEdgeType != SegmentType.CENTER_HORIZONTAL);
        assert (horizontalEdgeType != SegmentType.CENTER_VERTICAL && verticalEdgeType != SegmentType.CENTER_VERTICAL);
        this.myHorizontalEdgeType = horizontalEdgeType;
        this.myVerticalEdgeType = verticalEdgeType;
        this.myDraggedNodes = nodes = Collections.singleton(resized);
        this.myHorizontalDeps = this.myDependencyGraph.dependsOn(nodes, false);
        this.myVerticalDeps = this.myDependencyGraph.dependsOn(nodes, true);
        if (horizontalEdgeType != null) {
            if (horizontalEdgeType == SegmentType.TOP) {
                this.myMoveTop = true;
            } else if (horizontalEdgeType == SegmentType.BOTTOM) {
                this.myMoveBottom = true;
            }
        }
        if (verticalEdgeType != null) {
            if (verticalEdgeType == SegmentType.LEFT) {
                this.myMoveLeft = true;
            } else if (verticalEdgeType == SegmentType.RIGHT) {
                this.myMoveRight = true;
            }
        }
        for (RadComponent child : layout.getChildren()) {
            if (child == resized || !(child instanceof RadViewComponent)) continue;
            RadViewComponent view = (RadViewComponent)child;
            String id = view.getId();
            this.addBounds(view, id, !this.myHorizontalDeps.contains((Object)view), !this.myVerticalDeps.contains((Object)view), false);
        }
        this.addBounds(layout, layout.getId(), true, true, true);
    }

    @Override
    protected void snapVertical(Segment vEdge, int x, Rectangle newBounds) {
        int maxDistance = 20;
        if (vEdge.edgeType == SegmentType.LEFT) {
            int margin;
            int n = margin = this.mySnap ? 0 : Math.abs(newBounds.x - x);
            if (margin > maxDistance) {
                this.myLeftMargin = margin;
            } else {
                newBounds.width += newBounds.x - x;
                newBounds.x = x;
            }
        } else if (vEdge.edgeType == SegmentType.RIGHT) {
            int margin;
            int n = margin = this.mySnap ? 0 : Math.abs(newBounds.x - (x - newBounds.width));
            if (margin > maxDistance) {
                this.myRightMargin = margin;
            } else {
                newBounds.width = x - newBounds.x;
            }
        } else assert (false) : vEdge;
    }

    @Override
    protected void snapHorizontal(Segment hEdge, int y, Rectangle newBounds) {
        int maxDistance = 20;
        if (hEdge.edgeType == SegmentType.TOP) {
            int margin;
            int n = margin = this.mySnap ? 0 : Math.abs(newBounds.y - y);
            if (margin > maxDistance) {
                this.myTopMargin = margin;
            } else {
                newBounds.height += newBounds.y - y;
                newBounds.y = y;
            }
        } else if (hEdge.edgeType == SegmentType.BOTTOM) {
            int margin;
            int n = margin = this.mySnap ? 0 : Math.abs(newBounds.y - (y - newBounds.height));
            if (margin > maxDistance) {
                this.myBottomMargin = margin;
            } else {
                newBounds.height = y - newBounds.y;
            }
        } else assert (false) : hEdge;
    }

    @Override
    protected boolean isEdgeTypeCompatible(SegmentType edge, SegmentType dragged, int delta) {
        boolean compatible = super.isEdgeTypeCompatible(edge, dragged, delta);
        if (compatible && !this.mySnap) {
            switch (dragged) {
                case LEFT: 
                case TOP: {
                    return delta <= 0;
                }
            }
            return delta >= 0;
        }
        return compatible;
    }

    public void updateResize(RadViewComponent child, Rectangle newBounds, int modifierMask) {
        Match match;
        this.mySnap = (modifierMask & 1) == 0;
        this.myBounds = newBounds;
        this.clearSuggestions();
        Rectangle b = newBounds;
        Segment hEdge = null;
        Segment vEdge = null;
        String childId = child.getId();
        if (this.myHorizontalEdgeType == SegmentType.TOP) {
            hEdge = new Segment(b.y, b.x, ResizeHandler.x2(b), child, childId, this.myHorizontalEdgeType, MarginType.NO_MARGIN);
        } else if (this.myHorizontalEdgeType == SegmentType.BOTTOM) {
            hEdge = new Segment(ResizeHandler.y2(b), b.x, ResizeHandler.x2(b), child, childId, this.myHorizontalEdgeType, MarginType.NO_MARGIN);
        } else assert (this.myHorizontalEdgeType == null);
        if (this.myVerticalEdgeType == SegmentType.LEFT) {
            vEdge = new Segment(b.x, b.y, ResizeHandler.y2(b), child, childId, this.myVerticalEdgeType, MarginType.NO_MARGIN);
        } else if (this.myVerticalEdgeType == SegmentType.RIGHT) {
            vEdge = new Segment(ResizeHandler.x2(b), b.y, ResizeHandler.y2(b), child, childId, this.myVerticalEdgeType, MarginType.NO_MARGIN);
        } else assert (this.myVerticalEdgeType == null);
        this.myRightMargin = 0;
        this.myLeftMargin = 0;
        this.myBottomMargin = 0;
        this.myTopMargin = 0;
        if (hEdge != null && this.myHorizontalEdges.size() > 0) {
            this.myHorizontalSuggestions = this.findClosest(hEdge, this.myHorizontalEdges);
            match = this.pickBestMatch(this.myHorizontalSuggestions);
            if (!(match == null || this.mySnap && Math.abs(match.delta) >= 20)) {
                if (this.myHorizontalDeps.contains((Object)match.edge.node)) {
                    match.cycle = true;
                }
                this.snapHorizontal(hEdge, match.edge.at, newBounds);
                if (hEdge.edgeType == SegmentType.TOP) {
                    this.myCurrentTopMatch = match;
                } else if (hEdge.edgeType == SegmentType.BOTTOM) {
                    this.myCurrentBottomMatch = match;
                } else {
                    assert (hEdge.edgeType == SegmentType.CENTER_HORIZONTAL || hEdge.edgeType == SegmentType.BASELINE) : hEdge;
                    this.myCurrentTopMatch = match;
                }
            }
        }
        if (vEdge != null && this.myVerticalEdges.size() > 0) {
            this.myVerticalSuggestions = this.findClosest(vEdge, this.myVerticalEdges);
            match = this.pickBestMatch(this.myVerticalSuggestions);
            if (!(match == null || this.mySnap && Math.abs(match.delta) >= 20)) {
                if (this.myVerticalDeps.contains((Object)match.edge.node)) {
                    match.cycle = true;
                }
                this.snapVertical(vEdge, match.edge.at, newBounds);
                if (vEdge.edgeType == SegmentType.LEFT) {
                    this.myCurrentLeftMatch = match;
                } else if (vEdge.edgeType == SegmentType.RIGHT) {
                    this.myCurrentRightMatch = match;
                } else {
                    assert (vEdge.edgeType == SegmentType.CENTER_VERTICAL);
                    this.myCurrentLeftMatch = match;
                }
            }
        }
        this.checkCycles();
    }
}

