/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model.layout.relative;

import com.intellij.android.designer.designSurface.TreeDropToOperation;
import com.intellij.android.designer.designSurface.graphics.DrawingStyle;
import com.intellij.android.designer.designSurface.graphics.ResizeSelectionDecorator;
import com.intellij.android.designer.model.PropertyParser;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.RadViewLayoutWithData;
import com.intellij.android.designer.model.layout.actions.AllGravityAction;
import com.intellij.android.designer.model.layout.relative.CenterProperty;
import com.intellij.android.designer.model.layout.relative.CompoundProperty;
import com.intellij.android.designer.model.layout.relative.RelativeLayoutDecorator;
import com.intellij.android.designer.model.layout.relative.RelativeLayoutDropOperation;
import com.intellij.android.designer.model.layout.relative.RelativeLayoutResizeOperation;
import com.intellij.android.designer.propertyTable.AttributeProperty;
import com.intellij.android.designer.propertyTable.JavadocParser;
import com.intellij.android.designer.propertyTable.RelativeIdAttributeProperty;
import com.intellij.designer.componentTree.TreeEditOperation;
import com.intellij.designer.designSurface.ComponentDecorator;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.designSurface.EditOperation;
import com.intellij.designer.designSurface.ILayoutDecorator;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.designSurface.StaticDecorator;
import com.intellij.designer.model.Property;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.propertyTable.PropertyTable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RadRelativeLayout
extends RadViewLayoutWithData
implements ILayoutDecorator {
    private static final String[] LAYOUT_PARAMS = new String[]{"RelativeLayout_Layout", "ViewGroup_MarginLayout"};
    private RelativeLayoutDecorator myRelativeDecorator;
    private ResizeSelectionDecorator mySelectionDecorator;

    @Override
    @NotNull
    public String[] getLayoutParams() {
        if (LAYOUT_PARAMS == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/model/layout/relative/RadRelativeLayout", "getLayoutParams"));
        }
        return LAYOUT_PARAMS;
    }

    @Override
    public void configureProperties(List<Property> properties) {
        CompoundProperty alignComponent = new CompoundProperty("layout:alignComponent", JavadocParser.build("layout:alignComponent", "Positions the edges of this view to the edges of the another view."));
        PropertyParser.moveProperties(properties, alignComponent, "layout:alignTop", "top:top", "layout:below", "top:bottom", "layout:alignLeft", "left:left", "layout:toRightOf", "left:right", "layout:alignBottom", "bottom:bottom", "layout:above", "bottom:top", "layout:alignRight", "right:right", "layout:toLeftOf", "right:left", "layout:alignBaseline", "baseline:baseline");
        List<Property<RadViewComponent>> alignChildren = alignComponent.getChildren((RadViewComponent)null);
        int alignSize = alignChildren.size();
        for (int i = 0; i < alignSize; ++i) {
            alignChildren.set(i, new RelativeIdAttributeProperty((AttributeProperty)alignChildren.get(i)));
        }
        properties.add(alignComponent);
        CompoundProperty alignParent = new CompoundProperty("layout:alignParent", JavadocParser.build("layout:alignParent", "Positions the edges of this view to the edges of the parent."));
        PropertyParser.moveProperties(properties, alignParent, "layout:alignParentTop", "top", "layout:alignParentLeft", "left", "layout:alignParentBottom", "bottom", "layout:alignParentRight", "right", "layout:alignWithParentIfMissing", "missing");
        properties.add(alignParent);
        PropertyTable.extractProperty(properties, (String)"layout:centerInParent");
        PropertyTable.extractProperty(properties, (String)"layout:centerHorizontal");
        PropertyTable.extractProperty(properties, (String)"layout:centerVertical");
        properties.add(new CenterProperty());
    }

    @Override
    public EditOperation processChildOperation(OperationContext context) {
        if (context.isCreate() || context.isPaste() || context.isAdd() || context.isMove()) {
            if (context.isTree()) {
                if (TreeEditOperation.isTarget(this.myContainer, context)) {
                    return new TreeDropToOperation(this.myContainer, context);
                }
                return null;
            }
            return new RelativeLayoutDropOperation(this.myContainer, context);
        }
        if (context.is("relative_resize")) {
            return new RelativeLayoutResizeOperation(context);
        }
        return null;
    }

    private StaticDecorator getRelativeDecorator() {
        if (this.myRelativeDecorator == null) {
            this.myRelativeDecorator = new RelativeLayoutDecorator(this.myContainer);
        }
        return this.myRelativeDecorator;
    }

    @Override
    public void addStaticDecorators(List<StaticDecorator> decorators, List<RadComponent> selection) {
        for (RadComponent component : selection) {
            if (component.getParent() != this.myContainer) continue;
            if (!(this.myContainer.getParent().getLayout() instanceof ILayoutDecorator)) {
                decorators.add(this.getRelativeDecorator());
            }
            return;
        }
        super.addStaticDecorators(decorators, selection);
    }

    @Override
    public ComponentDecorator getChildSelectionDecorator(RadComponent component, List<RadComponent> selection) {
        if (this.mySelectionDecorator == null) {
            this.mySelectionDecorator = new ResizeSelectionDecorator(DrawingStyle.SELECTION);
            RelativeLayoutResizeOperation.addResizePoints(this.mySelectionDecorator);
        }
        return this.mySelectionDecorator;
    }

    @Override
    public void addContainerSelectionActions(DesignerEditorPanel designer, DefaultActionGroup actionGroup, List<? extends RadViewComponent> selection) {
        super.addContainerSelectionActions(designer, actionGroup, selection);
        actionGroup.add((AnAction)new AllGravityAction(designer, selection));
    }
}

