/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model.layout.actions;

import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.layout.actions.LayoutAction;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.psi.xml.XmlAttribute;
import icons.AndroidDesignerIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class OrientationAction
extends LayoutAction {
    private final RadViewComponent myLayout;
    private boolean myHorizontal;
    private final boolean myDefaultHorizontal;

    public OrientationAction(@NotNull DesignerEditorPanel designer, @NotNull RadViewComponent layout, boolean defaultHorizontal) {
        if (designer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/android/designer/model/layout/actions/OrientationAction", "<init>"));
        }
        if (layout == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/android/designer/model/layout/actions/OrientationAction", "<init>"));
        }
        super(designer, "Change attribute 'orientation'", null, AndroidDesignerIcons.SwitchHorizontalLinear);
        this.myLayout = layout;
        this.myDefaultHorizontal = defaultHorizontal;
        this.update(this.getTemplatePresentation());
        this.myHorizontal = !"vertical".equals(layout.getTag().getAttributeValue("orientation", "http://schemas.android.com/apk/res/android"));
    }

    @Override
    public void actionPerformed(AnActionEvent e) {
        this.myHorizontal = !this.myHorizontal;
        this.update(e.getPresentation());
        super.actionPerformed(e);
    }

    @Override
    protected void performWriteAction() {
        String value;
        String string = value = this.myHorizontal ? "horizontal" : "vertical";
        if (this.myHorizontal == this.myDefaultHorizontal) {
            XmlAttribute attribute = this.myLayout.getTag().getAttribute("orientation", "http://schemas.android.com/apk/res/android");
            if (attribute != null) {
                attribute.delete();
            }
        } else {
            this.myLayout.getTag().setAttribute("orientation", "http://schemas.android.com/apk/res/android", value);
        }
    }

    protected void update(Presentation presentation) {
        presentation.setDescription("Convert orientation to " + (this.myHorizontal ? "vertical" : "horizontal"));
        Icon icon = this.myHorizontal ? AndroidDesignerIcons.SwitchHorizontalLinear : AndroidDesignerIcons.SwitchVerticalLinear;
        presentation.setIcon(icon);
        presentation.setHoveredIcon(icon);
    }
}

