/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model.layout.actions;

import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.ThrowableRunnable;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LayoutAction
extends AnAction {
    protected final DesignerEditorPanel myDesigner;

    protected LayoutAction(@NotNull DesignerEditorPanel designer, @NotNull String description, @Nullable String label, @Nullable Icon icon) {
        if (designer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/android/designer/model/layout/actions/LayoutAction", "<init>"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/android/designer/model/layout/actions/LayoutAction", "<init>"));
        }
        this.myDesigner = designer;
        Presentation presentation = this.getTemplatePresentation();
        presentation.setDescription(description);
        if (label != null) {
            presentation.setText(label);
        }
        if (icon != null) {
            presentation.setIcon(icon);
        }
    }

    public void actionPerformed(AnActionEvent e) {
        this.myDesigner.getToolProvider().execute(new ThrowableRunnable<Exception>(){

            public void run() throws Exception {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        LayoutAction.this.performWriteAction();
                    }
                });
            }
        }, this.getTemplatePresentation().getDescription(), true);
    }

    protected abstract void performWriteAction();
}

